/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.listener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.task.coordination.TokenAcquisition;
import io.ballerina.stdlib.task.exceptions.SchedulingException;
import io.ballerina.stdlib.task.listener.ListenerAction;
import io.ballerina.stdlib.task.objects.TaskManager;
import io.ballerina.stdlib.task.utils.TaskConstants;
import io.ballerina.stdlib.task.utils.Utils;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class TaskListener {
    private static final String VALUE = "1000";
    private final TaskManager taskManager;
    private final Map<String, BObject> serviceRegistry = new ConcurrentHashMap<String, BObject>();
    private final BMap<BString, Object> configs = ValueCreator.createMapValue();

    public TaskListener(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public void start(Environment env, BObject job, BDecimal interval, long maxCount, Object startTime, Object endTime, BMap<BString, Object> policy, Object retryConfig) throws Exception {
        TaskListener.getScheduler(env);
        for (String serviceName : this.serviceRegistry.keySet()) {
            JobDataMap jobDataMap = TaskListener.getJobDataMap(job, ((BString)policy.get((Object)TaskConstants.ERR_POLICY)).getValue(), serviceName);
            TaskListener.extractRetryConfigs(interval, maxCount, retryConfig, jobDataMap);
            BObject service = this.serviceRegistry.get(serviceName);
            this.taskManager.scheduleListenerIntervalJob(jobDataMap, interval.decimalValue().multiply(new BigDecimal(VALUE)).longValue(), maxCount, startTime, endTime, ((BString)policy.get((Object)TaskConstants.WAITING_POLICY)).getValue(), serviceName, service);
        }
    }

    public void start(Environment env, BObject job, BDecimal interval, long maxCount, Object startTime, Object endTime, BMap<BString, Object> policy, BMap warmBackupConfig, Object retryConfig) throws Exception {
        TaskListener.getScheduler(env);
        for (String serviceName : this.serviceRegistry.keySet()) {
            JobDataMap jobDataMap = TaskListener.getJobDataMap(job, ((BString)policy.get((Object)TaskConstants.ERR_POLICY)).getValue(), serviceName);
            TaskListener.extractRetryConfigs(interval, maxCount, retryConfig, jobDataMap);
            BObject service = this.serviceRegistry.get(serviceName);
            BMap databaseConfig = warmBackupConfig.getMapValue(TokenAcquisition.DATABASE_CONFIG);
            BString id = warmBackupConfig.getStringValue(TokenAcquisition.TASK_ID);
            BString groupId = warmBackupConfig.getStringValue(TokenAcquisition.GROUP_ID);
            int livenessInterval = ((Long)warmBackupConfig.get((Object)TokenAcquisition.LIVENESS_CHECK_INTERVAL)).intValue();
            int heartbeatFrequency = ((Long)warmBackupConfig.get((Object)TokenAcquisition.HEARTBEAT_FREQUENCY)).intValue();
            BMap response = (BMap)TokenAcquisition.acquireToken((BMap<Object, Object>)databaseConfig, id, groupId, false, livenessInterval, heartbeatFrequency);
            this.taskManager.scheduleListenerIntervalJobWithTokenCheck(jobDataMap, interval.decimalValue().multiply(new BigDecimal(VALUE)).longValue(), maxCount, startTime, endTime, ((BString)policy.get((Object)TaskConstants.WAITING_POLICY)).getValue(), serviceName, response, service);
        }
    }

    private static void extractRetryConfigs(BDecimal interval, long maxCount, Object retryConfig, JobDataMap jobDataMap) {
        if (retryConfig instanceof BMap) {
            BMap config = (BMap)retryConfig;
            jobDataMap.put("maxAttempts", (Object)config.getIntValue(ListenerAction.MAX_ATTEMPTS));
            jobDataMap.put("backoffStrategy", (Object)config.getStringValue(ListenerAction.BACKOFF_STRATEGY));
            jobDataMap.put("retryInterval", (Object)config.getIntValue(ListenerAction.RETRY_INTERVAL));
            jobDataMap.put("maxInterval", (Object)config.getIntValue(ListenerAction.MAX_INTERVAL));
        }
        jobDataMap.put("maxCount", maxCount);
        jobDataMap.put("interval", (Object)interval);
    }

    public Map<String, BObject> getServices() {
        return this.serviceRegistry;
    }

    public void setConfig(BString key, Object value) {
        this.configs.put((Object)key, value);
    }

    public void setConfigs(BMap<?, ?> values) {
        this.configs.merge(values, false);
    }

    public BMap<BString, Object> getConfig() {
        return this.configs;
    }

    public void registerService(String serviceName, BObject service) {
        this.serviceRegistry.put(serviceName, service);
    }

    public void unregisterService(Object service) throws Exception {
        String serviceId = null;
        for (Map.Entry<String, BObject> entry : this.serviceRegistry.entrySet()) {
            if (!entry.getValue().equals(service)) continue;
            serviceId = entry.getKey();
            break;
        }
        if (serviceId == null) {
            throw new Exception("Service is not found in the listener");
        }
        this.serviceRegistry.remove(serviceId);
        this.taskManager.unScheduleJob(serviceId);
    }

    public void unregisterAllServices() {
        this.serviceRegistry.clear();
    }

    static Scheduler getScheduler(Environment env) throws SchedulingException, SchedulerException {
        Utils.disableQuartzLogs();
        return TaskManager.getInstance().getScheduler(Utils.createSchedulerProperties("5", "5000"), env);
    }

    private static JobDataMap getJobDataMap(BObject job, String errorPolicy, String jobId) {
        Utils.disableQuartzLogs();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("job", (Object)job);
        jobDataMap.put("errorPolicy", errorPolicy);
        jobDataMap.put("jobId", jobId);
        return jobDataMap;
    }
}

