/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.task.exceptions.SchedulingException;
import io.ballerina.stdlib.task.server.TaskServerJob;
import io.ballerina.stdlib.task.utils.ModuleUtils;
import io.ballerina.stdlib.task.utils.TaskJob;
import io.ballerina.stdlib.task.utils.TaskListener;
import java.io.PrintStream;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public final class Utils {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final PrintStream console = System.out;

    private Utils() {
    }

    public static BError createTaskError(String message) {
        return ErrorCreator.createDistinctError((String)"Error", (Module)ModuleUtils.getModule(), (BString)StringUtils.fromString((String)message));
    }

    public static Properties createSchedulerProperties(String threadCount, String thresholdInMillis) {
        Properties properties = new Properties();
        properties.setProperty("org.quartz.jobStore.misfireThreshold", thresholdInMillis);
        properties.setProperty("org.quartz.threadPool.threadCount", threadCount);
        return properties;
    }

    public static Scheduler initializeScheduler(Properties properties) throws SchedulingException {
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory(properties);
            Scheduler scheduler = stdSchedulerFactory.getScheduler();
            scheduler.getListenerManager().addTriggerListener((TriggerListener)new TaskListener(), (Matcher)GroupMatcher.triggerGroupEquals((String)"log"));
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new SchedulingException("Cannot create the Scheduler." + e.getMessage());
        }
    }

    public static JobDetail createJob(JobDataMap jobDataMap, String jobId) {
        return JobBuilder.newJob(TaskJob.class).withIdentity(jobId).usingJobData(jobDataMap).build();
    }

    public static JobDetail createListenerJob(JobDataMap jobDataMap, String jobId) {
        return JobBuilder.newJob(TaskServerJob.class).withIdentity(jobId).usingJobData(jobDataMap).build();
    }

    public static Trigger getOneTimeTrigger(long time, String triggerID) {
        String triggerKey = UUID.randomUUID().toString();
        Date startTime = new Date(time);
        return TriggerBuilder.newTrigger().withIdentity(triggerKey, triggerID).startAt(startTime).build();
    }

    public static Trigger getIntervalTrigger(long interval, long maxCount, Object startTime, Object endTime, String waitingPolicy, String triggerID) {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval);
        Utils.setMaxCount(simpleScheduleBuilder, maxCount);
        Utils.setMisfire(simpleScheduleBuilder, waitingPolicy);
        if (waitingPolicy.equalsIgnoreCase("LOG_AND_IGNORE")) {
            triggerID = "log";
        }
        return Utils.getTrigger(simpleScheduleBuilder, startTime, endTime, triggerID);
    }

    public static void setMisfire(SimpleScheduleBuilder simpleScheduleBuilder, String waitingPolicy) {
        if ("WAIT".equalsIgnoreCase(waitingPolicy)) {
            simpleScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
        }
    }

    public static void setMaxCount(SimpleScheduleBuilder simpleScheduleBuilder, long maxCount) {
        if (maxCount > 0L) {
            simpleScheduleBuilder.withRepeatCount((int)(maxCount - 1L));
        } else {
            simpleScheduleBuilder.repeatForever();
        }
    }

    public static Trigger getTrigger(SimpleScheduleBuilder simpleScheduleBuilder, Object startTime, Object endTime, String triggerID) {
        Trigger trigger;
        String triggerKey = UUID.randomUUID().toString();
        if (Utils.isInt(startTime) && Utils.isInt(endTime)) {
            Date startDate = new Date((Long)startTime);
            Date endDate = new Date((Long)endTime);
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey, triggerID).startAt(startDate).endAt(endDate).withSchedule((ScheduleBuilder)simpleScheduleBuilder).build();
        } else if (Utils.isInt(startTime)) {
            Date startDate = new Date((Long)startTime);
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey, triggerID).startAt(startDate).withSchedule((ScheduleBuilder)simpleScheduleBuilder).build();
        } else if (Utils.isInt(endTime)) {
            Date endDate = new Date((Long)endTime);
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey, triggerID).endAt(endDate).withSchedule((ScheduleBuilder)simpleScheduleBuilder).build();
        } else {
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey, triggerID).withSchedule((ScheduleBuilder)simpleScheduleBuilder).build();
        }
        return trigger;
    }

    public static void printMessage(String msg, PrintStream console) {
        OffsetDateTime utcNow = OffsetDateTime.now(ZoneOffset.UTC);
        console.println("time = " + formatter.format(utcNow) + " message = " + msg);
    }

    public static void disableQuartzLogs() {
        Logger.getLogger("").setLevel(Level.OFF);
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        for (String name : Collections.list(names)) {
            if (!name.contains("quartz")) continue;
            LogManager.getLogManager().getLogger(name).setLevel(Level.OFF);
        }
    }

    public static boolean isInt(Object time) {
        return TypeUtils.getType((Object)time).getTag() == 1;
    }

    public static void notifyFailure(JobExecutionContext jobExecutionContext, BError bError) {
        block4: {
            Scheduler scheduler = jobExecutionContext.getScheduler();
            String errorPolicy = (String)jobExecutionContext.getMergedJobDataMap().get((Object)"errorPolicy");
            String jobId = (String)jobExecutionContext.getMergedJobDataMap().get((Object)"jobId");
            if (Utils.isLogged(errorPolicy)) {
                Utils.printMessage("Unable to execute the job[" + jobId + "]. " + bError.getMessage(), console);
            }
            if (Utils.isTerminated(errorPolicy)) {
                try {
                    scheduler.unscheduleJob(jobExecutionContext.getTrigger().getKey());
                }
                catch (SchedulerException e) {
                    if (!errorPolicy.equalsIgnoreCase("LOG_AND_TERMINATE")) break block4;
                    Utils.printMessage(e.toString(), console);
                }
            }
        }
    }

    private static boolean isLogged(String errorPolicy) {
        return errorPolicy.equalsIgnoreCase("LOG_AND_TERMINATE") || errorPolicy.equalsIgnoreCase("LOG_AND_CONTINUE");
    }

    private static boolean isTerminated(String errorPolicy) {
        return errorPolicy.equalsIgnoreCase("LOG_AND_TERMINATE") || errorPolicy.equalsIgnoreCase("TERMINATE");
    }
}

