/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;

public class ImportFormattingOptions {
    private final boolean groupImports;
    private final boolean sortImports;
    private final boolean removeUnusedImports;

    private ImportFormattingOptions(boolean groupImports, boolean sortImports, boolean removeUnusedImports) {
        this.groupImports = groupImports;
        this.sortImports = sortImports;
        this.removeUnusedImports = removeUnusedImports;
    }

    public boolean groupImports() {
        return this.groupImports;
    }

    public boolean sortImports() {
        return this.sortImports;
    }

    public boolean getRemoveUnusedImports() {
        return this.removeUnusedImports;
    }

    public static ImportFormattingOptionsBuilder builder() {
        return new ImportFormattingOptionsBuilder();
    }

    public static class ImportFormattingOptionsBuilder {
        private static final String GROUP_IMPORTS = "groupImports";
        private static final String SORT_IMPORTS = "sortImports";
        private static final String REMOVE_UNUSED_IMPORTS = "removeUnusedImports";
        private boolean groupImports = FormatterUtils.getDefaultBoolean(FormatSection.IMPORT, "groupImports");
        private boolean sortImports = FormatterUtils.getDefaultBoolean(FormatSection.IMPORT, "sortImports");
        private boolean removeUnusedImports = FormatterUtils.getDefaultBoolean(FormatSection.IMPORT, "removeUnusedImports");

        public ImportFormattingOptionsBuilder setGroupImports(boolean groupImports) {
            this.groupImports = groupImports;
            return this;
        }

        public ImportFormattingOptionsBuilder setSortImports(boolean sortImports) {
            this.sortImports = sortImports;
            return this;
        }

        public ImportFormattingOptionsBuilder setRemoveUnusedImports(boolean removeUnusedImports) {
            this.removeUnusedImports = removeUnusedImports;
            return this;
        }

        public ImportFormattingOptions build() {
            return new ImportFormattingOptions(this.groupImports, this.sortImports, this.removeUnusedImports);
        }

        public ImportFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            block8: for (Map.Entry<String, Object> importEntry : configs.entrySet()) {
                String importKey;
                switch (importKey = importEntry.getKey()) {
                    case "sortImports": {
                        this.setSortImports((Boolean)importEntry.getValue());
                        continue block8;
                    }
                    case "groupImports": {
                        this.setGroupImports((Boolean)importEntry.getValue());
                        continue block8;
                    }
                }
                throw new FormatterException("invalid import formatting option: " + importKey);
            }
            return this.build();
        }
    }
}

