/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;

public class QueryFormattingOptions {
    private final boolean alignMultiLineQueries;

    private QueryFormattingOptions(boolean alignMultiLineQueries) {
        this.alignMultiLineQueries = alignMultiLineQueries;
    }

    public boolean alignMultiLineQueries() {
        return this.alignMultiLineQueries;
    }

    public static QueryFormattingOptionsBuilder builder() {
        return new QueryFormattingOptionsBuilder();
    }

    public static class QueryFormattingOptionsBuilder {
        private static final String ALIGN_MULTILINE_QUERIES = "alignMultiLineQueries";
        private boolean alignMultiLineQueries = FormatterUtils.getDefaultBoolean(FormatSection.QUERY, "alignMultiLineQueries");

        public QueryFormattingOptionsBuilder setAlignMultiLineQueries(boolean alignMultiLineQueries) {
            this.alignMultiLineQueries = alignMultiLineQueries;
            return this;
        }

        public QueryFormattingOptions build() {
            return new QueryFormattingOptions(this.alignMultiLineQueries);
        }

        public QueryFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            for (Map.Entry<String, Object> queryStatementEntry : configs.entrySet()) {
                String queryStatementKey = queryStatementEntry.getKey();
                if (queryStatementKey.equals(ALIGN_MULTILINE_QUERIES)) {
                    this.setAlignMultiLineQueries((Boolean)queryStatementEntry.getValue());
                    continue;
                }
                throw new FormatterException("invalid query formatting option: " + queryStatementKey);
            }
            return this.build();
        }
    }
}

