# HTTP service - JWT authentication

The `http:Service` and resource method can be secured with JWT and additionally, scopes can be added to enforce authorization. It validates the JWT sent in the `Authorization` header against the provided configurations. Ballerina uses the concept of scopes for authorization. A resource declared in a service can be bound to one/more scope(s). The scope can be included in the JWT using a custom claim attribute. That custom claim attribute also can be configured as the `scopeKey`. In the authorization phase, the scopes of the service/resource are compared against the scope included in the JWT for at least one match between the two sets.

::: code http_service_jwt_authentication.bal :::

Run the service by executing the command below.

::: out http_service_jwt_authentication.server.out :::

>**Tip:** You can invoke the above service via the [self-signed JWT authentication client](/learn/by-example/http-client-self-signed-jwt-authentication) example.

## Related links
- [`http:JwtValidatorConfig` record - API documentation](https://lib.ballerina.io/ballerina/http/latest#JwtValidatorConfig)
- [`jwt` module - API documentation](https://lib.ballerina.io/ballerina/jwt/latest/)
- [HTTP service JWT authentication - Specification](/spec/http/#9113-listener---jwt-auth)
