/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.csv;

import io.ballerina.lib.data.csvdata.csv.CsvCreator;
import io.ballerina.lib.data.csvdata.csv.CsvTraversal;
import io.ballerina.lib.data.csvdata.utils.CsvConfig;
import io.ballerina.lib.data.csvdata.utils.CsvUtils;
import io.ballerina.lib.data.csvdata.utils.DataUtils;
import io.ballerina.lib.data.csvdata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public final class CsvParser {
    private static final char CR = '\r';
    private static final char HZ_TAB = '\t';
    private static final char SPACE = ' ';
    private static final char BACKSPACE = '\b';
    private static final char FORMFEED = '\f';
    private static final char QUOTES = '\"';
    private static final char REV_SOL = '\\';
    private static final char SOL = '/';
    private static final char EOF = '\uffff';
    private static final char NEWLINE = '\n';

    private CsvParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(Reader reader, BTypedesc type, CsvConfig config) throws BError {
        StateMachine sm = new StateMachine();
        try {
            CsvUtils.validateConfigs(config);
            Object convertedValue = sm.execute(reader, TypeUtils.getReferredType((Type)type.getDescribingType()), config, type);
            Object object = DataUtils.validateConstraints(convertedValue, type, config.enableConstraintValidation);
            return object;
        }
        finally {
            sm.reset();
        }
    }

    static class StateMachine {
        private static final State HEADER_START_STATE = new HeaderStartState();
        private static final State HEADER_END_STATE = new HeaderEndState();
        private static final State ROW_START_STATE = new RowStartState();
        private static final State ROW_END_STATE = new RowEndState();
        private static final State STRING_ESCAPE_VALUE_STATE = new StringValueEscapedCharacterProcessingState();
        private static final State STRING_UNICODE_CHAR_STATE = new StringValueUnicodeHexProcessingState();
        private static final State HEADER_UNICODE_CHAR_STATE = new HeaderUnicodeHexProcessingState();
        private static final State HEADER_ESCAPE_CHAR_STATE = new HeaderEscapedCharacterProcessingState();
        private static final State STRING_QUOTE_CHAR_STATE = new StringQuoteValueState();
        private static final State HEADER_QUOTE_CHAR_STATE = new HeaderQuoteValueState();
        private static final char LINE_BREAK = '\n';
        Object currentCsvNode;
        ArrayList<String> headers = new ArrayList();
        BArray rootCsvNode;
        Map<String, Field> fieldHierarchy = new HashMap<String, Field>();
        Map<String, String> updatedRecordFieldNames = new HashMap<String, String>();
        HashSet<String> fields = new HashSet();
        Map<String, Field> fieldNames = new HashMap<String, Field>();
        private char[] charBuff = new char[1024];
        private int charBuffIndex;
        private int index;
        private int line;
        private int column;
        Type restType;
        Type expectedArrayElementType;
        int columnIndex = 0;
        int rowIndex = 1;
        int lineNumber = 0;
        ArrayType rootArrayType = null;
        CsvConfig config = null;
        boolean skipTheRow = false;
        boolean insideComment = false;
        boolean isCurrentCsvNodeEmpty = true;
        boolean isHeaderConfigExceedLineNumber = false;
        boolean isQuoteClosed = false;
        private StringBuilder hexBuilder = new StringBuilder(4);
        boolean isValueStart = false;
        State prevState;
        int arraySize = 0;
        boolean addHeadersForOutput = false;
        int currentCsvNodeLength = 0;
        boolean isColumnMaxSizeReached = false;
        boolean isRowMaxSizeReached = false;
        boolean isCarriageTokenPresent = false;

        StateMachine() {
            this.reset();
        }

        public void reset() {
            this.currentCsvNode = null;
            this.headers = new ArrayList();
            this.rootCsvNode = null;
            this.fieldHierarchy.clear();
            this.updatedRecordFieldNames.clear();
            this.fields.clear();
            this.fieldNames.clear();
            this.charBuff = new char[1024];
            this.charBuffIndex = 0;
            this.index = 0;
            this.line = 1;
            this.column = 0;
            this.restType = null;
            this.expectedArrayElementType = null;
            this.columnIndex = 0;
            this.rowIndex = 1;
            this.lineNumber = 0;
            this.rootArrayType = null;
            this.config = null;
            this.skipTheRow = false;
            this.insideComment = false;
            this.isCurrentCsvNodeEmpty = true;
            this.isHeaderConfigExceedLineNumber = false;
            this.isQuoteClosed = false;
            this.hexBuilder = new StringBuilder(4);
            this.isValueStart = false;
            this.prevState = null;
            this.arraySize = 0;
            this.addHeadersForOutput = false;
            this.currentCsvNodeLength = 0;
            this.isColumnMaxSizeReached = false;
            this.isRowMaxSizeReached = false;
            this.isCarriageTokenPresent = false;
        }

        private boolean isWhitespace(char ch, Object lineTerminator) {
            return ch == ' ' || ch == '\t' || ch == '\r' || CsvUtils.isCharContainsInLineTerminatorUserConfig(ch, lineTerminator, this.isCarriageTokenPresent);
        }

        private static void throwExpected(String ... chars) throws CsvParserException {
            throw new CsvParserException("expected '" + String.join((CharSequence)"' or '", chars) + "'");
        }

        private void processLocation(char ch) {
            if (ch == '\n') {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
        }

        private String value() {
            if (this.charBuffIndex == 0) {
                return "";
            }
            String result = new String(this.charBuff, 0, this.charBuffIndex);
            this.charBuffIndex = 0;
            return result;
        }

        private void clear() {
            this.charBuffIndex = 0;
        }

        private String peek() {
            return new String(this.charBuff, 0, this.charBuffIndex);
        }

        public Object execute(Reader reader, Type type, CsvConfig config, BTypedesc bTypedesc) throws BError {
            State currentState;
            this.config = config;
            Type referredType = TypeUtils.getReferredType((Type)type);
            if (referredType.getTag() == 34) {
                for (Object constituentType : ((IntersectionType)referredType).getConstituentTypes()) {
                    if (constituentType.getTag() == 51) continue;
                    return CsvCreator.constructReadOnlyValue(this.execute(reader, (Type)constituentType, config, bTypedesc));
                }
            }
            if (referredType.getTag() == 33) {
                this.expectedArrayElementType = referredType;
            } else {
                if (referredType.getTag() != 32) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, type);
                }
                this.rootArrayType = (ArrayType)referredType;
                this.expectedArrayElementType = TypeUtils.getReferredType((Type)this.rootArrayType.getElementType());
                this.rootCsvNode = ValueCreator.createArrayValue((ArrayType)this.rootArrayType);
            }
            switch (this.expectedArrayElementType.getTag()) {
                case 24: {
                    RecordType recordType = (RecordType)this.expectedArrayElementType;
                    this.restType = recordType.getRestFieldType();
                    this.fieldHierarchy = new HashMap<String, Field>(recordType.getFields());
                    this.fields = new HashSet(recordType.getFields().keySet());
                    this.updatedRecordFieldNames = CsvUtils.processNameAnnotationsAndBuildCustomFieldMap(recordType, this.fieldHierarchy);
                    break;
                }
                case 44: {
                    this.restType = ((TupleType)this.expectedArrayElementType).getRestType();
                    break;
                }
                case 27: 
                case 32: {
                    break;
                }
                case 34: {
                    for (Type constituentType : ((IntersectionType)this.expectedArrayElementType).getConstituentTypes()) {
                        if (constituentType.getTag() == 51) continue;
                        Object mapValue = this.execute(reader, (Type)TypeCreator.createArrayType((Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING)), CsvConfig.createConfigOptionsForUnion(config), bTypedesc);
                        config.stringConversion = true;
                        return CsvCreator.constructReadOnlyValue(CsvTraversal.traverse((BArray)mapValue, config, bTypedesc, (Type)TypeCreator.createArrayType((Type)constituentType)));
                    }
                    throw DiagnosticLog.error(DiagnosticErrorCode.SOURCE_CANNOT_CONVERT_INTO_EXP_TYPE, this.expectedArrayElementType);
                }
                case 33: {
                    boolean outputHeaders = config.outputWithHeaders;
                    Object customHeaders = config.customHeadersIfHeadersAbsent;
                    Object mapValue = this.execute(reader, (Type)TypeCreator.createArrayType((Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING)), CsvConfig.createConfigOptionsForUnion(config), bTypedesc);
                    config.stringConversion = true;
                    config.outputWithHeaders = outputHeaders;
                    if (config.outputWithHeaders && customHeaders == null) {
                        config.customHeadersIfHeadersAbsent = this.headers;
                    }
                    if (customHeaders != null) {
                        config.customHeadersIfHeadersAbsent = customHeaders;
                    }
                    return CsvTraversal.traverse((BArray)mapValue, config, bTypedesc);
                }
                default: {
                    throw DiagnosticLog.error(DiagnosticErrorCode.SOURCE_CANNOT_CONVERT_INTO_EXP_TYPE, this.expectedArrayElementType);
                }
            }
            if (config.header != null) {
                currentState = HEADER_START_STATE;
            } else {
                Object customHeadersIfHeadersAbsent = config.customHeadersIfHeadersAbsent;
                if (customHeadersIfHeadersAbsent != null) {
                    CsvCreator.addCustomHeadersIfNotNull(this, customHeadersIfHeadersAbsent);
                }
                currentState = ROW_START_STATE;
                this.addFieldNamesForNonHeaderState();
            }
            try {
                int count;
                char[] buff = new char[1024];
                while ((count = reader.read(buff)) > 0) {
                    this.index = 0;
                    while (this.index < count) {
                        currentState = currentState.transition(this, buff, this.index, count);
                    }
                }
                if ((currentState = currentState.transition(this, new char[]{'\uffff'}, 0, 1)) != ROW_END_STATE && currentState != HEADER_END_STATE && !this.isHeaderConfigExceedLineNumber) {
                    throw new CsvParserException("Invalid token found");
                }
                return this.rootCsvNode;
            }
            catch (CsvParserException | IOException e) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TOKEN, e.getMessage(), this.line, this.column);
            }
        }

        private void addFieldNamesForNonHeaderState() {
            this.fieldNames.putAll(this.fieldHierarchy);
        }

        private void append(char ch) {
            try {
                this.charBuff[this.charBuffIndex] = ch;
                ++this.charBuffIndex;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.growCharBuff();
                this.charBuff[this.charBuffIndex++] = ch;
            }
        }

        private boolean isNewLineOrEof(char ch) {
            return ch == '\uffff' || CsvUtils.isCharContainsInLineTerminatorUserConfig(ch, this.config.lineTerminator, this.isCarriageTokenPresent);
        }

        private void growCharBuff() {
            char[] newBuff = new char[this.charBuff.length * 2];
            System.arraycopy(this.charBuff, 0, newBuff, 0, this.charBuff.length);
            this.charBuff = newBuff;
        }

        private static void handleEndOfTheHeader(StateMachine sm) throws CsvParserException {
            StateMachine.handleEndOfTheHeader(sm, true);
        }

        private static void handleEndOfTheHeader(StateMachine sm, boolean trim) throws CsvParserException {
            sm.isValueStart = false;
            StateMachine.addHeader(sm, trim);
            StateMachine.finalizeHeaders(sm);
            sm.columnIndex = 0;
            ++sm.lineNumber;
        }

        private static int getHeaderStartRowWhenHeaderIsPresent(Object header) {
            return ((Long)header).intValue();
        }

        private static void finalizeHeaders(StateMachine sm) throws CsvParserException {
            if (sm.headers.isEmpty()) {
                throw DiagnosticLog.error(DiagnosticErrorCode.HEADER_CANNOT_BE_EMPTY, new Object[0]);
            }
            Type expType = sm.expectedArrayElementType;
            if (expType instanceof RecordType) {
                StateMachine.validateRemainingRecordFields(sm);
            } else if (expType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)expType;
                CsvUtils.validateExpectedArraySize(arrayType.getSize(), sm.headers.size());
            } else if (!(expType instanceof MapType)) {
                if (expType instanceof TupleType) {
                    TupleType tupleType = (TupleType)expType;
                    StateMachine.validateTupleTypes(tupleType, sm.restType, sm.headers.size());
                } else {
                    throw new CsvParserException("Invalid expected type");
                }
            }
        }

        private static void validateTupleTypes(TupleType tupleType, Type restType, int currentSize) {
            if (restType != null && tupleType.getTupleTypes().size() > currentSize) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_EXPECTED_TUPLE_SIZE, currentSize);
            }
        }

        private static void validateRemainingRecordFields(StateMachine sm) {
            if (sm.restType == null) {
                for (Field field : sm.fieldHierarchy.values()) {
                    if (sm.config.absentAsNilableType && field.getFieldType().isNilable()) {
                        return;
                    }
                    if (!SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) continue;
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_FIELD_IN_CSV, field.getFieldName());
                }
            }
        }

        private static void addHeader(StateMachine sm) {
            StateMachine.addHeader(sm, true);
        }

        private static void addHeader(StateMachine sm, boolean trim) {
            String fieldName;
            Field field;
            sm.isValueStart = false;
            String value = sm.value();
            if (trim) {
                value = value.trim();
            }
            if (value.isEmpty()) {
                throw DiagnosticLog.error(DiagnosticErrorCode.HEADER_CANNOT_BE_EMPTY, new Object[0]);
            }
            if (sm.expectedArrayElementType instanceof RecordType && (field = sm.fieldHierarchy.get(fieldName = CsvUtils.getUpdatedHeaders(sm.updatedRecordFieldNames, value, sm.fields.contains(value)))) != null) {
                sm.fieldNames.put(fieldName, field);
                sm.fieldHierarchy.remove(fieldName);
            }
            if (sm.headers.contains(value)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_HEADER, value);
            }
            sm.headers.add(value);
        }

        private static void handleEndOfTheRow(StateMachine sm) {
            StateMachine.handleEndOfTheRow(sm, true);
        }

        private static void handleEndOfTheRow(StateMachine sm, boolean trim) {
            sm.isValueStart = false;
            StateMachine.handleCsvRow(sm, trim);
            CsvUtils.checkRequiredFieldsAndLogError(sm.fieldHierarchy, sm.config.absentAsNilableType);
        }

        private static void handleCsvRow(StateMachine sm, boolean trim) {
            String value = sm.peek();
            if (trim) {
                value = value.trim();
            }
            if (!(value.isBlank() && sm.currentCsvNodeLength == 0 || sm.isColumnMaxSizeReached || sm.isRowMaxSizeReached)) {
                StateMachine.addRowValue(sm, trim);
            }
            if (!sm.isCurrentCsvNodeEmpty) {
                StateMachine.finalizeTheRow(sm);
                StateMachine.updateLineAndColumnIndexes(sm);
            } else {
                StateMachine.updateLineAndColumnIndexesWithoutRowIndexes(sm);
            }
        }

        private static void updateLineAndColumnIndexes(StateMachine sm) {
            ++sm.rowIndex;
            StateMachine.updateLineAndColumnIndexesWithoutRowIndexes(sm);
        }

        private static void updateLineAndColumnIndexesWithoutRowIndexes(StateMachine sm) {
            ++sm.lineNumber;
            sm.currentCsvNode = null;
            sm.isCurrentCsvNodeEmpty = true;
            sm.columnIndex = 0;
            sm.isColumnMaxSizeReached = false;
            sm.clear();
        }

        private static boolean ignoreRow(long[] skipLines, int lineNumber) {
            for (long skipLine : skipLines) {
                if (skipLine != (long)lineNumber) continue;
                return true;
            }
            return false;
        }

        private static void initiateNewRowType(StateMachine sm) {
            sm.currentCsvNode = CsvCreator.initRowValue(sm.expectedArrayElementType);
        }

        private static void addHeadersAsTheFirstElementForArraysIfApplicable(StateMachine sm) {
            if (!sm.addHeadersForOutput && CsvUtils.isExpectedTypeIsArray(sm.expectedArrayElementType) && sm.config.outputWithHeaders) {
                ArrayList<String> headers = sm.headers;
                if (!headers.isEmpty()) {
                    for (String header : headers) {
                        StateMachine.addHeaderAsRowValue(sm, header);
                    }
                    if (!sm.isCurrentCsvNodeEmpty) {
                        StateMachine.finalizeTheRow(sm);
                        StateMachine.initiateNewRowType(sm);
                    }
                }
                sm.addHeadersForOutput = true;
                sm.columnIndex = 0;
            }
        }

        private static void finalizeTheRow(StateMachine sm) {
            int rootArraySize = sm.rootArrayType.getSize();
            if (rootArraySize == -1) {
                sm.rootCsvNode.append(sm.currentCsvNode);
            } else if (sm.arraySize < rootArraySize) {
                sm.rootCsvNode.add((long)sm.arraySize, sm.currentCsvNode);
            }
            ++sm.arraySize;
            sm.currentCsvNodeLength = 0;
            if (sm.arraySize == rootArraySize) {
                sm.isRowMaxSizeReached = true;
            }
        }

        private static void addRowValue(StateMachine sm) {
            StateMachine.addRowValue(sm, true);
        }

        private static void addRowValue(StateMachine sm, boolean trim) {
            if (sm.isColumnMaxSizeReached || sm.isRowMaxSizeReached) {
                return;
            }
            Field currentField = null;
            sm.isValueStart = false;
            Type exptype = sm.expectedArrayElementType;
            String value = sm.value();
            if (trim) {
                value = value.trim();
            }
            Type type = StateMachine.getExpectedRowType(sm, exptype);
            if (exptype instanceof RecordType) {
                currentField = StateMachine.getCurrentField(sm);
            }
            if (type != null) {
                CsvCreator.convertAndUpdateCurrentCsvNode(sm, value, type, sm.config, exptype, currentField);
            }
            ++sm.columnIndex;
        }

        private static void addHeaderAsRowValue(StateMachine sm, String value) {
            Type exptype = sm.expectedArrayElementType;
            Field currentField = null;
            Type type = StateMachine.getExpectedRowType(sm, exptype);
            if (exptype instanceof RecordType) {
                currentField = StateMachine.getCurrentField(sm);
            }
            if (type != null) {
                CsvCreator.convertAndUpdateCurrentCsvNode(sm, value, type, sm.config, exptype, currentField);
            }
            ++sm.columnIndex;
        }

        private static Type getExpectedRowType(StateMachine sm, Type exptype) {
            if (exptype instanceof RecordType) {
                return StateMachine.getExpectedRowTypeOfRecord(sm);
            }
            if (exptype instanceof MapType) {
                MapType mapType = (MapType)exptype;
                return mapType.getConstrainedType();
            }
            if (exptype instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)exptype;
                return StateMachine.getExpectedRowTypeOfArray(sm, arrayType);
            }
            if (exptype instanceof TupleType) {
                TupleType tupleType = (TupleType)exptype;
                return StateMachine.getExpectedRowTypeOfTuple(sm, tupleType);
            }
            return null;
        }

        private static Type getExpectedRowTypeOfTuple(StateMachine sm, TupleType tupleType) {
            List tupleTypes = tupleType.getTupleTypes();
            if (tupleTypes.size() > sm.columnIndex) {
                return (Type)tupleTypes.get(sm.columnIndex);
            }
            Type restType = sm.restType;
            if (restType != null) {
                return restType;
            }
            sm.charBuffIndex = 0;
            if (sm.config.allowDataProjection) {
                sm.isColumnMaxSizeReached = true;
                return null;
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_EXPECTED_TUPLE_SIZE, tupleTypes.size());
        }

        private static Type getExpectedRowTypeOfArray(StateMachine sm, ArrayType arrayType) {
            if (arrayType.getSize() != -1 && arrayType.getSize() <= sm.columnIndex) {
                sm.charBuffIndex = 0;
                if (sm.config.allowDataProjection) {
                    sm.isColumnMaxSizeReached = true;
                    return null;
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_EXPECTED_ARRAY_SIZE, arrayType.getSize());
            }
            return arrayType.getElementType();
        }

        private static Type getExpectedRowTypeOfRecord(StateMachine sm) {
            Map<String, Field> fields = sm.fieldNames;
            String header = CsvCreator.getHeaderValueForColumnIndex(sm);
            if (fields.containsKey(header)) {
                return fields.get(header).getFieldType();
            }
            Type restType = sm.restType;
            if (restType != null) {
                return restType;
            }
            sm.charBuffIndex = 0;
            if (sm.config.allowDataProjection) {
                return null;
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.NO_FIELD_FOR_HEADER, header);
        }

        private static Field getCurrentField(StateMachine sm) {
            Map<String, Field> fields = sm.fieldNames;
            String header = CsvCreator.getHeaderValueForColumnIndex(sm);
            if (fields.containsKey(header)) {
                return fields.get(header);
            }
            return null;
        }

        public static boolean isEndOfTheRowAndValueIsNotEmpty(StateMachine sm, char ch) {
            return sm.isNewLineOrEof(ch) && (ch == '\uffff' || !sm.isCurrentCsvNodeEmpty || !sm.peek().isBlank());
        }

        public static boolean isEndOfTheHeaderRow(StateMachine sm, char ch) {
            return sm.isNewLineOrEof(ch);
        }

        static interface State {
            public State transition(StateMachine var1, char[] var2, int var3, int var4) throws CsvParserException;
        }

        public static class CsvParserException
        extends Exception {
            public CsvParserException(String msg) {
                super(msg);
            }
        }

        private static class HeaderStartState
        implements State {
            private HeaderStartState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws CsvParserException {
                State state = HEADER_START_STATE;
                char separator = sm.config.delimiter;
                int headerStartRowNumber = StateMachine.getHeaderStartRowWhenHeaderIsPresent(sm.config.header);
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\uffff') {
                        StateMachine.handleEndOfTheHeader(sm);
                        return HEADER_END_STATE;
                    }
                    if (ch == '\r') {
                        sm.isCarriageTokenPresent = true;
                    } else {
                        if (!sm.isCarriageTokenPresent || ch != '\n') {
                            sm.isCarriageTokenPresent = true;
                        }
                        if (sm.lineNumber < headerStartRowNumber) {
                            sm.isHeaderConfigExceedLineNumber = true;
                            if (sm.isNewLineOrEof(ch)) {
                                ++sm.lineNumber;
                            }
                        } else {
                            sm.isHeaderConfigExceedLineNumber = false;
                            if (ch == sm.config.comment) {
                                sm.insideComment = true;
                                state = this;
                                break;
                            }
                            if (!sm.insideComment && ch == separator) {
                                StateMachine.addHeader(sm);
                                ++sm.columnIndex;
                                state = this;
                            } else {
                                if (!sm.insideComment && ch == sm.config.textEnclosure) {
                                    sm.prevState = this;
                                    state = HEADER_QUOTE_CHAR_STATE;
                                    break;
                                }
                                if (!sm.insideComment && ch == sm.config.escapeChar) {
                                    sm.prevState = this;
                                    state = HEADER_ESCAPE_CHAR_STATE;
                                    break;
                                }
                                if (sm.insideComment && sm.isNewLineOrEof(ch)) {
                                    sm.insideComment = false;
                                    StateMachine.handleEndOfTheHeader(sm);
                                    state = HEADER_END_STATE;
                                    break;
                                }
                                if (!sm.insideComment && StateMachine.isEndOfTheHeaderRow(sm, ch)) {
                                    StateMachine.handleEndOfTheHeader(sm);
                                    state = HEADER_END_STATE;
                                    break;
                                }
                                if (sm.isWhitespace(ch, sm.config.lineTerminator)) {
                                    if (sm.isValueStart) {
                                        sm.append(ch);
                                    }
                                    state = this;
                                } else {
                                    if (!sm.insideComment) {
                                        sm.append(ch);
                                        sm.isValueStart = true;
                                    }
                                    state = this;
                                }
                            }
                        }
                    }
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class HeaderEndState
        implements State {
            private HeaderEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                return ROW_START_STATE;
            }
        }

        private static class RowStartState
        implements State {
            char ch;
            State state = ROW_START_STATE;

            private RowStartState() {
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                separator = sm.config.delimiter;
                skipLines = CsvUtils.getSkipDataRows(sm.config.skipLines);
                while (i < count) {
                    block26: {
                        block28: {
                            block27: {
                                block25: {
                                    this.ch = buff[i];
                                    sm.processLocation(this.ch);
                                    if (!sm.isRowMaxSizeReached) break block25;
                                    if (this.ch == '\uffff') {
                                        this.state = StateMachine.ROW_END_STATE;
                                        break;
                                    }
                                    break block26;
                                }
                                if (this.ch != '\r') break block27;
                                sm.isCarriageTokenPresent = true;
                                break block26;
                            }
                            if (!sm.isCarriageTokenPresent || this.ch != '\n') {
                                sm.isCarriageTokenPresent = false;
                            }
                            if (!sm.skipTheRow) break block28;
                            if (StateMachine.isEndOfTheRowAndValueIsNotEmpty(sm, this.ch)) {
                                sm.insideComment = false;
                                sm.skipTheRow = false;
                                sm.clear();
                                if (this.ch == '\uffff') {
                                    return StateMachine.ROW_END_STATE;
                                }
                            } else {
                                sm.append(this.ch);
                                sm.isValueStart = true;
                            }
                            break block26;
                        }
                        if (!sm.isCurrentCsvNodeEmpty) ** GOTO lbl37
                        if (StateMachine.ignoreRow(skipLines, sm.rowIndex)) {
                            StateMachine.updateLineAndColumnIndexes(sm);
                            sm.skipTheRow = true;
                        } else {
                            StateMachine.initiateNewRowType(sm);
                            StateMachine.addHeadersAsTheFirstElementForArraysIfApplicable(sm);
lbl37:
                            // 2 sources

                            if (!sm.insideComment && this.ch == sm.config.comment) {
                                StateMachine.handleEndOfTheRow(sm);
                                sm.insideComment = true;
                                this.state = this;
                            } else if (!sm.insideComment && this.ch == separator) {
                                StateMachine.addRowValue(sm);
                                this.state = this;
                            } else {
                                if (!sm.insideComment && this.ch == sm.config.textEnclosure) {
                                    sm.prevState = this;
                                    this.state = StateMachine.STRING_QUOTE_CHAR_STATE;
                                    break;
                                }
                                if (!sm.insideComment && this.ch == sm.config.escapeChar) {
                                    sm.prevState = this;
                                    this.state = StateMachine.STRING_ESCAPE_VALUE_STATE;
                                    break;
                                }
                                if (sm.insideComment && sm.isNewLineOrEof(this.ch)) {
                                    sm.insideComment = false;
                                    if (this.ch == '\uffff') {
                                        this.state = StateMachine.ROW_END_STATE;
                                        break;
                                    }
                                } else if (StateMachine.isEndOfTheRowAndValueIsNotEmpty(sm, this.ch)) {
                                    StateMachine.handleEndOfTheRow(sm);
                                    if (this.ch == '\uffff') {
                                        this.state = StateMachine.ROW_END_STATE;
                                        break;
                                    }
                                } else if (sm.isWhitespace(this.ch, sm.config.lineTerminator)) {
                                    if (sm.isValueStart) {
                                        sm.append(this.ch);
                                    }
                                    this.state = this;
                                } else {
                                    if (!sm.insideComment) {
                                        sm.append(this.ch);
                                        sm.isValueStart = true;
                                    }
                                    this.state = this;
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (this.state == null) {
                    this.state = this;
                }
                sm.index = i + 1;
                return this.state;
            }
        }

        private static class RowEndState
        implements State {
            private RowEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                return ROW_END_STATE;
            }
        }

        private static class StringValueEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private StringValueEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_ESCAPE_VALUE_STATE;
            }
        }

        private static class StringValueUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private StringValueUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_UNICODE_CHAR_STATE;
            }
        }

        private static class HeaderUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private HeaderUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return HEADER_UNICODE_CHAR_STATE;
            }
        }

        private static class HeaderEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private HeaderEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return HEADER_ESCAPE_CHAR_STATE;
            }
        }

        private static class StringQuoteValueState
        implements State {
            private StringQuoteValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) {
                State state = this;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\uffff') {
                        StateMachine.handleEndOfTheRow(sm, false);
                        return ROW_END_STATE;
                    }
                    if (ch == '\r') {
                        sm.isCarriageTokenPresent = true;
                    } else {
                        if (!sm.isCarriageTokenPresent || ch != '\n') {
                            sm.isCarriageTokenPresent = false;
                        }
                        if (ch == sm.config.textEnclosure) {
                            if (sm.isQuoteClosed) {
                                sm.append(ch);
                                sm.isValueStart = true;
                            } else {
                                sm.isQuoteClosed = true;
                            }
                        } else {
                            if (ch == sm.config.delimiter && sm.isQuoteClosed) {
                                StateMachine.addRowValue(sm, false);
                                state = ROW_START_STATE;
                                sm.isQuoteClosed = false;
                                break;
                            }
                            if (sm.isNewLineOrEof(ch) && sm.isQuoteClosed) {
                                StateMachine.handleEndOfTheRow(sm, false);
                                state = ROW_START_STATE;
                                sm.isQuoteClosed = false;
                                break;
                            }
                            if (ch == sm.config.escapeChar) {
                                state = STRING_ESCAPE_VALUE_STATE;
                                sm.prevState = this;
                                sm.isQuoteClosed = false;
                                break;
                            }
                            if (!sm.isQuoteClosed) {
                                sm.append(ch);
                            } else {
                                sm.append(sm.config.textEnclosure);
                                sm.append(ch);
                                sm.isQuoteClosed = false;
                            }
                            sm.isValueStart = true;
                            state = this;
                        }
                    }
                    ++i;
                }
                if (state == null) {
                    state = this;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class HeaderQuoteValueState
        implements State {
            private HeaderQuoteValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws CsvParserException {
                State state = this;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\uffff') {
                        StateMachine.handleEndOfTheRow(sm);
                        return ROW_END_STATE;
                    }
                    if (ch == '\r') {
                        sm.isCarriageTokenPresent = true;
                    } else {
                        if (!sm.isCarriageTokenPresent || ch != '\n') {
                            sm.isCarriageTokenPresent = false;
                        }
                        if (ch == sm.config.textEnclosure) {
                            sm.isQuoteClosed = true;
                            break;
                        }
                        if (ch == sm.config.delimiter && sm.isQuoteClosed) {
                            StateMachine.addHeader(sm, false);
                            ++sm.columnIndex;
                            sm.isQuoteClosed = false;
                            state = HEADER_START_STATE;
                            break;
                        }
                        if (sm.isNewLineOrEof(ch) && sm.isQuoteClosed) {
                            StateMachine.handleEndOfTheHeader(sm, false);
                            state = HEADER_END_STATE;
                            sm.isQuoteClosed = false;
                            break;
                        }
                        if (!sm.isQuoteClosed && ch == sm.config.escapeChar) {
                            sm.isQuoteClosed = false;
                            sm.prevState = this;
                            state = HEADER_ESCAPE_CHAR_STATE;
                            break;
                        }
                        if (!sm.isQuoteClosed) {
                            sm.append(ch);
                        } else {
                            sm.append(sm.config.textEnclosure);
                            sm.append(ch);
                            sm.isQuoteClosed = false;
                        }
                        sm.isValueStart = true;
                        state = this;
                    }
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static abstract class EscapedCharacterProcessingState
        implements State {
            static final Map<Character, Character> ESCAPE_CHAR_MAP = Map.of(Character.valueOf('\"'), Character.valueOf('\"'), Character.valueOf('\\'), Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf('/'), Character.valueOf('b'), Character.valueOf('\b'), Character.valueOf('f'), Character.valueOf('\f'), Character.valueOf('n'), Character.valueOf('\n'), Character.valueOf('r'), Character.valueOf('\r'), Character.valueOf('t'), Character.valueOf('\t'));

            private EscapedCharacterProcessingState() {
            }

            protected abstract State getSourceState();

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws CsvParserException {
                State state = null;
                if (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\r') {
                        sm.isCarriageTokenPresent = true;
                    } else if (!sm.isCarriageTokenPresent || ch != '\n') {
                        sm.isCarriageTokenPresent = false;
                    }
                    if (ch == '\uffff') {
                        StateMachine.handleEndOfTheRow(sm);
                        return ROW_END_STATE;
                    }
                    switch (ch) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            sm.append(ESCAPE_CHAR_MAP.get(Character.valueOf(ch)).charValue());
                            state = sm.prevState;
                            break;
                        }
                        case 'u': {
                            if (this.getSourceState() == STRING_ESCAPE_VALUE_STATE) {
                                state = STRING_UNICODE_CHAR_STATE;
                                break;
                            }
                            if (this.getSourceState() == HEADER_ESCAPE_CHAR_STATE) {
                                state = HEADER_UNICODE_CHAR_STATE;
                                break;
                            }
                            throw new CsvParserException("unknown source '" + String.valueOf(this.getSourceState()) + "' in escape char processing state");
                        }
                        default: {
                            StateMachine.throwExpected("escaped characters");
                        }
                    }
                }
                if (state == null) {
                    state = this;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static abstract class UnicodeHexProcessingState
        implements State {
            private UnicodeHexProcessingState() {
            }

            protected abstract State getSourceState();

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws CsvParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\uffff') {
                        StateMachine.handleEndOfTheRow(sm);
                        return ROW_END_STATE;
                    }
                    if (ch == '\r') {
                        sm.isCarriageTokenPresent = true;
                    } else {
                        if (!sm.isCarriageTokenPresent || ch != '\n') {
                            sm.isCarriageTokenPresent = false;
                        }
                        if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') {
                            sm.hexBuilder.append(ch);
                            sm.isValueStart = true;
                            if (sm.hexBuilder.length() >= 4) {
                                sm.append(this.extractUnicodeChar(sm));
                                this.reset(sm);
                                state = sm.prevState;
                                sm.prevState = this;
                                break;
                            }
                            state = this;
                        } else {
                            this.reset(sm);
                            StateMachine.throwExpected("hexadecimal value of an unicode character");
                            break;
                        }
                    }
                    ++i;
                }
                if (state == null) {
                    state = this;
                }
                sm.index = i + 1;
                return state;
            }

            private void reset(StateMachine sm) {
                sm.hexBuilder.setLength(0);
            }

            private char extractUnicodeChar(StateMachine sm) {
                return StringEscapeUtils.unescapeJava((String)("\\u" + sm.hexBuilder.toString())).charAt(0);
            }
        }
    }
}

