/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ballerinalang.test.runtime.CustomClassLoader;
import org.ballerinalang.test.runtime.CustomSystemClassLoader;
import org.ballerinalang.test.runtime.entity.MockFunctionReplaceVisitor;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.TestReport;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.exceptions.BallerinaTestException;
import org.ballerinalang.test.runtime.util.TesterinaUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public final class BTestMain {
    private static final PrintStream out = System.out;
    static TestReport testReport;
    static ClassLoader classLoader;
    static Map<String, List<String>> classVsMockFunctionsMap;

    private BTestMain() {
    }

    public static void main(String[] args) throws IOException {
        int exitStatus = 0;
        if (args.length < 4) {
            Runtime.getRuntime().exit(1);
        }
        boolean isFatJarExecution = Boolean.parseBoolean(args[0]);
        Path testSuiteJsonPath = Path.of(args[1], new String[0]);
        Path targetPath = Path.of(args[2], new String[0]);
        Path testCache = targetPath.resolve("cache").resolve("tests_cache");
        String jacocoAgentJarPath = args[3];
        boolean report = Boolean.parseBoolean(args[4]);
        boolean coverage = Boolean.parseBoolean(args[5]);
        if (report || coverage) {
            testReport = new TestReport();
        }
        out.println();
        out.print("Running Tests");
        if (coverage) {
            out.print(" with Coverage");
        }
        out.println();
        try (InputStream is = isFatJarExecution ? BTestMain.class.getResourceAsStream("/" + String.valueOf(testSuiteJsonPath)) : null;){
            BufferedReader br = is != null ? new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)) : Files.newBufferedReader(testSuiteJsonPath, StandardCharsets.UTF_8);
            Gson gson = new Gson();
            Map testSuiteMap = (Map)gson.fromJson((Reader)br, (TypeToken)new TypeToken<Map<String, TestSuite>>(){});
            if (!testSuiteMap.isEmpty()) {
                for (Map.Entry entry : testSuiteMap.entrySet()) {
                    TestSuite testSuite;
                    String packageName;
                    String moduleName = (String)entry.getKey();
                    out.println("\n\t" + (String)(moduleName.equals(packageName = (testSuite = (TestSuite)entry.getValue()).getPackageName()) ? (moduleName.equals(".") ? testSuite.getSourceFileName() : moduleName) : packageName + "." + moduleName));
                    testSuite.setModuleName(moduleName);
                    List<String> testExecutionDependencies = testSuite.getTestExecutionDependencies();
                    classLoader = isFatJarExecution && !testSuite.getMockFunctionNamesMap().isEmpty() ? BTestMain.createInitialCustomClassLoader() : BTestMain.createURLClassLoader(BTestMain.getURLList(testExecutionDependencies));
                    if (!testSuite.getMockFunctionNamesMap().isEmpty()) {
                        if (coverage) {
                            testExecutionDependencies.add(jacocoAgentJarPath);
                        }
                        String instrumentDir = testCache.resolve("coverage").resolve("instrumented").toString();
                        BTestMain.replaceMockedFunctions(testSuite, testExecutionDependencies, instrumentDir, coverage, isFatJarExecution);
                    }
                    String[] testArgs = new String[]{targetPath.toString(), packageName, moduleName};
                    for (int i = 4; i < args.length; ++i) {
                        testArgs = Arrays.copyOf(testArgs, testArgs.length + 1);
                        testArgs[testArgs.length - 1] = args[i];
                    }
                    int result = BTestMain.startTestSuit(Path.of(testSuite.getSourceRootPath(), new String[0]), testSuite, classLoader, testArgs);
                    exitStatus = result == 1 ? result : exitStatus;
                }
            } else {
                exitStatus = 1;
            }
            br.close();
        }
        Runtime.getRuntime().exit(exitStatus);
    }

    private static int startTestSuit(Path sourceRootPath, TestSuite testSuite, ClassLoader classLoader, String[] args) {
        try {
            return TesterinaUtils.executeTests(sourceRootPath, testSuite, classLoader, args, out);
        }
        catch (RuntimeException e) {
            return 1;
        }
    }

    private static void writeStatusToJsonFile(ModuleStatus moduleStatus, Path tmpJsonPath) throws IOException {
        File jsonFile = new File(tmpJsonPath.toString());
        if (!Files.exists(tmpJsonPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(tmpJsonPath.getParent(), new FileAttribute[0]);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            String json = gson.toJson((Object)moduleStatus);
            writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
    }

    public static List<URL> getURLList(List<String> jarFilePaths) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String jarFilePath : jarFilePaths) {
            try {
                urlList.add(Path.of(jarFilePath, new String[0]).toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to create classloader with all jar files", e);
            }
        }
        return urlList;
    }

    public static URLClassLoader createURLClassLoader(List<URL> jarFileUrls) {
        return AccessController.doPrivileged(() -> new URLClassLoader(jarFileUrls.toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
    }

    public static CustomSystemClassLoader createInitialCustomClassLoader() {
        return AccessController.doPrivileged(CustomSystemClassLoader::new);
    }

    public static CustomSystemClassLoader createModifiedCustomClassLoader(Map<String, byte[]> modifiedClassDefs) {
        return AccessController.doPrivileged(() -> new CustomSystemClassLoader(modifiedClassDefs));
    }

    public static void replaceMockedFunctions(TestSuite suite, List<String> jarFilePaths, String instrumentDir, boolean coverage, boolean isFatJarExecution) {
        BTestMain.populateClassNameVsFunctionToMockMap(suite);
        HashMap<String, byte[]> modifiedClassDef = new HashMap<String, byte[]>();
        for (Map.Entry<String, List<String>> entry : classVsMockFunctionsMap.entrySet()) {
            String className = entry.getKey();
            List<String> functionNamesList = entry.getValue();
            byte[] classFile = BTestMain.getModifiedClassBytes(className, functionNamesList, suite, instrumentDir, coverage);
            modifiedClassDef.put(className, classFile);
        }
        classLoader = isFatJarExecution ? BTestMain.createModifiedCustomClassLoader(modifiedClassDef) : BTestMain.createClassLoader(jarFilePaths, modifiedClassDef);
        BTestMain.clearMockFunctionMapBeforeNextModule();
    }

    private static void populateClassNameVsFunctionToMockMap(TestSuite suite) {
        Map<String, String> mockFunctionMap = suite.getMockFunctionNamesMap();
        for (Map.Entry<String, String> entry : mockFunctionMap.entrySet()) {
            String functionToMock;
            String functionToMockClassName;
            String key = entry.getKey();
            if (key.indexOf("~") == -1) {
                functionToMockClassName = key.substring(0, key.indexOf("#"));
                functionToMock = key.substring(key.indexOf("#"));
            } else if (key.indexOf("#") == -1) {
                functionToMockClassName = key.substring(0, key.indexOf("~"));
                functionToMock = key.substring(key.indexOf("~"));
            } else if (key.indexOf("#") < key.indexOf("~")) {
                functionToMockClassName = key.substring(0, key.indexOf("#"));
                functionToMock = key.substring(key.indexOf("#"));
            } else {
                functionToMockClassName = key.substring(0, key.indexOf("~"));
                functionToMock = key.substring(key.indexOf("~"));
            }
            functionToMock = functionToMock.replaceAll("\\\\(.)", "$1");
            classVsMockFunctionsMap.computeIfAbsent(functionToMockClassName, k -> new ArrayList()).add(functionToMock);
        }
    }

    public static byte[] getModifiedClassBytes(String className, List<String> functionNames, TestSuite suite, String instrumentDir, boolean coverage) {
        Class<?> functionToMockClass;
        try {
            functionToMockClass = classLoader.loadClass(className);
        }
        catch (Throwable e) {
            throw new BallerinaTestException("failed to load class: " + className);
        }
        byte[] classFile = new byte[]{};
        boolean readFromBytes = false;
        for (Method method1 : functionToMockClass.getDeclaredMethods()) {
            Class<?> mockFunctionClass;
            if (functionNames.contains("#" + TesterinaUtils.decodeIdentifier(method1.getName()))) {
                Class<?> testClass;
                String desugaredMockFunctionName = "$MOCK_" + method1.getName();
                String testClassName = TesterinaUtils.getQualifiedClassName(suite.getOrgName(), suite.getTestPackageID(), suite.getVersion(), suite.getPackageID().replace(".", "$$$"));
                try {
                    testClass = classLoader.loadClass(testClassName);
                }
                catch (Throwable e) {
                    throw new BallerinaTestException("failed to load class :" + testClassName);
                }
                for (Method method2 : testClass.getDeclaredMethods()) {
                    if (!method2.getName().equals(desugaredMockFunctionName)) continue;
                    if (!readFromBytes) {
                        classFile = BTestMain.replaceMethodBody(method1, method2, instrumentDir, coverage);
                        readFromBytes = true;
                        continue;
                    }
                    classFile = BTestMain.replaceMethodBody(classFile, method1, method2);
                }
                continue;
            }
            if (!functionNames.contains("~" + method1.getName())) continue;
            String key = className + "~" + method1.getName();
            String mockFunctionName = suite.getMockFunctionNamesMap().get(key);
            if (mockFunctionName == null) continue;
            String mockFunctionClassName = suite.getTestUtilityFunctions().get(mockFunctionName);
            try {
                mockFunctionClass = classLoader.loadClass(mockFunctionClassName);
            }
            catch (ClassNotFoundException e) {
                throw new BallerinaTestException("failed to load class: " + mockFunctionClassName);
            }
            for (Method method2 : mockFunctionClass.getDeclaredMethods()) {
                if (!method2.getName().equals(mockFunctionName)) continue;
                if (!readFromBytes) {
                    classFile = BTestMain.replaceMethodBody(method1, method2, instrumentDir, coverage);
                    readFromBytes = true;
                    continue;
                }
                classFile = BTestMain.replaceMethodBody(classFile, method1, method2);
            }
        }
        return classFile;
    }

    private static byte[] replaceMethodBody(Method method, Method mockMethod, String instrumentDir, boolean coverage) {
        ClassReader cr;
        Class<?> clazz = method.getDeclaringClass();
        try (InputStream ins = coverage ? new FileInputStream(instrumentDir + "/" + clazz.getName().replace(".", "/") + ".class") : clazz.getResourceAsStream(clazz.getSimpleName() + ".class");){
            cr = new ClassReader((InputStream)Objects.requireNonNull(ins));
        }
        catch (IOException e) {
            throw new BallerinaTestException("failed to get the class reader object for the class " + clazz.getSimpleName());
        }
        ClassWriter cw = new ClassWriter(cr, 3);
        MockFunctionReplaceVisitor cv = new MockFunctionReplaceVisitor(458752, cw, method.getName(), Type.getMethodDescriptor((Method)method), mockMethod);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static byte[] replaceMethodBody(byte[] classFile, Method method, Method mockMethod) {
        ClassReader cr = new ClassReader(classFile);
        ClassWriter cw = new ClassWriter(cr, 3);
        MockFunctionReplaceVisitor cv = new MockFunctionReplaceVisitor(458752, cw, method.getName(), Type.getMethodDescriptor((Method)method), mockMethod);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static CustomClassLoader createClassLoader(List<String> jarFilePaths, Map<String, byte[]> modifiedClassDef) {
        return new CustomClassLoader(BTestMain.getURLList(jarFilePaths).toArray(new URL[0]), ClassLoader.getSystemClassLoader(), modifiedClassDef);
    }

    private static void clearMockFunctionMapBeforeNextModule() {
        classVsMockFunctionsMap.clear();
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    static {
        classVsMockFunctionsMap = new HashMap<String, List<String>>();
    }
}

