/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class CustomClassLoader
extends URLClassLoader {
    private final HashMap<String, byte[]> modifiedClassDefs;

    public CustomClassLoader(URL[] urls, ClassLoader parent, Map<String, byte[]> modifiedClassDefs) {
        super(urls, parent);
        this.modifiedClassDefs = new HashMap<String, byte[]>(modifiedClassDefs);
    }

    public void loadClassData(String name, byte[] bytes) {
        this.modifiedClassDefs.put(name, bytes);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.modifiedClassDefs.remove(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return super.findClass(name);
    }
}

