/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TestGroup {
    private int testCount = 0;
    private int executedCount = 0;
    private final List<String> beforeGroupsFunctions = new ArrayList<String>();
    private final Map<String, AtomicBoolean> afterGroupsFunctions = new TreeMap<String, AtomicBoolean>();

    public void incrementTestCount() {
        ++this.testCount;
    }

    public void incrementExecutedCount() {
        ++this.executedCount;
    }

    public List<String> getBeforeGroupsFunctions() {
        return this.beforeGroupsFunctions;
    }

    public void addBeforeGroupsFunction(String beforeGroupsFunc) {
        this.beforeGroupsFunctions.add(beforeGroupsFunc);
    }

    public Map<String, AtomicBoolean> getAfterGroupsFunctions() {
        return this.afterGroupsFunctions;
    }

    public void addAfterGroupsFunction(String afterGroupsFunc, AtomicBoolean alwaysRun) {
        this.afterGroupsFunctions.put(afterGroupsFunc, alwaysRun);
    }

    public boolean isFirstTestExecuted() {
        return this.executedCount > 0;
    }

    public boolean isLastTestExecuted() {
        return this.testCount == this.executedCount;
    }

    public void sort() {
        Collections.sort(this.beforeGroupsFunctions);
    }
}

