/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.PackageTestResult;

public class TestReport {
    private String workspaceName;
    private int totalTests;
    private int passed;
    private int failed;
    private int skipped;
    private int coveredLines;
    private int missedLines;
    private float coveragePercentage;
    private final List<PackageTestResult> packages = new ArrayList<PackageTestResult>();

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public List<PackageTestResult> getPackages() {
        return this.packages;
    }

    public void addPackage(PackageTestResult packageObj) {
        this.packages.add(packageObj);
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getCoveredLines() {
        return this.coveredLines;
    }

    public int getMissedLines() {
        return this.missedLines;
    }

    public float getCoveragePercentage() {
        return this.coveragePercentage;
    }

    public void finalizeTestResults(boolean coverage) {
        int totalTestsSum = 0;
        int passedSum = 0;
        int failedSum = 0;
        int skippedSum = 0;
        int coveredLinesSum = 0;
        int missedLinesSum = 0;
        for (PackageTestResult pkg : this.packages) {
            int pkgTotalTests = 0;
            int pkgPassed = 0;
            int pkgFailed = 0;
            int pkgSkipped = 0;
            int pkgCoveredLines = 0;
            int pkgMissedLines = 0;
            for (ModuleStatus modStatus : pkg.getModuleStatus()) {
                if (".".equals(modStatus.getName())) {
                    modStatus.setName(pkg.getProjectName());
                }
                pkgTotalTests = (pkgPassed += modStatus.getPassed()) + (pkgFailed += modStatus.getFailed()) + (pkgSkipped += modStatus.getSkipped());
            }
            if (coverage) {
                for (ModuleCoverage modCov : pkg.getModuleCoverage()) {
                    if (".".equals(modCov.getName())) {
                        modCov.setName(pkg.getProjectName());
                    }
                    pkgCoveredLines += modCov.getCoveredLines();
                    pkgMissedLines += modCov.getMissedLines();
                }
                if (pkgCoveredLines + pkgMissedLines > 0) {
                    float pkgCoverageVal = (float)pkgCoveredLines / (float)(pkgCoveredLines + pkgMissedLines) * 100.0f;
                    pkg.setCoveragePercentage((float)((double)Math.round((double)pkgCoverageVal * 100.0) / 100.0));
                }
            }
            pkg.setTotalTests(pkgTotalTests);
            pkg.setPassed(pkgPassed);
            pkg.setFailed(pkgFailed);
            pkg.setSkipped(pkgSkipped);
            pkg.setCoveredLines(pkgCoveredLines);
            pkg.setMissedLines(pkgMissedLines);
            totalTestsSum += pkgTotalTests;
            passedSum += pkgPassed;
            failedSum += pkgFailed;
            skippedSum += pkgSkipped;
            coveredLinesSum += pkgCoveredLines;
            missedLinesSum += pkgMissedLines;
            for (ModuleCoverage modCov : pkg.getModuleCoverage()) {
                boolean doesExist = false;
                for (ModuleStatus modStatus : pkg.getModuleStatus()) {
                    if (!modCov.getName().equals(modStatus.getName())) continue;
                    doesExist = true;
                    break;
                }
                if (doesExist) continue;
                ModuleStatus missingModuleStatus = new ModuleStatus();
                missingModuleStatus.setName(modCov.getName());
                pkg.addModuleStatus(missingModuleStatus);
            }
            pkg.setModuleStatus(pkg.getModuleStatus().stream().sorted(Comparator.comparing(ModuleStatus::getName)).toList());
            pkg.setModuleCoverage(pkg.getModuleCoverage().stream().sorted(Comparator.comparing(ModuleCoverage::getName)).toList());
        }
        this.totalTests = totalTestsSum;
        this.passed = passedSum;
        this.failed = failedSum;
        this.skipped = skippedSum;
        this.coveredLines = coveredLinesSum;
        this.missedLines = missedLinesSum;
        if (coverage && coveredLinesSum + missedLinesSum > 0) {
            float coverageVal = (float)coveredLinesSum / (float)(coveredLinesSum + missedLinesSum) * 100.0f;
            this.coveragePercentage = (float)((double)Math.round((double)coverageVal * 100.0) / 100.0);
        }
        this.packages.sort(Comparator.comparing(PackageTestResult::getProjectName));
    }
}

