/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ballerinalang.test.runtime.entity.Test;
import org.ballerinalang.test.runtime.entity.TestGroup;

public class TestSuite {
    private String orgName;
    private String version;
    private String packageName;
    private String moduleName;
    private final String packageId;
    private final String testPackageId;
    private String executeFilePath;
    private String initFunctionName;
    private String startFunctionName;
    private String stopFunctionName;
    private String testInitFunctionName;
    private String testStartFunctionName;
    private String testStopFunctionName;
    private String sourceRootPath;
    private String sourceFileName;
    private final Map<String, String> testUtilityFunctions = new HashMap<String, String>();
    private final List<String> beforeSuiteFunctionNames = new ArrayList<String>();
    private final Map<String, AtomicBoolean> afterSuiteFunctionNames = new TreeMap<String, AtomicBoolean>();
    private final List<String> beforeEachFunctionNames = new ArrayList<String>();
    private final List<String> afterEachFunctionNames = new ArrayList<String>();
    private List<Test> tests = new ArrayList<Test>();
    private final Map<String, TestGroup> groups = new TreeMap<String, TestGroup>();
    private final List<String> testExecutionDependencies = new ArrayList<String>();
    private boolean isReportRequired;
    private boolean isSingleDDTExecution;
    private Map<String, List<String>> dataKeyValues;
    private Map<String, String> mockFunctionNamesMap = new HashMap<String, String>();

    public TestSuite(String packageId, String testPackageId, String packageName, String orgName, String version, String executeFilePath) {
        this.packageId = packageId;
        this.testPackageId = testPackageId;
        this.packageName = packageName;
        this.orgName = orgName;
        this.version = version;
        this.executeFilePath = executeFilePath;
    }

    public String getPackageID() {
        return this.packageId;
    }

    public String getTestPackageID() {
        return this.testPackageId;
    }

    public String getSourceRootPath() {
        return this.sourceRootPath;
    }

    public void setSourceRootPath(String sourceRootPath) {
        this.sourceRootPath = sourceRootPath;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setExecuteFilePath(String executeFilePath) {
        this.executeFilePath = executeFilePath;
    }

    public String getExecuteFilePath() {
        return this.executeFilePath;
    }

    public String getInitFunctionName() {
        return this.initFunctionName;
    }

    public void setInitFunctionName(String initFunctionName) {
        this.initFunctionName = initFunctionName;
    }

    public String getStartFunctionName() {
        return this.startFunctionName;
    }

    public void setStartFunctionName(String startFunctionName) {
        this.startFunctionName = startFunctionName;
    }

    public String getStopFunctionName() {
        return this.stopFunctionName;
    }

    public void setStopFunctionName(String stopFunctionName) {
        this.stopFunctionName = stopFunctionName;
    }

    public String getTestInitFunctionName() {
        return this.testInitFunctionName;
    }

    public void setTestInitFunctionName(String testInitFunctionName) {
        this.testInitFunctionName = testInitFunctionName;
    }

    public String getTestStartFunctionName() {
        return this.testStartFunctionName;
    }

    public void setTestStartFunctionName(String testStartFunctionName) {
        this.testStartFunctionName = testStartFunctionName;
    }

    public String getTestStopFunctionName() {
        return this.testStopFunctionName;
    }

    public void setTestStopFunctionName(String testStopFunctionName) {
        this.testStopFunctionName = testStopFunctionName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Map<String, String> getTestUtilityFunctions() {
        return this.testUtilityFunctions;
    }

    public List<String> getBeforeSuiteFunctionNames() {
        return this.beforeSuiteFunctionNames;
    }

    public Map<String, AtomicBoolean> getAfterSuiteFunctionNames() {
        return this.afterSuiteFunctionNames;
    }

    public List<String> getBeforeEachFunctionNames() {
        return this.beforeEachFunctionNames;
    }

    public List<String> getAfterEachFunctionNames() {
        return this.afterEachFunctionNames;
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public void setTests(List<Test> tests) {
        this.tests = tests;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void addBeforeSuiteFunction(String function) {
        this.beforeSuiteFunctionNames.add(function);
    }

    public void addAfterSuiteFunction(String function, AtomicBoolean alwaysRun) {
        this.afterSuiteFunctionNames.put(function, alwaysRun);
    }

    public void addBeforeEachFunction(String function) {
        this.beforeEachFunctionNames.add(function);
    }

    public void addAfterEachFunction(String function) {
        this.afterEachFunctionNames.add(function);
    }

    public void addMockFunction(String id, String function) {
        this.mockFunctionNamesMap.put(id, function);
    }

    public Map<String, String> getMockFunctionNamesMap() {
        return this.mockFunctionNamesMap;
    }

    public void removeAllMockFunctions() {
        this.mockFunctionNamesMap = new HashMap<String, String>();
    }

    public void addTestUtilityFunction(String functionName, String functionClassName) {
        this.testUtilityFunctions.put(functionName, functionClassName);
    }

    public void addTests(Test test) {
        this.tests.add(test);
    }

    public boolean isReportRequired() {
        return this.isReportRequired;
    }

    public void setReportRequired(boolean reportRequired) {
        this.isReportRequired = reportRequired;
    }

    public Map<String, TestGroup> getGroups() {
        return this.groups;
    }

    public void addAfterGroupFunction(String afterGroupFunc, List<String> groups, AtomicBoolean alwaysRun) {
        for (String groupName : groups) {
            if (this.groups.get(groupName) == null) {
                this.groups.put(groupName, new TestGroup());
            }
            this.groups.get(groupName).addAfterGroupsFunction(afterGroupFunc, alwaysRun);
        }
    }

    public void addBeforeGroupsFunction(String beforeGroupsFunc, List<String> groups) {
        for (String groupName : groups) {
            if (this.groups.get(groupName) == null) {
                this.groups.put(groupName, new TestGroup());
            }
            this.groups.get(groupName).addBeforeGroupsFunction(beforeGroupsFunc);
        }
    }

    public void addTestToGroups(Test test) {
        for (String groupName : test.getGroups()) {
            TestGroup testGroup = this.getGroups().get(groupName) != null ? this.getGroups().get(groupName) : new TestGroup();
            testGroup.incrementTestCount();
            this.groups.put(groupName, testGroup);
        }
    }

    public void sort() {
        Collections.sort(this.beforeEachFunctionNames);
        Collections.sort(this.afterEachFunctionNames);
        Collections.sort(this.beforeSuiteFunctionNames);
        Collections.sort(this.tests, new Comparator<Test>(this){

            @Override
            public int compare(Test t1, Test t2) {
                return t1.getTestName().compareTo(t2.getTestName());
            }
        });
        for (TestGroup testGroup : this.groups.values()) {
            testGroup.sort();
        }
    }

    public void addTestExecutionDependencies(Collection<Path> dependencies) {
        dependencies.forEach(path -> this.testExecutionDependencies.add(path.toString()));
    }

    public List<String> getTestExecutionDependencies() {
        return this.testExecutionDependencies;
    }

    public void removeAllTestExecutionDependencies() {
        this.testExecutionDependencies.clear();
    }

    public boolean isSingleDDTExecution() {
        return this.isSingleDDTExecution;
    }

    public void setSingleDDTExecution(boolean isSingleDDTExecution) {
        this.isSingleDDTExecution = isSingleDDTExecution;
    }

    public Map<String, List<String>> getDataKeyValues() {
        return this.dataKeyValues;
    }

    public void setDataKeyValues(Map<String, List<String>> dataKeyValues) {
        this.dataKeyValues = dataKeyValues;
    }
}

