/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.util;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.ballerinalang.test.runtime.entity.Test;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.exceptions.BallerinaTestException;

public final class TesterinaUtils {
    private static final PrintStream errStream = System.err;
    private static final String GENERATE_OBJECT_CLASS_PREFIX = ".values.\\$";
    private static final String GENERATE_PKG_INIT = "___init_";
    private static final String GENERATE_PKG_START = "___start_";
    private static final String GENERATE_PKG_STOP = "___stop_";
    private static final String INIT_FUNCTION_SUFFIX = "..<init>";
    private static final String START_FUNCTION_SUFFIX = ".<start>";
    private static final String STOP_FUNCTION_SUFFIX = ".<stop>";

    private TesterinaUtils() {
    }

    public static void cleanUpDir(Path path) {
        block8: {
            try {
                if (!Files.exists(path, new LinkOption[0])) break block8;
                try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
                    paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            catch (IOException e) {
                errStream.println("Error occurred while deleting the dir : " + String.valueOf(path) + " with error : " + e.getMessage());
            }
        }
    }

    public static int executeTests(Path sourceRootPath, TestSuite testSuite, ClassLoader classLoader, String[] args, PrintStream out) throws RuntimeException {
        try {
            int exitStatus = TesterinaUtils.execute(testSuite, classLoader, args, out);
            TesterinaUtils.cleanUpDir(sourceRootPath.resolve(".testerina"));
            return exitStatus;
        }
        catch (BallerinaTestException e) {
            if (e.getMessage() != null) {
                errStream.println("error: " + e.getMessage());
            }
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("test execution failed due to runtime exception");
        }
    }

    private static int execute(TestSuite suite, ClassLoader classLoader, String[] args, PrintStream out) {
        Class<?> initClazz;
        String initClassName = TesterinaUtils.getQualifiedClassName(suite.getOrgName(), suite.getTestPackageID(), suite.getVersion(), "$_init");
        try {
            initClazz = classLoader.loadClass(initClassName);
        }
        catch (Throwable e) {
            throw new BallerinaTestException("failed to load init class :" + initClassName);
        }
        String suiteExecuteFilePath = suite.getExecuteFilePath();
        if (suiteExecuteFilePath.isEmpty()) {
            out.println("\tNo tests found");
            return 0;
        }
        TesterinaUtils.startSuite(initClazz, args);
        return TesterinaUtils.getTestExecutionState(initClazz);
    }

    private static void startSuite(Class<?> initClazz, String[] args) {
        Object response = TesterinaUtils.runTestModuleMain(initClazz, args, String[].class);
        if (response instanceof Throwable) {
            Throwable throwable = (Throwable)response;
            throw new BallerinaTestException("dependant module execution for test suite failed due to " + RuntimeUtils.formatErrorMessage((Throwable)throwable), throwable);
        }
    }

    private static Object runTestModuleMain(Class<?> initClazz, String[] args, Class<?> ... parameterTypes) {
        try {
            Method method = initClazz.getDeclaredMethod("main", parameterTypes);
            return method.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof BError) {
                return targetException;
            }
            return targetException;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
            return new BallerinaTestException("Failed to invoke the function 'main due to " + RuntimeUtils.formatErrorMessage((Throwable)e), e);
        }
    }

    private static int getTestExecutionState(Class<?> initClazz) {
        try {
            Method method = initClazz.getDeclaredMethod("$getTestExecutionState", new Class[0]);
            return Math.toIntExact((Long)method.invoke(null, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new BallerinaTestException("Failed to invoke the function '$getTestExecutionState due to " + RuntimeUtils.formatErrorMessage((Throwable)e), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String formatError(String errorMsg) {
        StringBuilder newErrMsg = new StringBuilder();
        errorMsg = errorMsg.replace("\n", "\n\t");
        List<String> msgParts = Arrays.asList(errorMsg.split("\n"));
        boolean stackTraceStartFlag = true;
        for (String string : msgParts) {
            void var5_5;
            if (msgParts.indexOf(string) != 0 && !string.equals("\t    ")) {
                Object prefix = "\t\t    \t";
                if (string.startsWith("\t\t") && stackTraceStartFlag) {
                    prefix = "\n" + (String)prefix;
                    stackTraceStartFlag = false;
                }
                String string2 = (String)prefix + string.trim();
            }
            if (var5_5.equals("\t    ")) continue;
            newErrMsg.append((String)var5_5).append("\n");
        }
        return newErrMsg.toString();
    }

    public static String getQualifiedClassName(String orgName, String packageName, String version, String className) {
        if (!".".equals(packageName)) {
            className = Utils.encodeNonFunctionIdentifier((String)packageName) + "." + RuntimeUtils.getMajorVersion((String)version) + "." + (String)className;
        }
        if (!"$anon".equals(orgName)) {
            className = Utils.encodeNonFunctionIdentifier((String)orgName) + "." + (String)className;
        }
        return className;
    }

    private static List<String> getUpdatedFunctionList(List<Test> currentTests, List<String> functions) {
        ArrayList<String> updatedFunctionList = new ArrayList<String>(functions);
        for (String functionName : functions) {
            List<String> dependentFunctions = TesterinaUtils.getAllDependentFunctions(TesterinaUtils.getTest(functionName, currentTests), currentTests);
            for (String dependentTest : dependentFunctions) {
                if (updatedFunctionList.contains(dependentTest)) continue;
                updatedFunctionList.add(dependentTest);
            }
        }
        return updatedFunctionList;
    }

    private static Test getTest(String testName, List<Test> tests) {
        for (Test test : tests) {
            if (!testName.equals(test.getTestName())) continue;
            return test;
        }
        return null;
    }

    private static List<String> getAllDependentFunctions(Test test, List<Test> currentTests) {
        List<String> dependentTests;
        ArrayList<String> completeDependentTestList = new ArrayList<String>();
        if (test != null && (dependentTests = test.getDependsOnTestFunctions()) != null) {
            for (String dependentTest : dependentTests) {
                if (!completeDependentTestList.contains(dependentTest)) {
                    completeDependentTestList.add(dependentTest);
                }
                List<String> otherDependentTests = TesterinaUtils.getAllDependentFunctions(TesterinaUtils.getTest(dependentTest, currentTests), currentTests);
                for (String otherDependentTest : otherDependentTests) {
                    if (completeDependentTestList.contains(otherDependentTest)) continue;
                    completeDependentTestList.add(otherDependentTest);
                }
            }
        }
        return completeDependentTestList;
    }

    public static List<Test> getSingleExecutionTests(TestSuite suite, List<String> functions) {
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String function : functions) {
            if (function.contains(":")) {
                String[] functionDetail = function.split(":");
                try {
                    if (!functionDetail[0].equals(suite.getPackageID())) continue;
                    TesterinaUtils.handleWildCards(filteredList, suite.getTests(), functionDetail[1]);
                }
                catch (IndexOutOfBoundsException e) {
                    errStream.println("Error occurred while executing tests. Test list cannot be empty");
                }
                continue;
            }
            TesterinaUtils.handleWildCards(filteredList, suite.getTests(), function);
        }
        List<Test> currentTests = suite.getTests();
        List<String> updatedFunctionList = TesterinaUtils.getUpdatedFunctionList(currentTests, filteredList);
        ArrayList<Test> updatedTestList = new ArrayList<Test>();
        for (Test test : currentTests) {
            if (!updatedFunctionList.contains(test.getTestName())) continue;
            updatedTestList.add(test);
        }
        return updatedTestList;
    }

    private static void handleWildCards(List<String> filteredList, List<Test> suiteTests, String function) {
        if (function.contains("*")) {
            for (Test test : suiteTests) {
                if (!Pattern.matches(function.replace("*", ".*"), test.getTestName())) continue;
                filteredList.add(test.getTestName());
            }
        } else {
            filteredList.add(function);
        }
    }

    public static List<Test> getSingleExecutionTestsOld(List<Test> currentTests, List<String> functions) {
        return Collections.emptyList();
    }

    public static StackTraceElement[] getStackTrace(Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        LinkedList filteredStack = new LinkedList();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement = TesterinaUtils.filterStackTraceElement(stackFrame, index++);
            stackTraceElement.ifPresent(filteredStack::add);
        }
        StackTraceElement[] filteredStackArray = new StackTraceElement[filteredStack.size()];
        return filteredStack.toArray(filteredStackArray);
    }

    private static Optional<StackTraceElement> filterStackTraceElement(StackTraceElement stackFrame, int currentIndex) {
        String fileName = stackFrame.getFileName();
        int lineNo = stackFrame.getLineNumber();
        if (lineNo < 0) {
            return Optional.empty();
        }
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        if (className.equals("$_init")) {
            if (currentIndex == 0) {
                return Optional.empty();
            }
            switch (methodName) {
                case "___init_": {
                    methodName = INIT_FUNCTION_SUFFIX;
                    break;
                }
                case "___start_": {
                    methodName = START_FUNCTION_SUFFIX;
                    break;
                }
                case "___stop_": {
                    methodName = STOP_FUNCTION_SUFFIX;
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(new StackTraceElement(TesterinaUtils.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
        }
        if (fileName != null && !fileName.endsWith(".bal")) {
            return Optional.empty();
        }
        return Optional.of(new StackTraceElement(TesterinaUtils.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
    }

    private static String cleanupClassName(String className) {
        return className.replace(GENERATE_OBJECT_CLASS_PREFIX, ".");
    }

    public static String decodeIdentifier(String encodedIdentifier) {
        if (encodedIdentifier == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < encodedIdentifier.length()) {
            if (encodedIdentifier.charAt(index) == '$' && index + 4 < encodedIdentifier.length()) {
                if (TesterinaUtils.isUnicodePoint(encodedIdentifier, index)) {
                    sb.append((char)Integer.parseInt(encodedIdentifier.substring(index + 1, index + 5)));
                    index += 5;
                    continue;
                }
                sb.append(encodedIdentifier.charAt(index));
                ++index;
                continue;
            }
            sb.append(encodedIdentifier.charAt(index));
            ++index;
        }
        return sb.toString();
    }

    private static boolean isUnicodePoint(String encodedName, int index) {
        return TesterinaUtils.containsOnlyDigits(encodedName.substring(index + 1, index + 5));
    }

    private static boolean containsOnlyDigits(String digitString) {
        for (int i = 0; i < digitString.length(); ++i) {
            if (Character.isDigit(digitString.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

