/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.os.compiler.staticcodeanalyzer;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.os.compiler.staticcodeanalyzer.OSRule;
import io.ballerina.tools.diagnostics.Location;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OSCommandInjectionAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;
    private static final String PUBLIC_QUALIFIER = "public";
    private static final String OS = "os";
    private static final String EXEC = "exec";
    private static final String ARGUMENTS = "arguments";
    private static final String BALLERINA_ORG = "ballerina";
    private static final String SET_ENV = "setEnv";
    private static final String VALUE = "value";

    public OSCommandInjectionAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        NodeLocation location;
        Node node = context.node();
        if (!(node instanceof FunctionCallExpressionNode)) {
            return;
        }
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)node;
        SemanticModel semanticModel = context.semanticModel();
        Document document = this.getDocument(context);
        List<String> importPrefix = new ArrayList<String>();
        Node node2 = document.syntaxTree().rootNode();
        if (node2 instanceof ModulePartNode) {
            ModulePartNode modulePartNode = (ModulePartNode)node2;
            importPrefix = modulePartNode.imports().stream().filter(importDeclarationNode -> {
                ImportOrgNameNode importOrgNameNode = importDeclarationNode.orgName().orElse(null);
                return importOrgNameNode != null && BALLERINA_ORG.equals(importOrgNameNode.orgName().text());
            }).filter(importDeclarationNode -> importDeclarationNode.moduleName().stream().anyMatch(moduleNameNode -> OS.equals(moduleNameNode.text()))).map(importDeclarationNode -> {
                ImportPrefixNode importPrefixNode = importDeclarationNode.prefix().orElse(null);
                return importPrefixNode != null ? importPrefixNode.prefix().text() : OS;
            }).toList();
        }
        if (this.isOsExecCall(functionCall, importPrefix, semanticModel) && this.containsUserControlledInput((SeparatedNodeList<FunctionArgumentNode>)functionCall.arguments(), context)) {
            location = functionCall.location();
            this.reporter.reportIssue(document, (Location)location, OSRule.AVOID_UNSANITIZED_CMD_ARGS.getId());
        }
        if (this.isOsSetEnvCall(functionCall, importPrefix, semanticModel) && this.containsUntrustedEnvValue((SeparatedNodeList<FunctionArgumentNode>)functionCall.arguments(), context)) {
            location = functionCall.location();
            this.reporter.reportIssue(document, (Location)location, OSRule.AVOID_UNSANITIZED_ENV_VARS.getId());
        }
    }

    public boolean isOsExecCall(FunctionCallExpressionNode functionCall, List<String> importPrefix, SemanticModel semanticModel) {
        return this.isOsFunctionCall(functionCall, importPrefix, EXEC, semanticModel);
    }

    public boolean isOsSetEnvCall(FunctionCallExpressionNode functionCall, List<String> importPrefix, SemanticModel semanticModel) {
        return this.isOsFunctionCall(functionCall, importPrefix, SET_ENV, semanticModel);
    }

    private boolean isOsFunctionCall(FunctionCallExpressionNode functionCall, List<String> importPrefix, String functionName, SemanticModel semanticModel) {
        NameReferenceNode nameReferenceNode = functionCall.functionName();
        if (!(nameReferenceNode instanceof QualifiedNameReferenceNode)) {
            return false;
        }
        QualifiedNameReferenceNode qNode = (QualifiedNameReferenceNode)nameReferenceNode;
        Optional modulePrefixSymbol = semanticModel.symbol((Node)qNode.modulePrefix());
        Optional functionSymbol = semanticModel.symbol((Node)qNode.identifier());
        if (modulePrefixSymbol.isEmpty() || functionSymbol.isEmpty()) {
            return false;
        }
        if (((Symbol)modulePrefixSymbol.get()).getName().isEmpty() || ((Symbol)functionSymbol.get()).getName().isEmpty()) {
            return false;
        }
        return importPrefix.contains(((Symbol)modulePrefixSymbol.get()).getName().get()) && ((String)((Symbol)functionSymbol.get()).getName().get()).equals(functionName);
    }

    public Document getDocument(SyntaxNodeAnalysisContext context) {
        return context.currentPackage().module(context.moduleId()).document(context.documentId());
    }

    private boolean containsUserControlledInput(SeparatedNodeList<FunctionArgumentNode> arguments, SyntaxNodeAnalysisContext context) {
        for (FunctionArgumentNode arg : arguments) {
            ExpressionNode expr = this.extractExpression(arg);
            if (expr == null || !this.isMappingConstructorWithUserControlledInput(expr, context)) continue;
            return true;
        }
        return false;
    }

    private boolean containsUntrustedEnvValue(SeparatedNodeList<FunctionArgumentNode> arguments, SyntaxNodeAnalysisContext context) {
        int idx = 0;
        for (FunctionArgumentNode arg : arguments) {
            ExpressionNode expr = this.extractExpression(arg);
            if (expr == null) {
                ++idx;
                continue;
            }
            if ((this.isNamedValueArgument(arg) || this.isSecondPositionalArgument(arg, idx)) && this.isUserControlledInput((Node)expr, context)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private boolean isNamedValueArgument(FunctionArgumentNode arg) {
        NamedArgumentNode named;
        return arg instanceof NamedArgumentNode && (named = (NamedArgumentNode)arg).argumentName().name().text().equals(VALUE);
    }

    private boolean isSecondPositionalArgument(FunctionArgumentNode arg, int idx) {
        return arg instanceof PositionalArgumentNode && idx == 1;
    }

    private ExpressionNode extractExpression(FunctionArgumentNode arg) {
        FunctionArgumentNode functionArgumentNode = arg;
        Objects.requireNonNull(functionArgumentNode);
        FunctionArgumentNode functionArgumentNode2 = functionArgumentNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PositionalArgumentNode.class, NamedArgumentNode.class}, (Object)functionArgumentNode2, n)) {
            case 0 -> {
                PositionalArgumentNode posArg = (PositionalArgumentNode)functionArgumentNode2;
                yield posArg.expression();
            }
            case 1 -> {
                NamedArgumentNode namedArg = (NamedArgumentNode)functionArgumentNode2;
                yield namedArg.expression();
            }
            default -> null;
        };
    }

    private boolean isMappingConstructorWithUserControlledInput(ExpressionNode expr, SyntaxNodeAnalysisContext context) {
        if (!(expr instanceof MappingConstructorExpressionNode)) {
            return false;
        }
        MappingConstructorExpressionNode mappingNode = (MappingConstructorExpressionNode)expr;
        return mappingNode.fields().stream().filter(SpecificFieldNode.class::isInstance).map(SpecificFieldNode.class::cast).anyMatch(specificField -> this.isUserControlledField((SpecificFieldNode)specificField, context));
    }

    private boolean isUserControlledField(SpecificFieldNode specificField, SyntaxNodeAnalysisContext context) {
        String fieldName = specificField.fieldName().toString().trim();
        if (!fieldName.equals(ARGUMENTS)) {
            return false;
        }
        ExpressionNode valueExpr = specificField.valueExpr().orElse(null);
        return this.containsUserControlledInput(valueExpr, context);
    }

    private boolean containsUserControlledInput(ExpressionNode valueExpr, SyntaxNodeAnalysisContext context) {
        SimpleNameReferenceNode refNode;
        if (valueExpr instanceof ListConstructorExpressionNode) {
            ListConstructorExpressionNode listNode = (ListConstructorExpressionNode)valueExpr;
            return listNode.expressions().stream().anyMatch(item -> this.isUserControlledInput((Node)item, context));
        }
        return valueExpr instanceof SimpleNameReferenceNode && this.isUserControlledInput((Node)(refNode = (SimpleNameReferenceNode)valueExpr), context);
    }

    private boolean isUserControlledInput(Node node, SyntaxNodeAnalysisContext context) {
        SemanticModel semanticModel = context.semanticModel();
        if (semanticModel.symbol(node).isEmpty()) {
            return false;
        }
        Symbol symbol = (Symbol)semanticModel.symbol(node).get();
        if (symbol.kind() == SymbolKind.PARAMETER && this.isInsidePublicFunction(node)) {
            return true;
        }
        if (symbol.kind() == SymbolKind.VARIABLE) {
            return this.isAssignedUserControlledInput(node);
        }
        return false;
    }

    private boolean isInsidePublicFunction(Node node) {
        for (Node parent = node; parent != null; parent = parent.parent()) {
            if (!(parent instanceof FunctionDefinitionNode)) continue;
            FunctionDefinitionNode functionNode = (FunctionDefinitionNode)parent;
            return functionNode.qualifierList().stream().anyMatch(q -> q.text().equals(PUBLIC_QUALIFIER));
        }
        return false;
    }

    private boolean isAssignedUserControlledInput(Node node) {
        for (NonTerminalNode parent = node.parent(); parent != null; parent = parent.parent()) {
            FunctionDefinitionNode functionNode;
            if (!(parent instanceof FunctionDefinitionNode) || !this.isInsidePublicFunction((Node)(functionNode = (FunctionDefinitionNode)parent))) continue;
            for (ParameterNode param : functionNode.functionSignature().parameters()) {
                String paramName;
                RequiredParameterNode requiredParam;
                if (!(param instanceof RequiredParameterNode) || !(requiredParam = (RequiredParameterNode)param).paramName().isPresent() || !this.isVariableAssignedFrom(node, paramName = ((Token)requiredParam.paramName().get()).text(), functionNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVariableAssignedFrom(Node variable, String paramName, FunctionDefinitionNode functionNode) {
        FunctionBodyNode body = functionNode.functionBody();
        if (body instanceof FunctionBodyBlockNode) {
            FunctionBodyBlockNode blockBody = (FunctionBodyBlockNode)body;
            for (StatementNode statement : blockBody.statements()) {
                if (this.isVariableDeclaredWithParam(statement, paramName)) {
                    return true;
                }
                if (!this.isVariableAssignedWithParam(statement, variable, paramName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVariableDeclaredWithParam(StatementNode statement, String paramName) {
        if (!(statement instanceof VariableDeclarationNode)) {
            return false;
        }
        VariableDeclarationNode varDecl = (VariableDeclarationNode)statement;
        return varDecl.initializer().map(initializer -> this.isExpressionMatchingParam((ExpressionNode)initializer, paramName)).orElse(false);
    }

    private boolean isVariableAssignedWithParam(StatementNode statement, Node variable, String paramName) {
        if (!(statement instanceof AssignmentStatementNode)) {
            return false;
        }
        AssignmentStatementNode assignment = (AssignmentStatementNode)statement;
        String assignedVar = assignment.varRef().toSourceCode();
        ExpressionNode assignedValue = assignment.expression();
        if (!assignedVar.equals(variable.toSourceCode())) {
            return false;
        }
        return this.isExpressionMatchingParam(assignedValue, paramName);
    }

    private boolean isExpressionMatchingParam(ExpressionNode expression, String paramName) {
        if (expression.toSourceCode().equals(paramName)) {
            return true;
        }
        if (expression instanceof ListConstructorExpressionNode) {
            ListConstructorExpressionNode listExpr = (ListConstructorExpressionNode)expression;
            return listExpr.expressions().stream().anyMatch(item -> item.toSourceCode().equals(paramName));
        }
        return false;
    }
}

