/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.os.compiler.staticcodeanalyzer;

import io.ballerina.scan.Rule;
import io.ballerina.scan.RuleKind;
import io.ballerina.stdlib.os.compiler.staticcodeanalyzer.RuleFactory;

public enum OSRule {
    AVOID_UNSANITIZED_CMD_ARGS(RuleFactory.createRule(1, "Avoid constructing system command arguments from user input without proper sanitization", RuleKind.VULNERABILITY)),
    AVOID_UNSANITIZED_ENV_VARS(RuleFactory.createRule(2, "Avoid constructing environment variables from user input without proper sanitization", RuleKind.VULNERABILITY));

    private final Rule rule;

    private OSRule(Rule rule) {
        this.rule = rule;
    }

    public int getId() {
        return this.rule.numericId();
    }

    public String getDescription() {
        return this.rule.description();
    }

    public String toString() {
        return "{\"id\":" + this.getId() + ", \"kind\":\"" + String.valueOf(this.rule.kind()) + "\", \"description\" : \"" + this.rule.description() + "\"}";
    }
}

