/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.utils.MapUtils;
import org.ballerinalang.langlib.map.util.MapLibUtils;

public final class Filter {
    private Filter() {
    }

    public static BMap<?, ?> filter(Environment env, BMap<?, ?> m, BFunctionPointer func) {
        Type mapType = TypeUtils.getImpliedType((Type)m.getType());
        Type constraint = switch (mapType.getTag()) {
            case 27 -> {
                MapType type = (MapType)mapType;
                yield type.getConstrainedType();
            }
            case 24 -> MapLibUtils.getCommonTypeForRecordField((RecordType)mapType);
            default -> throw MapUtils.createOpNotSupportedError((Type)mapType, (String)"filter()");
        };
        BMap newMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)constraint));
        int size = m.size();
        Object[] keys = m.getKeys();
        for (int i = 0; i < size; ++i) {
            Object key = keys[i];
            boolean isFiltered = (Boolean)func.call(env.getRuntime(), new Object[]{m.get(keys[i])});
            if (!isFiltered) continue;
            Object value = m.get(key);
            newMap.put((Object)((BString)key), value);
        }
        return newMap;
    }
}

