/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.tcp.TcpClient;
import io.ballerina.stdlib.tcp.TcpListener;
import io.ballerina.stdlib.tcp.TcpService;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public class TcpFactory {
    private static volatile TcpFactory tcpFactory;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    private TcpFactory() {
        int totalNumberOfProcessors = Runtime.getRuntime().availableProcessors();
        this.bossGroup = new NioEventLoopGroup(totalNumberOfProcessors);
        this.workerGroup = new NioEventLoopGroup(totalNumberOfProcessors * 2);
    }

    public static TcpFactory getInstance() {
        if (tcpFactory == null) {
            tcpFactory = new TcpFactory();
        }
        return tcpFactory;
    }

    public TcpClient createTcpClient(InetSocketAddress localAddress, InetSocketAddress remoteAddress, CompletableFuture<Object> callback, BMap<BString, Object> secureSocket) {
        return new TcpClient(localAddress, remoteAddress, this.workerGroup, callback, secureSocket);
    }

    public TcpListener createTcpListener(InetSocketAddress localAddress, CompletableFuture<Object> callback, TcpService tcpService, BMap<BString, Object> secureSocket) {
        return new TcpListener(localAddress, this.bossGroup, this.workerGroup, callback, tcpService, secureSocket);
    }
}

