/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.tcp.Constants;
import io.ballerina.stdlib.tcp.Dispatcher;
import io.ballerina.stdlib.tcp.SSLConfig;
import io.ballerina.stdlib.tcp.SSLHandlerFactory;
import io.ballerina.stdlib.tcp.SslHandshakeListenerEventHandler;
import io.ballerina.stdlib.tcp.TcpListenerHandler;
import io.ballerina.stdlib.tcp.TcpService;
import io.ballerina.stdlib.tcp.Utils;
import io.ballerina.stdlib.tcp.WriteFlowController;
import io.ballerina.stdlib.tcp.WriteFlowControllerService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpListener {
    private Channel channel;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private SslContext sslContext;

    public TcpListener(InetSocketAddress localAddress, EventLoopGroup bossGroup, EventLoopGroup workerGroup, final CompletableFuture<Object> callback, final TcpService tcpService, final BMap<BString, Object> secureSocket) {
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        final AtomicBoolean isCallbackCompleted = new AtomicBoolean(false);
        ServerBootstrap listenerBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)listenerBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<ServerSocketChannel>(){

            protected void initChannel(ServerSocketChannel channel) throws Exception {
                if (secureSocket != null) {
                    TcpListener.this.sslContext = TcpListener.this.getSslContext((BMap<BString, Object>)secureSocket);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                callback.complete(Utils.createTcpError(cause.getMessage()));
                isCallbackCompleted.set(true);
                ctx.close();
            }
        })).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                TcpListenerHandler tcpListenerHandler = new TcpListenerHandler(tcpService);
                if (secureSocket != null) {
                    TcpListener.this.setSslHandler((Channel)channel, TcpListener.this.sslContext, tcpListenerHandler, (BMap<BString, Object>)secureSocket);
                } else {
                    channel.pipeline().addLast("listenerHandler", (ChannelHandler)tcpListenerHandler);
                }
            }
        }).bind((SocketAddress)localAddress).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.channel = channelFuture.channel();
                callback.complete(null);
            } else if (!isCallbackCompleted.get()) {
                callback.complete((Object)Utils.createTcpError(String.format("Error initializing the server: %s", channelFuture.cause().getMessage())));
            }
        }));
    }

    private SslContext getSslContext(BMap<BString, Object> secureSocket) throws Exception {
        SSLConfig sslConfig = Utils.setSslConfig(secureSocket, new SSLConfig(), true);
        SSLHandlerFactory sslHandlerFactory = new SSLHandlerFactory(sslConfig);
        return sslHandlerFactory.createContextForServer();
    }

    private void setSslHandler(Channel channel, SslContext sslContext, TcpListenerHandler tcpListenerHandler, BMap<BString, Object> secureSocket) {
        SslHandler sslHandler = sslContext.newHandler(channel.alloc());
        sslHandler.setHandshakeTimeout(Utils.getLongValueOrDefault(secureSocket, Constants.SECURESOCKET_CONFIG_HANDSHAKE_TIMEOUT), TimeUnit.SECONDS);
        channel.pipeline().addFirst("SSL_Handler", (ChannelHandler)sslHandler);
        channel.pipeline().addLast("SSL_handshakeHandler", (ChannelHandler)new SslHandshakeListenerEventHandler(tcpListenerHandler));
    }

    public static void send(byte[] bytes, Channel channel, CompletableFuture<Object> callback, TcpService tcpService) {
        if (!tcpService.getIsCallerClosed() && channel.isActive()) {
            WriteFlowController writeFlowController = new WriteFlowController(Unpooled.wrappedBuffer((byte[])bytes), callback, new AtomicBoolean(false));
            TcpListenerHandler tcpListenerHandler = (TcpListenerHandler)channel.pipeline().get("listenerHandler");
            tcpListenerHandler.addWriteFlowControl(writeFlowController);
            if (channel.isWritable()) {
                writeFlowController.writeData(channel, tcpListenerHandler.getWriteFlowControllers());
            }
        } else {
            callback.complete((Object)Utils.createTcpError("Socket connection already closed."));
        }
    }

    public static void send(byte[] bytes, Channel channel, TcpService tcpService) {
        if (!tcpService.getIsCallerClosed() && channel.isActive()) {
            WriteFlowControllerService writeFlowController = new WriteFlowControllerService(Unpooled.wrappedBuffer((byte[])bytes), tcpService);
            TcpListenerHandler tcpListenerHandler = (TcpListenerHandler)channel.pipeline().get("listenerHandler");
            tcpListenerHandler.addWriteFlowControl(writeFlowController);
            if (channel.isWritable()) {
                ((WriteFlowController)writeFlowController).writeData(channel, tcpListenerHandler.getWriteFlowControllers());
            }
        } else {
            Dispatcher.invokeOnError(tcpService, "Socket connection already closed.");
        }
    }

    public static void pauseRead(Channel channel) {
        channel.config().setAutoRead(false);
    }

    public static void resumeRead(Channel channel) {
        channel.config().setAutoRead(true);
    }

    public static void close(Channel channel, CompletableFuture<Object> callback) {
        if (channel != null) {
            channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    callback.complete(null);
                } else {
                    callback.complete((Object)Utils.createTcpError("Failed to close the client connection"));
                }
            }));
        }
    }

    public void close(CompletableFuture<Object> callback) {
        if (this.channel != null) {
            this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    callback.complete(null);
                } else {
                    callback.complete((Object)Utils.createTcpError("Failed to gracefully shutdown the Listener."));
                }
            }));
        }
    }
}

