/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.diagnostics;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public enum DiagnosticWarningCode implements DiagnosticCode
{
    WARNING_SYNTAX_WARNING("BCE10000", "warning.syntax.warning"),
    WARNING_MISSING_HASH_TOKEN("BCE10001", "warning.missing.hash.token"),
    WARNING_MISSING_SINGLE_BACKTICK_TOKEN("BCE10002", "warning.missing.single.backtick.token"),
    WARNING_MISSING_DOUBLE_BACKTICK_TOKEN("BCE10003", "warning.missing.double.backtick.token"),
    WARNING_MISSING_TRIPLE_BACKTICK_TOKEN("BCE10004", "warning.missing.triple.backtick.token"),
    WARNING_MISSING_IDENTIFIER_TOKEN("BCE10005", "warning.missing.identifier.token"),
    WARNING_MISSING_OPEN_PAREN_TOKEN("BCE10006", "warning.missing.open.paren.token"),
    WARNING_MISSING_CLOSE_PAREN_TOKEN("BCE10007", "warning.missing.close.paren.token"),
    WARNING_MISSING_HYPHEN_TOKEN("BCE10008", "warning.missing.hyphen.token"),
    WARNING_MISSING_PARAMETER_NAME("BCE10009", "warning.missing.parameter.name"),
    WARNING_MISSING_CODE_REFERENCE("BCE10010", "warning.missing.code.reference"),
    WARNING_INVALID_BALLERINA_NAME_REFERENCE("BCE10100", "warning.invalid.ballerina.name.reference"),
    WARNING_CANNOT_HAVE_DOCUMENTATION_INLINE_WITH_A_CODE_REFERENCE_BLOCK("BCE10101", "warning.cannot.have.documentation.inline.with.a.code.reference.block"),
    WARNING_INVALID_ESCAPE_SEQUENCE("BCE10102", "warning.invalid.escape.sequence");

    final String diagnosticId;
    final String messageKey;

    private DiagnosticWarningCode(String diagnosticId, String messageKey) {
        this.diagnosticId = diagnosticId;
        this.messageKey = messageKey;
    }

    public DiagnosticSeverity severity() {
        return DiagnosticSeverity.WARNING;
    }

    public String diagnosticId() {
        return this.diagnosticId;
    }

    public String messageKey() {
        return this.messageKey;
    }

    public boolean equals(DiagnosticCode code) {
        return this.messageKey.equals(code.messageKey());
    }
}

