/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.KeywordMode;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractLexer {
    protected static final int INITIAL_TRIVIA_CAPACITY = 10;
    protected List<STNode> leadingTriviaList;
    private Collection<STNodeDiagnostic> diagnostics;
    protected CharReader reader;
    protected ParserMode mode;
    protected ArrayDeque<ParserMode> modeStack = new ArrayDeque();
    protected ArrayDeque<KeywordMode> keywordModes = new ArrayDeque();

    public AbstractLexer(CharReader charReader, ParserMode initialParserMode) {
        this(charReader, initialParserMode, new ArrayList<STNode>(10), new ArrayList<STNodeDiagnostic>());
    }

    public AbstractLexer(CharReader charReader, ParserMode initialParserMode, List<STNode> leadingTriviaList, Collection<STNodeDiagnostic> diagnostics) {
        this.reader = charReader;
        this.startMode(initialParserMode);
        this.startKeywordMode(KeywordMode.DEFAULT);
        this.leadingTriviaList = leadingTriviaList;
        this.diagnostics = diagnostics;
    }

    public abstract STToken nextToken();

    public void reset(int offset) {
        this.reader.reset(offset);
    }

    public void startMode(ParserMode mode) {
        this.mode = mode;
        this.modeStack.push(mode);
    }

    public void switchMode(ParserMode mode) {
        this.modeStack.pop();
        this.mode = mode;
        this.modeStack.push(mode);
    }

    public void endMode() {
        this.modeStack.pop();
        this.mode = this.modeStack.peek();
    }

    public void startKeywordMode(KeywordMode keywordMode) {
        this.keywordModes.push(keywordMode);
    }

    public void endKeywordMode() {
        this.keywordModes.pop();
    }

    private void resetDiagnosticList() {
        this.diagnostics = new ArrayList<STNodeDiagnostic>();
    }

    private boolean noDiagnostics() {
        return this.diagnostics.isEmpty();
    }

    private Collection<STNodeDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    protected STToken cloneWithDiagnostics(STToken toClone) {
        if (this.noDiagnostics()) {
            return toClone;
        }
        STToken cloned = SyntaxErrors.addSyntaxDiagnostics(toClone, this.getDiagnostics());
        this.resetDiagnosticList();
        return cloned;
    }

    protected void reportLexerError(DiagnosticCode diagnosticCode, Object ... args) {
        this.diagnostics.add(SyntaxErrors.createDiagnostic(diagnosticCode, args));
    }

    protected STNode getLeadingTrivia() {
        STNode trivia = STNodeFactory.createNodeList(this.leadingTriviaList);
        this.leadingTriviaList = new ArrayList<STNode>(10);
        return trivia;
    }

    protected static boolean isIdentifierFollowingChar(int c) {
        return AbstractLexer.isIdentifierInitialChar(c) || AbstractLexer.isDigit(c);
    }

    protected static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    protected static boolean isHexDigit(int c) {
        if (97 <= c && c <= 102) {
            return true;
        }
        if (65 <= c && c <= 70) {
            return true;
        }
        return AbstractLexer.isDigit(c);
    }

    protected static boolean isIdentifierInitialChar(int c) {
        if (65 <= c && c <= 90) {
            return true;
        }
        if (97 <= c && c <= 122) {
            return true;
        }
        if (c == 95) {
            return true;
        }
        return AbstractLexer.isUnicodeIdentifierChar(c);
    }

    protected static boolean isUnicodeIdentifierChar(int c) {
        if (0 <= c && c <= 127) {
            return false;
        }
        if (AbstractLexer.isUnicodePrivateUseChar(c) || AbstractLexer.isUnicodePatternWhiteSpaceChar(c)) {
            return false;
        }
        return Character.isUnicodeIdentifierPart(c);
    }

    protected static boolean isUnicodePrivateUseChar(int c) {
        return 57344 <= c && c <= 63743 || 983040 <= c && c <= 1048573 || 0x100000 <= c && c <= 1114109;
    }

    protected static boolean isUnicodePatternWhiteSpaceChar(int c) {
        return 8206 == c || 8207 == c || 8232 == c || 8233 == c;
    }

    protected void processNumericEscape() {
        this.reader.advance();
        this.processNumericEscapeWithoutBackslash();
    }

    protected void processNumericEscapeWithoutBackslash() {
        this.reader.advance(2);
        if (!AbstractLexer.isHexDigit(this.reader.peek())) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
            return;
        }
        this.reader.advance();
        while (AbstractLexer.isHexDigit(this.reader.peek())) {
            this.reader.advance();
        }
        if (this.reader.peek() != '}') {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
            return;
        }
        this.reader.advance();
    }
}

