/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractParserErrorHandler;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.ParserRuleContext;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeList;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.syntax.NodeListUtils;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public abstract class AbstractParser {
    protected final AbstractParserErrorHandler errorHandler;
    protected final AbstractTokenReader tokenReader;
    private final Deque<InvalidNodeInfo> invalidNodeInfoStack = new ArrayDeque<InvalidNodeInfo>(5);
    protected STToken insertedToken = null;

    public AbstractParser(AbstractTokenReader tokenReader, AbstractParserErrorHandler errorHandler) {
        this.tokenReader = tokenReader;
        this.errorHandler = errorHandler;
    }

    public AbstractParser(AbstractTokenReader tokenReader) {
        this.tokenReader = tokenReader;
        this.errorHandler = null;
    }

    public abstract STNode parse();

    protected STToken peek() {
        if (this.insertedToken != null) {
            return this.insertedToken;
        }
        return this.tokenReader.peek();
    }

    protected STToken peek(int k) {
        if (this.insertedToken == null) {
            return this.tokenReader.peek(k);
        }
        if (k == 1) {
            return this.insertedToken;
        }
        if (k > 0) {
            --k;
        }
        return this.tokenReader.peek(k);
    }

    protected STToken consume() {
        if (this.insertedToken != null) {
            STToken nextToken = this.insertedToken;
            this.insertedToken = null;
            return this.consumeWithInvalidNodes(nextToken);
        }
        if (this.invalidNodeInfoStack.isEmpty()) {
            return this.tokenReader.read();
        }
        return this.consumeWithInvalidNodes();
    }

    private STToken consumeWithInvalidNodes() {
        STToken token = this.tokenReader.read();
        return this.consumeWithInvalidNodes(token);
    }

    private STToken consumeWithInvalidNodes(STToken token) {
        while (!this.invalidNodeInfoStack.isEmpty()) {
            InvalidNodeInfo invalidNodeInfo = this.invalidNodeInfoStack.pop();
            token = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(token, invalidNodeInfo.node, invalidNodeInfo.diagnosticCode, invalidNodeInfo.args);
        }
        return token;
    }

    protected AbstractParserErrorHandler.Solution recover(STToken token, ParserRuleContext currentCtx, boolean isCompletion) {
        AbstractParserErrorHandler.Solution sol = this.errorHandler.recover(currentCtx, token, isCompletion |= token.kind == SyntaxKind.EOF_TOKEN);
        if (sol.action == AbstractParserErrorHandler.Action.REMOVE) {
            this.insertedToken = null;
            this.addInvalidTokenToNextToken(sol.removedToken);
        } else if (sol.action == AbstractParserErrorHandler.Action.INSERT) {
            this.insertedToken = (STToken)sol.recoveredNode;
        }
        return sol;
    }

    protected void insertToken(SyntaxKind kind, ParserRuleContext context) {
        this.insertedToken = SyntaxErrors.createMissingTokenWithDiagnostics(kind, context);
    }

    protected void removeInsertedToken() {
        this.insertedToken = null;
    }

    protected boolean isInvalidNodeStackEmpty() {
        return this.invalidNodeInfoStack.isEmpty();
    }

    protected void startContext(ParserRuleContext context) {
        this.errorHandler.startContext(context);
    }

    protected void endContext() {
        this.errorHandler.endContext();
    }

    protected ParserRuleContext getCurrentContext() {
        return this.errorHandler.getParentContext();
    }

    protected void switchContext(ParserRuleContext context) {
        this.errorHandler.switchContext(context);
    }

    protected STToken getNextNextToken() {
        return this.peek(2);
    }

    protected boolean isNodeListEmpty(STNode node) {
        if (!NodeListUtils.isSTNodeList(node)) {
            throw new IllegalArgumentException("The 'node' should be an instance of STNodeList");
        }
        STNodeList nodeList = (STNodeList)node;
        return nodeList.isEmpty();
    }

    protected STNode cloneWithDiagnosticIfListEmpty(STNode nodeList, STNode target, DiagnosticCode diagnosticCode) {
        if (this.isNodeListEmpty(nodeList)) {
            return SyntaxErrors.addDiagnostic(target, diagnosticCode, new Object[0]);
        }
        return target;
    }

    protected void updateLastNodeInListWithInvalidNode(List<STNode> nodeList, STNode invalidParam, DiagnosticCode diagnosticCode, Object ... args) {
        int lastIndex = nodeList.size() - 1;
        STNode prevNode = nodeList.remove(lastIndex);
        STNode newNode = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(prevNode, invalidParam, diagnosticCode, args);
        nodeList.add(newNode);
    }

    protected void updateFirstNodeInListWithLeadingInvalidNode(List<STNode> nodeList, STNode invalidParam, DiagnosticCode diagnosticCode, Object ... args) {
        this.updateANodeInListWithLeadingInvalidNode(nodeList, 0, invalidParam, diagnosticCode, args);
    }

    protected void updateANodeInListWithLeadingInvalidNode(List<STNode> nodeList, int indexOfTheNode, STNode invalidParam, DiagnosticCode diagnosticCode, Object ... args) {
        STNode node = nodeList.get(indexOfTheNode);
        STNode newNode = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(node, invalidParam, diagnosticCode, args);
        nodeList.set(indexOfTheNode, newNode);
    }

    protected STNode invalidateRestAndAddToTrailingMinutiae(STNode node) {
        node = this.addInvalidNodeStackToTrailingMinutiae(node);
        while (this.peek().kind != SyntaxKind.EOF_TOKEN) {
            STToken invalidToken = this.consume();
            node = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(node, (STNode)invalidToken, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_TOKEN, invalidToken.text());
        }
        return node;
    }

    protected STNode addInvalidNodeStackToTrailingMinutiae(STNode node) {
        while (!this.invalidNodeInfoStack.isEmpty()) {
            InvalidNodeInfo invalidNodeInfo = this.invalidNodeInfoStack.pop();
            node = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(node, invalidNodeInfo.node, invalidNodeInfo.diagnosticCode, invalidNodeInfo.args);
        }
        return node;
    }

    protected void addInvalidNodeToNextToken(STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args) {
        this.invalidNodeInfoStack.push(new InvalidNodeInfo(invalidNode, diagnosticCode, args));
    }

    protected void addInvalidTokenToNextToken(STToken invalidNode) {
        this.invalidNodeInfoStack.push(new InvalidNodeInfo(invalidNode, DiagnosticErrorCode.ERROR_INVALID_TOKEN, invalidNode.text()));
    }

    private static class InvalidNodeInfo {
        final STNode node;
        final DiagnosticCode diagnosticCode;
        final Object[] args;

        public InvalidNodeInfo(STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args) {
            this.node = invalidNode;
            this.diagnosticCode = diagnosticCode;
            this.args = args;
        }
    }
}

