/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.ParserRuleContext;
import io.ballerina.compiler.internal.parser.Result;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParserErrorHandler {
    protected final AbstractTokenReader tokenReader;
    private ArrayDeque<ParserRuleContext> ctxStack = new ArrayDeque();
    private int previousTokenIndex;
    private int itterCount;
    protected static final int LOOKAHEAD_LIMIT = 4;
    private static final int RESOLUTION_ITTER_LIMIT = 7;
    private static final int COMPLETION_ITTER_LIMIT = 15;

    public AbstractParserErrorHandler(AbstractTokenReader tokenReader) {
        this.tokenReader = tokenReader;
        this.previousTokenIndex = -1;
        this.itterCount = 0;
    }

    protected abstract boolean hasAlternativePaths(ParserRuleContext var1);

    protected abstract Result seekMatch(ParserRuleContext var1, int var2, int var3, boolean var4);

    protected abstract ParserRuleContext getNextRule(ParserRuleContext var1, int var2);

    protected abstract SyntaxKind getExpectedTokenKind(ParserRuleContext var1);

    protected abstract Solution getInsertSolution(ParserRuleContext var1);

    public Solution recover(ParserRuleContext currentCtx, STToken nextToken, boolean isCompletion) {
        int currentTokenIndex = this.tokenReader.getCurrentTokenIndex();
        if (currentTokenIndex == this.previousTokenIndex) {
            ++this.itterCount;
        } else {
            this.itterCount = 0;
            this.previousTokenIndex = currentTokenIndex;
        }
        Solution fix = null;
        if (isCompletion && this.itterCount < 15) {
            fix = this.getCompletion(currentCtx, nextToken);
        } else if (this.itterCount < 7) {
            fix = this.getResolution(currentCtx, nextToken);
        }
        if (fix != null) {
            this.applyFix(currentCtx, fix);
            return fix;
        }
        assert (!isCompletion ? this.itterCount != 7 : this.itterCount != 15) : "fail safe reached";
        return this.getFailSafeSolution(currentCtx, nextToken);
    }

    private Solution getResolution(ParserRuleContext currentCtx, STToken nextToken) {
        Result bestMatch = this.seekMatch(currentCtx);
        this.validateSolution(bestMatch, currentCtx, nextToken);
        Solution sol = null;
        if (bestMatch.matches > 0) {
            sol = bestMatch.solution;
        }
        return sol;
    }

    private Solution getFailSafeSolution(ParserRuleContext currentCtx, STToken nextToken) {
        Solution sol = new Solution(Action.REMOVE, currentCtx, nextToken.kind, nextToken.toString());
        sol.removedToken = this.consumeInvalidToken();
        return sol;
    }

    private void validateSolution(Result bestMatch, ParserRuleContext currentCtx, STNode nextToken) {
        Solution sol = bestMatch.solution;
        if (sol == null || sol.action == Action.REMOVE) {
            return;
        }
        if (sol.action == Action.KEEP && nextToken.kind == SyntaxKind.DOCUMENTATION_STRING) {
            bestMatch.solution = new Solution(Action.REMOVE, currentCtx, SyntaxKind.DOCUMENTATION_STRING, currentCtx.toString());
        }
        if (sol.action != Action.INSERT || bestMatch.fixesSize() < 2) {
            return;
        }
        Solution firstFix = bestMatch.popFix();
        Solution secondFix = bestMatch.peekFix();
        bestMatch.pushFix(firstFix);
        if (secondFix.action == Action.REMOVE && secondFix.depth == 1) {
            bestMatch.solution = secondFix;
        }
    }

    private Solution getCompletion(ParserRuleContext context, STToken nextToken) {
        Solution sol;
        ArrayDeque<ParserRuleContext> tempCtxStack = this.ctxStack;
        this.ctxStack = this.getCtxStackSnapshot();
        try {
            sol = this.getInsertSolution(context);
        }
        catch (IllegalStateException exception) {
            assert (false) : "Oh no, something went bad with parser error handler: \ngetCompletion caught " + String.valueOf(exception);
            sol = this.getResolution(context, nextToken);
        }
        this.ctxStack = tempCtxStack;
        return sol;
    }

    public STToken consumeInvalidToken() {
        return this.tokenReader.read();
    }

    private void applyFix(ParserRuleContext currentCtx, Solution fix) {
        if (fix.action == Action.REMOVE) {
            fix.removedToken = this.consumeInvalidToken();
            fix.recoveredNode = this.tokenReader.peek();
            fix.tokenKind = this.tokenReader.peek().kind;
        } else if (fix.action == Action.INSERT) {
            fix.recoveredNode = this.handleMissingToken(currentCtx, fix);
        }
    }

    private STNode handleMissingToken(ParserRuleContext currentCtx, Solution fix) {
        return SyntaxErrors.createMissingTokenWithDiagnostics(fix.tokenKind, fix.ctx);
    }

    private ArrayDeque<ParserRuleContext> getCtxStackSnapshot() {
        return this.ctxStack.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result seekMatch(ParserRuleContext currentCtx) {
        Result bestMatch;
        ArrayDeque<ParserRuleContext> tempCtxStack = this.ctxStack;
        try {
            bestMatch = this.seekMatchInSubTree(currentCtx, 1, 0, true);
        }
        catch (IllegalStateException exception) {
            assert (false) : "Oh no, something went bad with parser error handler: \nseekMatch caught " + String.valueOf(exception);
            bestMatch = new Result(new ArrayDeque<Solution>(), 3);
            bestMatch.solution = new Solution(Action.REMOVE, currentCtx, SyntaxKind.NONE, currentCtx.toString());
        }
        finally {
            this.ctxStack = tempCtxStack;
        }
        return bestMatch;
    }

    protected Result seekMatchInSubTree(ParserRuleContext currentCtx, int lookahead, int currentDepth, boolean isEntryPoint) {
        ArrayDeque<ParserRuleContext> tempCtxStack = this.ctxStack;
        this.ctxStack = this.getCtxStackSnapshot();
        Result result = this.seekMatch(currentCtx, lookahead, currentDepth, isEntryPoint);
        this.ctxStack = tempCtxStack;
        return result;
    }

    public void startContext(ParserRuleContext context) {
        this.ctxStack.push(context);
    }

    public void endContext() {
        this.ctxStack.pop();
    }

    public void switchContext(ParserRuleContext context) {
        this.ctxStack.pop();
        this.ctxStack.push(context);
    }

    protected ParserRuleContext getParentContext() {
        return this.ctxStack.peek();
    }

    protected ParserRuleContext getGrandParentContext() {
        ParserRuleContext parent = this.ctxStack.pop();
        ParserRuleContext grandParent = this.ctxStack.peek();
        this.ctxStack.push(parent);
        return grandParent;
    }

    protected boolean hasAncestorContext(ParserRuleContext context) {
        return this.ctxStack.contains((Object)context);
    }

    protected ArrayDeque<ParserRuleContext> getContextStack() {
        return this.ctxStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result seekInAlternativesPaths(int lookahead, int currentDepth, int currentMatches, ParserRuleContext[] alternativeRules, boolean isEntryPoint) {
        List[] results = new List[4];
        int bestMatchIndex = 0;
        for (ParserRuleContext rule : alternativeRules) {
            Result result;
            ArrayDeque<ParserRuleContext> tempCtxStack = this.ctxStack;
            try {
                result = this.seekMatchInSubTree(rule, lookahead, currentDepth, isEntryPoint);
            }
            catch (IllegalStateException exception) {
                assert (false) : "Oh no, something went bad with parser error handler: \nseekInAlternativesPaths caught " + String.valueOf(exception);
                continue;
            }
            finally {
                this.ctxStack = tempCtxStack;
            }
            if (this.hasFoundBestAlternative(result)) {
                return this.getFinalResult(currentMatches, result);
            }
            ArrayList<Result> similarResutls = results[result.matches];
            if (similarResutls == null) {
                results[result.matches] = similarResutls = new ArrayList<Result>(4);
                if (bestMatchIndex < result.matches) {
                    bestMatchIndex = result.matches;
                }
            }
            similarResutls.add(result);
        }
        List bestMatches = results[bestMatchIndex];
        Result bestMatch = (Result)bestMatches.get(0);
        for (int i = 1; i < bestMatches.size(); ++i) {
            Result currentMatch = (Result)bestMatches.get(i);
            int currentMatchRemoveFixes = currentMatch.removeFixes;
            int bestMatchRemoveFixes = bestMatch.removeFixes;
            if (bestMatchRemoveFixes == 0) break;
            if (currentMatchRemoveFixes == bestMatchRemoveFixes) {
                Solution currentSol = bestMatch.peekFix();
                Solution foundSol = currentMatch.peekFix();
                if (currentSol.action != Action.REMOVE || foundSol.action != Action.INSERT) continue;
                bestMatch = currentMatch;
                continue;
            }
            if (currentMatchRemoveFixes >= bestMatchRemoveFixes) continue;
            bestMatch = currentMatch;
        }
        return this.getFinalResult(currentMatches, bestMatch);
    }

    private boolean hasFoundBestAlternative(Result result) {
        if (result.matches < 3) {
            return false;
        }
        if (result.solution == null) {
            return true;
        }
        return result.solution.action != Action.REMOVE;
    }

    protected Result getFinalResult(int currentMatches, Result bestMatch) {
        bestMatch.matches += currentMatches;
        return bestMatch;
    }

    protected Result fixAndContinue(ParserRuleContext currentCtx, int lookahead, int currentDepth, int matchingRulesCount, boolean isEntryPoint) {
        Result fixedPathResult = this.fixAndContinue(currentCtx, lookahead, currentDepth);
        fixedPathResult.solution = isEntryPoint ? fixedPathResult.peekFix() : new Solution(Action.KEEP, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString());
        return this.getFinalResult(matchingRulesCount, fixedPathResult);
    }

    protected Result fixAndContinue(ParserRuleContext currentCtx, int lookahead, int currentDepth) {
        Result fixedPathResult;
        Result deletionResult = this.seekMatchInSubTree(currentCtx, lookahead + 1, currentDepth + 1, false);
        ParserRuleContext nextCtx = this.getNextRule(currentCtx, lookahead);
        Result insertionResult = this.seekMatchInSubTree(nextCtx, lookahead, currentDepth + 1, false);
        if (insertionResult.matches == 0 && deletionResult.matches == 0) {
            Solution action = new Solution(Action.INSERT, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString(), currentDepth);
            insertionResult.pushFix(action);
            fixedPathResult = insertionResult;
        } else if (insertionResult.matches == deletionResult.matches) {
            if (insertionResult.removeFixes <= deletionResult.removeFixes + 1) {
                Solution action = new Solution(Action.INSERT, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString(), currentDepth);
                insertionResult.pushFix(action);
                fixedPathResult = insertionResult;
            } else {
                STToken token = this.tokenReader.peek(lookahead);
                Solution action = new Solution(Action.REMOVE, currentCtx, token.kind, token.toString(), currentDepth);
                deletionResult.pushFix(action);
                fixedPathResult = deletionResult;
            }
        } else if (insertionResult.matches > deletionResult.matches) {
            Solution action = new Solution(Action.INSERT, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString(), currentDepth);
            insertionResult.pushFix(action);
            fixedPathResult = insertionResult;
        } else {
            STToken token = this.tokenReader.peek(lookahead);
            Solution action = new Solution(Action.REMOVE, currentCtx, token.kind, token.toString(), currentDepth);
            deletionResult.pushFix(action);
            fixedPathResult = deletionResult;
        }
        return fixedPathResult;
    }

    public static class Solution {
        public ParserRuleContext ctx;
        public Action action;
        public String tokenText;
        public SyntaxKind tokenKind;
        public STNode recoveredNode;
        public STToken removedToken;
        public int depth;

        public Solution(Action action, ParserRuleContext ctx, SyntaxKind tokenKind, String tokenText) {
            this(action, ctx, tokenKind, tokenText, -1);
        }

        public Solution(Action action, ParserRuleContext ctx, SyntaxKind tokenKind, String tokenText, int depth) {
            this.action = action;
            this.ctx = ctx;
            this.tokenText = tokenText;
            this.tokenKind = tokenKind;
            this.depth = depth;
        }

        public String toString() {
            return this.action.toString() + "'" + this.tokenText + "'";
        }
    }

    protected static enum Action {
        INSERT,
        REMOVE,
        KEEP;

    }
}

