/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractLexer;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.XMLValidator;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;
import java.util.List;

public class XMLLexer
extends AbstractLexer {
    public XMLLexer(CharReader charReader) {
        super(charReader, ParserMode.XML_CONTENT);
    }

    @Override
    public STToken nextToken() {
        STToken token = switch (this.mode) {
            case ParserMode.XML_CONTENT -> this.readTokenInXMLContent();
            case ParserMode.XML_ELEMENT_START_TAG -> {
                this.processLeadingXMLTrivia();
                yield this.readTokenInXMLElement(true);
            }
            case ParserMode.XML_ELEMENT_END_TAG -> {
                this.processLeadingXMLTrivia();
                yield this.readTokenInXMLElement(false);
            }
            case ParserMode.XML_TEXT -> this.readTokenInXMLText();
            case ParserMode.INTERPOLATION -> this.readTokenInInterpolation();
            case ParserMode.XML_ATTRIBUTES -> {
                this.processLeadingXMLTrivia();
                yield this.readTokenInXMLAttributes(true);
            }
            case ParserMode.XML_COMMENT -> this.readTokenInXMLCommentOrCDATA(false);
            case ParserMode.XML_PI -> {
                this.processLeadingXMLTrivia();
                yield this.readTokenInXMLPI();
            }
            case ParserMode.XML_PI_DATA -> {
                this.processLeadingXMLTrivia();
                yield this.readTokenInXMLPIData();
            }
            case ParserMode.XML_SINGLE_QUOTED_STRING -> this.processXMLSingleQuotedString();
            case ParserMode.XML_DOUBLE_QUOTED_STRING -> this.processXMLDoubleQuotedString();
            case ParserMode.XML_CDATA_SECTION -> this.readTokenInXMLCommentOrCDATA(true);
            default -> null;
        };
        return this.cloneWithDiagnostics(token);
    }

    private STNode processWhitespaces() {
        block4: while (!this.reader.isEOF()) {
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    this.reader.advance();
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
    }

    private STNode processEndOfLine() {
        char c = this.reader.peek();
        switch (c) {
            case '\n': {
                this.reader.advance();
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
            case '\r': {
                this.reader.advance();
                if (this.reader.peek() == '\n') {
                    this.reader.advance();
                }
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
        }
        throw new IllegalStateException();
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    private STToken readTokenInInterpolation() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextToken = this.peek();
        switch (nextToken) {
            case 125: {
                this.endMode();
                this.reader.advance();
                return this.getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind.CLOSE_BRACE_TOKEN);
            }
        }
        this.endMode();
        return this.nextToken();
    }

    private void processLeadingXMLTrivia() {
        this.processXMLTrivia(this.leadingTriviaList, true);
    }

    private STNode processTrailingXMLTrivia() {
        ArrayList<STNode> triviaList = new ArrayList<STNode>(10);
        this.processXMLTrivia(triviaList, false);
        return STNodeFactory.createNodeList(triviaList);
    }

    private void processXMLTrivia(List<STNode> triviaList, boolean isLeading) {
        while (!this.reader.isEOF()) {
            this.reader.mark();
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case ' ': {
                    triviaList.add(this.processWhitespaces());
                    break;
                }
                case '\n': 
                case '\r': {
                    triviaList.add(this.processEndOfLine());
                    if (isLeading) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private STToken getXMLSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = this.processTrailingXMLTrivia();
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getXMLSyntaxToken(SyntaxKind kind, boolean allowLeadingWS, boolean allowTrailingWS) {
        STNode leadingTrivia = this.getLeadingTrivia();
        if (!allowLeadingWS && leadingTrivia.bucketCount() != 0) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_WHITESPACE_BEFORE, kind.stringValue());
        }
        STNode trailingTrivia = this.processTrailingXMLTrivia();
        if (!allowTrailingWS && trailingTrivia.bucketCount() != 0) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_WHITESPACE_AFTER, kind.stringValue());
        }
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STNodeFactory.createNodeList(new ArrayList<STNode>(0));
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getLiteral(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingXMLTrivia();
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken readTokenInXMLContent() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        switch (nextChar) {
            case '`': {
                this.endMode();
                return this.nextToken();
            }
            case '<': {
                this.reader.advance();
                nextChar = this.reader.peek();
                switch (nextChar) {
                    case '!': {
                        if (this.reader.peek(1) == '-' && this.reader.peek(2) == '-') {
                            this.reader.advance(3);
                            this.startMode(ParserMode.XML_COMMENT);
                            return this.getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind.XML_COMMENT_START_TOKEN);
                        }
                        if (!this.isCDATAStart()) break;
                        this.reader.advance(8);
                        this.startMode(ParserMode.XML_CDATA_SECTION);
                        return this.getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind.XML_CDATA_START_TOKEN);
                    }
                    case '?': {
                        this.reader.advance();
                        this.startMode(ParserMode.XML_PI);
                        return this.getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind.XML_PI_START_TOKEN);
                    }
                    case '/': {
                        this.startMode(ParserMode.XML_ELEMENT_END_TAG);
                        return this.getXMLSyntaxToken(SyntaxKind.LT_TOKEN, false, false);
                    }
                }
                this.startMode(ParserMode.XML_ELEMENT_START_TAG);
                return this.getXMLSyntaxToken(SyntaxKind.LT_TOKEN, false, false);
            }
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.startMode(ParserMode.INTERPOLATION);
                this.reader.advance(2);
                return this.getXMLSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
        }
        this.startMode(ParserMode.XML_TEXT);
        return this.readTokenInXMLText();
    }

    private boolean isCDATAStart() {
        return this.reader.peek(1) == '[' && this.reader.peek(2) == 'C' && this.reader.peek(3) == 'D' && this.reader.peek(4) == 'A' && this.reader.peek(5) == 'T' && this.reader.peek(6) == 'A' && this.reader.peek(7) == '[';
    }

    private STToken readTokenInXMLElement(boolean isStartTag) {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char c = this.reader.peek();
        switch (c) {
            case '<': {
                if (isStartTag) {
                    this.startMode(ParserMode.XML_CONTENT);
                } else {
                    this.endMode();
                }
                return this.nextToken();
            }
            case '>': {
                this.endMode();
                if (isStartTag) {
                    this.startMode(ParserMode.XML_CONTENT);
                }
                this.reader.advance();
                return this.getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind.GT_TOKEN);
            }
            case '/': {
                this.reader.advance();
                return this.getXMLSyntaxToken(SyntaxKind.SLASH_TOKEN, isStartTag, false);
            }
            case ':': {
                this.reader.advance();
                return this.getXMLSyntaxToken(SyntaxKind.COLON_TOKEN, false, false);
            }
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.reader.advance(2);
                this.startMode(ParserMode.INTERPOLATION);
                return this.getXMLSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
            case '`': {
                this.endMode();
                return this.nextToken();
            }
        }
        this.reader.advance();
        STToken tagName = this.processXMLName(c, false);
        this.startMode(ParserMode.XML_ATTRIBUTES);
        return tagName;
    }

    private STToken processXMLName(int startChar, boolean allowLeadingWS) {
        boolean isValid = true;
        if (!XMLValidator.isNCNameStart(startChar)) {
            isValid = false;
        }
        while (!this.reader.isEOF() && XMLValidator.isNCName(this.peek())) {
            this.reader.advance();
        }
        String text = this.getLexeme();
        if (!isValid) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_XML_NAME, text);
        }
        return this.getXMLNameToken(text, allowLeadingWS);
    }

    private STToken getXMLNameToken(String tokenText, boolean allowLeadingWS) {
        STNode leadingTrivia = this.getLeadingTrivia();
        if (!allowLeadingWS && leadingTrivia.bucketCount() != 0) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_WHITESPACE_BEFORE, tokenText);
        }
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingXMLTrivia();
        return STNodeFactory.createIdentifierToken(lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken readTokenInXMLAttributes(boolean isStartTag) {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        switch (nextChar) {
            case '/': 
            case '<': 
            case '>': 
            case '`': {
                this.endMode();
                return this.readTokenInXMLElement(isStartTag);
            }
            case ':': {
                this.reader.advance();
                return this.getXMLSyntaxToken(SyntaxKind.COLON_TOKEN, false, false);
            }
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.reader.advance(2);
                this.startMode(ParserMode.INTERPOLATION);
                return this.getXMLSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
            case '=': {
                this.reader.advance();
                return this.getXMLSyntaxToken(SyntaxKind.EQUAL_TOKEN, true, true);
            }
            case '\"': {
                this.reader.advance();
                this.startMode(ParserMode.XML_DOUBLE_QUOTED_STRING);
                return this.getXMLSyntaxToken(SyntaxKind.DOUBLE_QUOTE_TOKEN, false, false);
            }
            case '\'': {
                this.reader.advance();
                this.startMode(ParserMode.XML_SINGLE_QUOTED_STRING);
                return this.getXMLSyntaxToken(SyntaxKind.SINGLE_QUOTE_TOKEN, false, false);
            }
        }
        this.reader.advance();
        STToken attributeName = this.processXMLName(nextChar, true);
        return attributeName;
    }

    private STToken processXMLDoubleQuotedString() {
        return this.processXMLQuotedString(34, SyntaxKind.DOUBLE_QUOTE_TOKEN);
    }

    private STToken processXMLSingleQuotedString() {
        return this.processXMLQuotedString(39, SyntaxKind.SINGLE_QUOTE_TOKEN);
    }

    private STToken processXMLQuotedString(int startingQuote, SyntaxKind startQuoteKind) {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        switch (nextChar) {
            case 34: 
            case 39: {
                if (nextChar != startingQuote) break;
                this.reader.advance();
                this.endMode();
                return this.getXMLSyntaxToken(startQuoteKind, false, true);
            }
            case 36: {
                if (this.reader.peek(1) != '{') break;
                this.reader.advance(2);
                this.startMode(ParserMode.INTERPOLATION);
                return this.getXMLSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
        }
        block10: while (!this.reader.isEOF()) {
            nextChar = this.peek();
            switch (nextChar) {
                case 34: 
                case 39: {
                    if (nextChar == startingQuote) break block10;
                    this.reader.advance();
                    continue block10;
                }
                case 38: {
                    this.processXMLReferenceInQuotedString(startingQuote);
                    continue block10;
                }
                case 60: {
                    this.reader.advance();
                    this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_CHARACTER_IN_XML_ATTRIBUTE_VALUE, Character.valueOf('<'));
                    continue block10;
                }
                case 36: {
                    if (this.reader.peek(1) == '{') break block10;
                }
                default: {
                    this.reader.advance();
                    continue block10;
                }
            }
        }
        return this.getLiteral(SyntaxKind.XML_TEXT_CONTENT);
    }

    private void processXMLReferenceInQuotedString(int startingQuote) {
        int nextChar = this.peek();
        switch (nextChar) {
            case 34: 
            case 39: {
                if (nextChar == startingQuote) break;
            }
            default: {
                this.processXMLReference();
            }
        }
    }

    private void processXMLReference() {
        this.reader.advance();
        int nextChar = this.peek();
        switch (nextChar) {
            case 59: {
                this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_ENTITY_REFERENCE_NAME, new Object[0]);
                this.reader.advance();
                return;
            }
            case 35: {
                this.processXMLCharRef();
                break;
            }
            default: {
                this.processXMLEntityRef();
            }
        }
        if (this.peek() == 59) {
            this.reader.advance();
        } else {
            this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_SEMICOLON_IN_XML_REFERENCE, new Object[0]);
        }
    }

    private void processXMLCharRef() {
        this.reader.advance();
        int nextChar = this.peek();
        if (nextChar == 120) {
            this.reader.advance();
            this.processHexDigits();
        } else {
            this.processDigits();
        }
    }

    private void processHexDigits() {
        while (XMLLexer.isHexDigit(this.peek())) {
            this.reader.advance();
        }
    }

    private void processDigits() {
        while (XMLLexer.isDigit(this.peek())) {
            this.reader.advance();
        }
    }

    private void processXMLEntityRef() {
        if (!XMLValidator.isNCNameStart(this.peek())) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ENTITY_REFERENCE_NAME_START, new Object[0]);
        } else {
            this.reader.advance();
        }
        while (!this.reader.isEOF() && XMLValidator.isNCName(this.peek())) {
            this.reader.advance();
        }
    }

    private STToken readTokenInXMLText() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        block6: while (!this.reader.isEOF()) {
            char nextChar = this.reader.peek();
            switch (nextChar) {
                case '<': {
                    break block6;
                }
                case '$': {
                    if (this.reader.peek(1) == '{') break block6;
                    this.reader.advance();
                    continue block6;
                }
                case '&': {
                    this.processXMLReference();
                    continue block6;
                }
                case '`': {
                    break block6;
                }
                default: {
                    this.reader.advance();
                    continue block6;
                }
            }
        }
        this.endMode();
        return this.getXMLText(SyntaxKind.XML_TEXT_CONTENT);
    }

    private STToken getXMLText(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingXMLTrivia();
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken readTokenInXMLCommentOrCDATA(boolean isCdata) {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        switch (this.reader.peek()) {
            case '-': {
                if (isCdata || this.reader.peek(1) != '-') break;
                if (this.reader.peek(2) == '>') {
                    this.reader.advance(3);
                    this.endMode();
                    return this.getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind.XML_COMMENT_END_TOKEN);
                }
                this.reader.advance(1);
                this.reportLexerError(DiagnosticErrorCode.ERROR_DOUBLE_HYPHEN_NOT_ALLOWED_WITHIN_XML_COMMENT, new Object[0]);
                break;
            }
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.reader.advance(2);
                this.startMode(ParserMode.INTERPOLATION);
                return this.getXMLSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
            case ']': {
                if (!isCdata || this.reader.peek(1) != ']' || this.reader.peek(2) != '>') break;
                this.reader.advance(3);
                this.endMode();
                return this.getXMLSyntaxTokenWithoutTrailingWS(SyntaxKind.XML_CDATA_END_TOKEN);
            }
        }
        block11: while (!this.reader.isEOF()) {
            switch (this.reader.peek()) {
                case '-': {
                    if (!isCdata && this.reader.peek(1) == '-') {
                        if (this.reader.peek(2) == '>') break block11;
                        this.reader.advance(2);
                        this.reportLexerError(DiagnosticErrorCode.ERROR_DOUBLE_HYPHEN_NOT_ALLOWED_WITHIN_XML_COMMENT, new Object[0]);
                        continue block11;
                    }
                    this.reader.advance();
                    continue block11;
                }
                case '$': {
                    if (this.reader.peek(1) == '{') break block11;
                    this.reader.advance();
                    continue block11;
                }
                case '`': {
                    this.endMode();
                    break block11;
                }
                case ']': {
                    if (isCdata && this.reader.peek(1) == ']' && this.reader.peek(2) == '>') break block11;
                    this.reader.advance();
                    continue block11;
                }
                default: {
                    this.reader.advance();
                    continue block11;
                }
            }
        }
        return this.getXMLText(SyntaxKind.XML_TEXT_CONTENT);
    }

    private STToken readTokenInXMLPI() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        switch (nextChar) {
            case '?': {
                if (this.reader.peek(1) != '>') break;
                this.reader.advance(2);
                this.endMode();
                return this.getXMLSyntaxToken(SyntaxKind.XML_PI_END_TOKEN);
            }
            case '`': {
                this.endMode();
                return this.nextToken();
            }
        }
        this.reader.advance();
        STToken tagName = this.processXMLName(nextChar, false);
        this.startMode(ParserMode.XML_PI_DATA);
        return tagName;
    }

    private STToken readTokenInXMLPIData() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getXMLSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        switch (this.reader.peek()) {
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.reader.advance(2);
                this.startMode(ParserMode.INTERPOLATION);
                return this.getXMLSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
            case '?': {
                if (this.reader.peek(1) != '>') break;
                this.reader.advance(2);
                this.endMode();
                this.endMode();
                return this.getXMLSyntaxToken(SyntaxKind.XML_PI_END_TOKEN);
            }
        }
        block9: while (!this.reader.isEOF()) {
            switch (this.reader.peek()) {
                case '?': {
                    if (this.reader.peek(1) == '>') break block9;
                    this.reader.advance();
                    continue block9;
                }
                case '$': {
                    if (this.reader.peek(1) == '{') break block9;
                }
                case '`': {
                    this.endMode();
                    break block9;
                }
                default: {
                    this.reader.advance();
                    continue block9;
                }
            }
        }
        return this.getXMLText(SyntaxKind.XML_TEXT_CONTENT);
    }
}

