/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STListConstructorExpressionNode
extends STExpressionNode {
    public final STNode openBracket;
    public final STNode expressions;
    public final STNode closeBracket;

    STListConstructorExpressionNode(STNode openBracket, STNode expressions, STNode closeBracket) {
        this(openBracket, expressions, closeBracket, Collections.emptyList());
    }

    STListConstructorExpressionNode(STNode openBracket, STNode expressions, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LIST_CONSTRUCTOR, diagnostics);
        this.openBracket = openBracket;
        this.expressions = expressions;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, expressions, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STListConstructorExpressionNode(this.openBracket, this.expressions, this.closeBracket, diagnostics);
    }

    public STListConstructorExpressionNode modify(STNode openBracket, STNode expressions, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, expressions, closeBracket)) {
            return this;
        }
        return new STListConstructorExpressionNode(openBracket, expressions, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ListConstructorExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

