/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STActionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QueryActionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STQueryActionNode
extends STActionNode {
    public final STNode queryPipeline;
    public final STNode doKeyword;
    public final STNode blockStatement;

    STQueryActionNode(STNode queryPipeline, STNode doKeyword, STNode blockStatement) {
        this(queryPipeline, doKeyword, blockStatement, Collections.emptyList());
    }

    STQueryActionNode(STNode queryPipeline, STNode doKeyword, STNode blockStatement, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.QUERY_ACTION, diagnostics);
        this.queryPipeline = queryPipeline;
        this.doKeyword = doKeyword;
        this.blockStatement = blockStatement;
        this.addChildren(queryPipeline, doKeyword, blockStatement);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STQueryActionNode(this.queryPipeline, this.doKeyword, this.blockStatement, diagnostics);
    }

    public STQueryActionNode modify(STNode queryPipeline, STNode doKeyword, STNode blockStatement) {
        if (this.checkForReferenceEquality(queryPipeline, doKeyword, blockStatement)) {
            return this;
        }
        return new STQueryActionNode(queryPipeline, doKeyword, blockStatement, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new QueryActionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

