/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRecordFieldWithDefaultValueNode
extends STNode {
    public final STNode metadata;
    public final STNode readonlyKeyword;
    public final STNode typeName;
    public final STNode fieldName;
    public final STNode equalsToken;
    public final STNode expression;
    public final STNode semicolonToken;

    STRecordFieldWithDefaultValueNode(STNode metadata, STNode readonlyKeyword, STNode typeName, STNode fieldName, STNode equalsToken, STNode expression, STNode semicolonToken) {
        this(metadata, readonlyKeyword, typeName, fieldName, equalsToken, expression, semicolonToken, Collections.emptyList());
    }

    STRecordFieldWithDefaultValueNode(STNode metadata, STNode readonlyKeyword, STNode typeName, STNode fieldName, STNode equalsToken, STNode expression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RECORD_FIELD_WITH_DEFAULT_VALUE, diagnostics);
        this.metadata = metadata;
        this.readonlyKeyword = readonlyKeyword;
        this.typeName = typeName;
        this.fieldName = fieldName;
        this.equalsToken = equalsToken;
        this.expression = expression;
        this.semicolonToken = semicolonToken;
        this.addChildren(metadata, readonlyKeyword, typeName, fieldName, equalsToken, expression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRecordFieldWithDefaultValueNode(this.metadata, this.readonlyKeyword, this.typeName, this.fieldName, this.equalsToken, this.expression, this.semicolonToken, diagnostics);
    }

    public STRecordFieldWithDefaultValueNode modify(STNode metadata, STNode readonlyKeyword, STNode typeName, STNode fieldName, STNode equalsToken, STNode expression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(metadata, readonlyKeyword, typeName, fieldName, equalsToken, expression, semicolonToken)) {
            return this;
        }
        return new STRecordFieldWithDefaultValueNode(metadata, readonlyKeyword, typeName, fieldName, equalsToken, expression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RecordFieldWithDefaultValueNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

