/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RestMatchPatternNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRestMatchPatternNode
extends STNode {
    public final STNode ellipsisToken;
    public final STNode varKeywordToken;
    public final STNode variableName;

    STRestMatchPatternNode(STNode ellipsisToken, STNode varKeywordToken, STNode variableName) {
        this(ellipsisToken, varKeywordToken, variableName, Collections.emptyList());
    }

    STRestMatchPatternNode(STNode ellipsisToken, STNode varKeywordToken, STNode variableName, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.REST_MATCH_PATTERN, diagnostics);
        this.ellipsisToken = ellipsisToken;
        this.varKeywordToken = varKeywordToken;
        this.variableName = variableName;
        this.addChildren(ellipsisToken, varKeywordToken, variableName);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRestMatchPatternNode(this.ellipsisToken, this.varKeywordToken, this.variableName, diagnostics);
    }

    public STRestMatchPatternNode modify(STNode ellipsisToken, STNode varKeywordToken, STNode variableName) {
        if (this.checkForReferenceEquality(ellipsisToken, varKeywordToken, variableName)) {
            return this;
        }
        return new STRestMatchPatternNode(ellipsisToken, varKeywordToken, variableName, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RestMatchPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

