/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLItemNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLCDATANode;
import java.util.Collection;
import java.util.Collections;

public class STXMLCDATANode
extends STXMLItemNode {
    public final STNode cdataStart;
    public final STNode content;
    public final STNode cdataEnd;

    STXMLCDATANode(STNode cdataStart, STNode content, STNode cdataEnd) {
        this(cdataStart, content, cdataEnd, Collections.emptyList());
    }

    STXMLCDATANode(STNode cdataStart, STNode content, STNode cdataEnd, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_CDATA, diagnostics);
        this.cdataStart = cdataStart;
        this.content = content;
        this.cdataEnd = cdataEnd;
        this.addChildren(cdataStart, content, cdataEnd);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLCDATANode(this.cdataStart, this.content, this.cdataEnd, diagnostics);
    }

    public STXMLCDATANode modify(STNode cdataStart, STNode content, STNode cdataEnd) {
        if (this.checkForReferenceEquality(cdataStart, content, cdataEnd)) {
            return this;
        }
        return new STXMLCDATANode(cdataStart, content, cdataEnd, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLCDATANode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

