/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class BreakStatementNode
extends StatementNode {
    public BreakStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token breakToken() {
        return (Token)this.childInBucket(0);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"breakToken", "semicolonToken"};
    }

    public BreakStatementNode modify(Token breakToken, Token semicolonToken) {
        if (this.checkForReferenceEquality(breakToken, semicolonToken)) {
            return this;
        }
        return NodeFactory.createBreakStatementNode(breakToken, semicolonToken);
    }

    public BreakStatementNodeModifier modify() {
        return new BreakStatementNodeModifier(this);
    }

    public static class BreakStatementNodeModifier {
        private final BreakStatementNode oldNode;
        private Token breakToken;
        private Token semicolonToken;

        public BreakStatementNodeModifier(BreakStatementNode oldNode) {
            this.oldNode = oldNode;
            this.breakToken = oldNode.breakToken();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public BreakStatementNodeModifier withBreakToken(Token breakToken) {
            Objects.requireNonNull(breakToken, "breakToken must not be null");
            this.breakToken = breakToken;
            return this;
        }

        public BreakStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public BreakStatementNode apply() {
            return this.oldNode.modify(this.breakToken, this.semicolonToken);
        }
    }
}

