/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class ConstantDeclarationNode
extends ModuleMemberDeclarationNode {
    public ConstantDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> visibilityQualifier() {
        return this.optionalChildInBucket(1);
    }

    public Token constKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Optional<TypeDescriptorNode> typeDescriptor() {
        return this.optionalChildInBucket(3);
    }

    public Token variableName() {
        return (Token)this.childInBucket(4);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(5);
    }

    public Node initializer() {
        return this.childInBucket(6);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(7);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "visibilityQualifier", "constKeyword", "typeDescriptor", "variableName", "equalsToken", "initializer", "semicolonToken"};
    }

    public ConstantDeclarationNode modify(MetadataNode metadata, Token visibilityQualifier, Token constKeyword, TypeDescriptorNode typeDescriptor, Token variableName, Token equalsToken, Node initializer, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, constKeyword, typeDescriptor, variableName, equalsToken, initializer, semicolonToken)) {
            return this;
        }
        return NodeFactory.createConstantDeclarationNode(metadata, visibilityQualifier, constKeyword, typeDescriptor, variableName, equalsToken, initializer, semicolonToken);
    }

    public ConstantDeclarationNodeModifier modify() {
        return new ConstantDeclarationNodeModifier(this);
    }

    public static class ConstantDeclarationNodeModifier {
        private final ConstantDeclarationNode oldNode;
        private MetadataNode metadata;
        private Token visibilityQualifier;
        private Token constKeyword;
        private TypeDescriptorNode typeDescriptor;
        private Token variableName;
        private Token equalsToken;
        private Node initializer;
        private Token semicolonToken;

        public ConstantDeclarationNodeModifier(ConstantDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.visibilityQualifier = oldNode.visibilityQualifier().orElse(null);
            this.constKeyword = oldNode.constKeyword();
            this.typeDescriptor = oldNode.typeDescriptor().orElse(null);
            this.variableName = oldNode.variableName();
            this.equalsToken = oldNode.equalsToken();
            this.initializer = oldNode.initializer();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ConstantDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public ConstantDeclarationNodeModifier withVisibilityQualifier(Token visibilityQualifier) {
            this.visibilityQualifier = visibilityQualifier;
            return this;
        }

        public ConstantDeclarationNodeModifier withConstKeyword(Token constKeyword) {
            Objects.requireNonNull(constKeyword, "constKeyword must not be null");
            this.constKeyword = constKeyword;
            return this;
        }

        public ConstantDeclarationNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public ConstantDeclarationNodeModifier withVariableName(Token variableName) {
            Objects.requireNonNull(variableName, "variableName must not be null");
            this.variableName = variableName;
            return this;
        }

        public ConstantDeclarationNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public ConstantDeclarationNodeModifier withInitializer(Node initializer) {
            Objects.requireNonNull(initializer, "initializer must not be null");
            this.initializer = initializer;
            return this;
        }

        public ConstantDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ConstantDeclarationNode apply() {
            return this.oldNode.modify(this.metadata, this.visibilityQualifier, this.constKeyword, this.typeDescriptor, this.variableName, this.equalsToken, this.initializer, this.semicolonToken);
        }
    }
}

