/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class EnumDeclarationNode
extends ModuleMemberDeclarationNode {
    public EnumDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> qualifier() {
        return this.optionalChildInBucket(1);
    }

    public Token enumKeywordToken() {
        return (Token)this.childInBucket(2);
    }

    public IdentifierToken identifier() {
        return (IdentifierToken)this.childInBucket(3);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(4);
    }

    public SeparatedNodeList<Node> enumMemberList() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(5));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(6);
    }

    public Optional<Token> semicolonToken() {
        return this.optionalChildInBucket(7);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "qualifier", "enumKeywordToken", "identifier", "openBraceToken", "enumMemberList", "closeBraceToken", "semicolonToken"};
    }

    public EnumDeclarationNode modify(MetadataNode metadata, Token qualifier, Token enumKeywordToken, IdentifierToken identifier, Token openBraceToken, SeparatedNodeList<Node> enumMemberList, Token closeBraceToken, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList.underlyingListNode(), closeBraceToken, semicolonToken)) {
            return this;
        }
        return NodeFactory.createEnumDeclarationNode(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList, closeBraceToken, semicolonToken);
    }

    public EnumDeclarationNodeModifier modify() {
        return new EnumDeclarationNodeModifier(this);
    }

    public static class EnumDeclarationNodeModifier {
        private final EnumDeclarationNode oldNode;
        private MetadataNode metadata;
        private Token qualifier;
        private Token enumKeywordToken;
        private IdentifierToken identifier;
        private Token openBraceToken;
        private SeparatedNodeList<Node> enumMemberList;
        private Token closeBraceToken;
        private Token semicolonToken;

        public EnumDeclarationNodeModifier(EnumDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.qualifier = oldNode.qualifier().orElse(null);
            this.enumKeywordToken = oldNode.enumKeywordToken();
            this.identifier = oldNode.identifier();
            this.openBraceToken = oldNode.openBraceToken();
            this.enumMemberList = oldNode.enumMemberList();
            this.closeBraceToken = oldNode.closeBraceToken();
            this.semicolonToken = oldNode.semicolonToken().orElse(null);
        }

        public EnumDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public EnumDeclarationNodeModifier withQualifier(Token qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public EnumDeclarationNodeModifier withEnumKeywordToken(Token enumKeywordToken) {
            Objects.requireNonNull(enumKeywordToken, "enumKeywordToken must not be null");
            this.enumKeywordToken = enumKeywordToken;
            return this;
        }

        public EnumDeclarationNodeModifier withIdentifier(IdentifierToken identifier) {
            Objects.requireNonNull(identifier, "identifier must not be null");
            this.identifier = identifier;
            return this;
        }

        public EnumDeclarationNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public EnumDeclarationNodeModifier withEnumMemberList(SeparatedNodeList<Node> enumMemberList) {
            Objects.requireNonNull(enumMemberList, "enumMemberList must not be null");
            this.enumMemberList = enumMemberList;
            return this;
        }

        public EnumDeclarationNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public EnumDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            this.semicolonToken = semicolonToken;
            return this;
        }

        public EnumDeclarationNode apply() {
            return this.oldNode.modify(this.metadata, this.qualifier, this.enumKeywordToken, this.identifier, this.openBraceToken, this.enumMemberList, this.closeBraceToken, this.semicolonToken);
        }
    }
}

