/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Objects;
import java.util.Optional;

public class ForEachStatementNode
extends StatementNode {
    public ForEachStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token forEachKeyword() {
        return (Token)this.childInBucket(0);
    }

    public TypedBindingPatternNode typedBindingPattern() {
        return (TypedBindingPatternNode)this.childInBucket(1);
    }

    public Token inKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Node actionOrExpressionNode() {
        return this.childInBucket(3);
    }

    public BlockStatementNode blockStatement() {
        return (BlockStatementNode)this.childInBucket(4);
    }

    public Optional<OnFailClauseNode> onFailClause() {
        return this.optionalChildInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"forEachKeyword", "typedBindingPattern", "inKeyword", "actionOrExpressionNode", "blockStatement", "onFailClause"};
    }

    public ForEachStatementNode modify(Token forEachKeyword, TypedBindingPatternNode typedBindingPattern, Token inKeyword, Node actionOrExpressionNode, BlockStatementNode blockStatement, OnFailClauseNode onFailClause) {
        if (this.checkForReferenceEquality(forEachKeyword, typedBindingPattern, inKeyword, actionOrExpressionNode, blockStatement, onFailClause)) {
            return this;
        }
        return NodeFactory.createForEachStatementNode(forEachKeyword, typedBindingPattern, inKeyword, actionOrExpressionNode, blockStatement, onFailClause);
    }

    public ForEachStatementNodeModifier modify() {
        return new ForEachStatementNodeModifier(this);
    }

    public static class ForEachStatementNodeModifier {
        private final ForEachStatementNode oldNode;
        private Token forEachKeyword;
        private TypedBindingPatternNode typedBindingPattern;
        private Token inKeyword;
        private Node actionOrExpressionNode;
        private BlockStatementNode blockStatement;
        private OnFailClauseNode onFailClause;

        public ForEachStatementNodeModifier(ForEachStatementNode oldNode) {
            this.oldNode = oldNode;
            this.forEachKeyword = oldNode.forEachKeyword();
            this.typedBindingPattern = oldNode.typedBindingPattern();
            this.inKeyword = oldNode.inKeyword();
            this.actionOrExpressionNode = oldNode.actionOrExpressionNode();
            this.blockStatement = oldNode.blockStatement();
            this.onFailClause = oldNode.onFailClause().orElse(null);
        }

        public ForEachStatementNodeModifier withForEachKeyword(Token forEachKeyword) {
            Objects.requireNonNull(forEachKeyword, "forEachKeyword must not be null");
            this.forEachKeyword = forEachKeyword;
            return this;
        }

        public ForEachStatementNodeModifier withTypedBindingPattern(TypedBindingPatternNode typedBindingPattern) {
            Objects.requireNonNull(typedBindingPattern, "typedBindingPattern must not be null");
            this.typedBindingPattern = typedBindingPattern;
            return this;
        }

        public ForEachStatementNodeModifier withInKeyword(Token inKeyword) {
            Objects.requireNonNull(inKeyword, "inKeyword must not be null");
            this.inKeyword = inKeyword;
            return this;
        }

        public ForEachStatementNodeModifier withActionOrExpressionNode(Node actionOrExpressionNode) {
            Objects.requireNonNull(actionOrExpressionNode, "actionOrExpressionNode must not be null");
            this.actionOrExpressionNode = actionOrExpressionNode;
            return this;
        }

        public ForEachStatementNodeModifier withBlockStatement(BlockStatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public ForEachStatementNodeModifier withOnFailClause(OnFailClauseNode onFailClause) {
            this.onFailClause = onFailClause;
            return this;
        }

        public ForEachStatementNode apply() {
            return this.oldNode.modify(this.forEachKeyword, this.typedBindingPattern, this.inKeyword, this.actionOrExpressionNode, this.blockStatement, this.onFailClause);
        }
    }
}

