/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class KeySpecifierNode
extends NonTerminalNode {
    public KeySpecifierNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token keyKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(1);
    }

    public SeparatedNodeList<IdentifierToken> fieldNames() {
        return new SeparatedNodeList<IdentifierToken>((NonTerminalNode)this.childInBucket(2));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"keyKeyword", "openParenToken", "fieldNames", "closeParenToken"};
    }

    public KeySpecifierNode modify(Token keyKeyword, Token openParenToken, SeparatedNodeList<IdentifierToken> fieldNames, Token closeParenToken) {
        if (this.checkForReferenceEquality(keyKeyword, openParenToken, fieldNames.underlyingListNode(), closeParenToken)) {
            return this;
        }
        return NodeFactory.createKeySpecifierNode(keyKeyword, openParenToken, fieldNames, closeParenToken);
    }

    public KeySpecifierNodeModifier modify() {
        return new KeySpecifierNodeModifier(this);
    }

    public static class KeySpecifierNodeModifier {
        private final KeySpecifierNode oldNode;
        private Token keyKeyword;
        private Token openParenToken;
        private SeparatedNodeList<IdentifierToken> fieldNames;
        private Token closeParenToken;

        public KeySpecifierNodeModifier(KeySpecifierNode oldNode) {
            this.oldNode = oldNode;
            this.keyKeyword = oldNode.keyKeyword();
            this.openParenToken = oldNode.openParenToken();
            this.fieldNames = oldNode.fieldNames();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public KeySpecifierNodeModifier withKeyKeyword(Token keyKeyword) {
            Objects.requireNonNull(keyKeyword, "keyKeyword must not be null");
            this.keyKeyword = keyKeyword;
            return this;
        }

        public KeySpecifierNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public KeySpecifierNodeModifier withFieldNames(SeparatedNodeList<IdentifierToken> fieldNames) {
            Objects.requireNonNull(fieldNames, "fieldNames must not be null");
            this.fieldNames = fieldNames;
            return this;
        }

        public KeySpecifierNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public KeySpecifierNode apply() {
            return this.oldNode.modify(this.keyKeyword, this.openParenToken, this.fieldNames, this.closeParenToken);
        }
    }
}

