/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MarkdownCodeLineNode
extends DocumentationNode {
    public MarkdownCodeLineNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token hashToken() {
        return (Token)this.childInBucket(0);
    }

    public Token codeDescription() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"hashToken", "codeDescription"};
    }

    public MarkdownCodeLineNode modify(Token hashToken, Token codeDescription) {
        if (this.checkForReferenceEquality(hashToken, codeDescription)) {
            return this;
        }
        return NodeFactory.createMarkdownCodeLineNode(hashToken, codeDescription);
    }

    public MarkdownCodeLineNodeModifier modify() {
        return new MarkdownCodeLineNodeModifier(this);
    }

    public static class MarkdownCodeLineNodeModifier {
        private final MarkdownCodeLineNode oldNode;
        private Token hashToken;
        private Token codeDescription;

        public MarkdownCodeLineNodeModifier(MarkdownCodeLineNode oldNode) {
            this.oldNode = oldNode;
            this.hashToken = oldNode.hashToken();
            this.codeDescription = oldNode.codeDescription();
        }

        public MarkdownCodeLineNodeModifier withHashToken(Token hashToken) {
            Objects.requireNonNull(hashToken, "hashToken must not be null");
            this.hashToken = hashToken;
            return this;
        }

        public MarkdownCodeLineNodeModifier withCodeDescription(Token codeDescription) {
            Objects.requireNonNull(codeDescription, "codeDescription must not be null");
            this.codeDescription = codeDescription;
            return this;
        }

        public MarkdownCodeLineNode apply() {
            return this.oldNode.modify(this.hashToken, this.codeDescription);
        }
    }
}

