/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.Objects;
import java.util.Optional;

public class ParameterizedTypeDescriptorNode
extends TypeDescriptorNode {
    public ParameterizedTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token keywordToken() {
        return (Token)this.childInBucket(0);
    }

    public Optional<TypeParameterNode> typeParamNode() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"keywordToken", "typeParamNode"};
    }

    public ParameterizedTypeDescriptorNode modify(SyntaxKind kind, Token keywordToken, TypeParameterNode typeParamNode) {
        if (this.checkForReferenceEquality(keywordToken, typeParamNode)) {
            return this;
        }
        return NodeFactory.createParameterizedTypeDescriptorNode(kind, keywordToken, typeParamNode);
    }

    public ParameterizedTypeDescriptorNodeModifier modify() {
        return new ParameterizedTypeDescriptorNodeModifier(this);
    }

    public static class ParameterizedTypeDescriptorNodeModifier {
        private final ParameterizedTypeDescriptorNode oldNode;
        private Token keywordToken;
        private TypeParameterNode typeParamNode;

        public ParameterizedTypeDescriptorNodeModifier(ParameterizedTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.keywordToken = oldNode.keywordToken();
            this.typeParamNode = oldNode.typeParamNode().orElse(null);
        }

        public ParameterizedTypeDescriptorNodeModifier withKeywordToken(Token keywordToken) {
            Objects.requireNonNull(keywordToken, "keywordToken must not be null");
            this.keywordToken = keywordToken;
            return this;
        }

        public ParameterizedTypeDescriptorNodeModifier withTypeParamNode(TypeParameterNode typeParamNode) {
            this.typeParamNode = typeParamNode;
            return this;
        }

        public ParameterizedTypeDescriptorNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.keywordToken, this.typeParamNode);
        }
    }
}

