/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class QueryConstructTypeNode
extends NonTerminalNode {
    public QueryConstructTypeNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token keyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<KeySpecifierNode> keySpecifier() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"keyword", "keySpecifier"};
    }

    public QueryConstructTypeNode modify(Token keyword, KeySpecifierNode keySpecifier) {
        if (this.checkForReferenceEquality(keyword, keySpecifier)) {
            return this;
        }
        return NodeFactory.createQueryConstructTypeNode(keyword, keySpecifier);
    }

    public QueryConstructTypeNodeModifier modify() {
        return new QueryConstructTypeNodeModifier(this);
    }

    public static class QueryConstructTypeNodeModifier {
        private final QueryConstructTypeNode oldNode;
        private Token keyword;
        private KeySpecifierNode keySpecifier;

        public QueryConstructTypeNodeModifier(QueryConstructTypeNode oldNode) {
            this.oldNode = oldNode;
            this.keyword = oldNode.keyword();
            this.keySpecifier = oldNode.keySpecifier().orElse(null);
        }

        public QueryConstructTypeNodeModifier withKeyword(Token keyword) {
            Objects.requireNonNull(keyword, "keyword must not be null");
            this.keyword = keyword;
            return this;
        }

        public QueryConstructTypeNodeModifier withKeySpecifier(KeySpecifierNode keySpecifier) {
            this.keySpecifier = keySpecifier;
            return this;
        }

        public QueryConstructTypeNode apply() {
            return this.oldNode.modify(this.keyword, this.keySpecifier);
        }
    }
}

