/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReFlagsOnOffNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ReFlagExpressionNode
extends NonTerminalNode {
    public ReFlagExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token questionMark() {
        return (Token)this.childInBucket(0);
    }

    public ReFlagsOnOffNode reFlagsOnOff() {
        return (ReFlagsOnOffNode)this.childInBucket(1);
    }

    public Token colon() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"questionMark", "reFlagsOnOff", "colon"};
    }

    public ReFlagExpressionNode modify(Token questionMark, ReFlagsOnOffNode reFlagsOnOff, Token colon) {
        if (this.checkForReferenceEquality(questionMark, reFlagsOnOff, colon)) {
            return this;
        }
        return NodeFactory.createReFlagExpressionNode(questionMark, reFlagsOnOff, colon);
    }

    public ReFlagExpressionNodeModifier modify() {
        return new ReFlagExpressionNodeModifier(this);
    }

    public static class ReFlagExpressionNodeModifier {
        private final ReFlagExpressionNode oldNode;
        private Token questionMark;
        private ReFlagsOnOffNode reFlagsOnOff;
        private Token colon;

        public ReFlagExpressionNodeModifier(ReFlagExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.questionMark = oldNode.questionMark();
            this.reFlagsOnOff = oldNode.reFlagsOnOff();
            this.colon = oldNode.colon();
        }

        public ReFlagExpressionNodeModifier withQuestionMark(Token questionMark) {
            Objects.requireNonNull(questionMark, "questionMark must not be null");
            this.questionMark = questionMark;
            return this;
        }

        public ReFlagExpressionNodeModifier withReFlagsOnOff(ReFlagsOnOffNode reFlagsOnOff) {
            Objects.requireNonNull(reFlagsOnOff, "reFlagsOnOff must not be null");
            this.reFlagsOnOff = reFlagsOnOff;
            return this;
        }

        public ReFlagExpressionNodeModifier withColon(Token colon) {
            Objects.requireNonNull(colon, "colon must not be null");
            this.colon = colon;
            return this;
        }

        public ReFlagExpressionNode apply() {
            return this.oldNode.modify(this.questionMark, this.reFlagsOnOff, this.colon);
        }
    }
}

