/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ReQuoteEscapeNode
extends NonTerminalNode {
    public ReQuoteEscapeNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token slashToken() {
        return (Token)this.childInBucket(0);
    }

    public Node reSyntaxChar() {
        return this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"slashToken", "reSyntaxChar"};
    }

    public ReQuoteEscapeNode modify(Token slashToken, Node reSyntaxChar) {
        if (this.checkForReferenceEquality(slashToken, reSyntaxChar)) {
            return this;
        }
        return NodeFactory.createReQuoteEscapeNode(slashToken, reSyntaxChar);
    }

    public ReQuoteEscapeNodeModifier modify() {
        return new ReQuoteEscapeNodeModifier(this);
    }

    public static class ReQuoteEscapeNodeModifier {
        private final ReQuoteEscapeNode oldNode;
        private Token slashToken;
        private Node reSyntaxChar;

        public ReQuoteEscapeNodeModifier(ReQuoteEscapeNode oldNode) {
            this.oldNode = oldNode;
            this.slashToken = oldNode.slashToken();
            this.reSyntaxChar = oldNode.reSyntaxChar();
        }

        public ReQuoteEscapeNodeModifier withSlashToken(Token slashToken) {
            Objects.requireNonNull(slashToken, "slashToken must not be null");
            this.slashToken = slashToken;
            return this;
        }

        public ReQuoteEscapeNodeModifier withReSyntaxChar(Node reSyntaxChar) {
            Objects.requireNonNull(reSyntaxChar, "reSyntaxChar must not be null");
            this.reSyntaxChar = reSyntaxChar;
            return this;
        }

        public ReQuoteEscapeNode apply() {
            return this.oldNode.modify(this.slashToken, this.reSyntaxChar);
        }
    }
}

