/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ActionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class RemoteMethodCallActionNode
extends ActionNode {
    public RemoteMethodCallActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token rightArrowToken() {
        return (Token)this.childInBucket(1);
    }

    public SimpleNameReferenceNode methodName() {
        return (SimpleNameReferenceNode)this.childInBucket(2);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(3);
    }

    public SeparatedNodeList<FunctionArgumentNode> arguments() {
        return new SeparatedNodeList<FunctionArgumentNode>((NonTerminalNode)this.childInBucket(4));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "rightArrowToken", "methodName", "openParenToken", "arguments", "closeParenToken"};
    }

    public RemoteMethodCallActionNode modify(ExpressionNode expression, Token rightArrowToken, SimpleNameReferenceNode methodName, Token openParenToken, SeparatedNodeList<FunctionArgumentNode> arguments, Token closeParenToken) {
        if (this.checkForReferenceEquality(expression, rightArrowToken, methodName, openParenToken, arguments.underlyingListNode(), closeParenToken)) {
            return this;
        }
        return NodeFactory.createRemoteMethodCallActionNode(expression, rightArrowToken, methodName, openParenToken, arguments, closeParenToken);
    }

    public RemoteMethodCallActionNodeModifier modify() {
        return new RemoteMethodCallActionNodeModifier(this);
    }

    public static class RemoteMethodCallActionNodeModifier {
        private final RemoteMethodCallActionNode oldNode;
        private ExpressionNode expression;
        private Token rightArrowToken;
        private SimpleNameReferenceNode methodName;
        private Token openParenToken;
        private SeparatedNodeList<FunctionArgumentNode> arguments;
        private Token closeParenToken;

        public RemoteMethodCallActionNodeModifier(RemoteMethodCallActionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.rightArrowToken = oldNode.rightArrowToken();
            this.methodName = oldNode.methodName();
            this.openParenToken = oldNode.openParenToken();
            this.arguments = oldNode.arguments();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public RemoteMethodCallActionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public RemoteMethodCallActionNodeModifier withRightArrowToken(Token rightArrowToken) {
            Objects.requireNonNull(rightArrowToken, "rightArrowToken must not be null");
            this.rightArrowToken = rightArrowToken;
            return this;
        }

        public RemoteMethodCallActionNodeModifier withMethodName(SimpleNameReferenceNode methodName) {
            Objects.requireNonNull(methodName, "methodName must not be null");
            this.methodName = methodName;
            return this;
        }

        public RemoteMethodCallActionNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public RemoteMethodCallActionNodeModifier withArguments(SeparatedNodeList<FunctionArgumentNode> arguments) {
            Objects.requireNonNull(arguments, "arguments must not be null");
            this.arguments = arguments;
            return this;
        }

        public RemoteMethodCallActionNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public RemoteMethodCallActionNode apply() {
            return this.oldNode.modify(this.expression, this.rightArrowToken, this.methodName, this.openParenToken, this.arguments, this.closeParenToken);
        }
    }
}

