/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.client.AuthConfigGeneratorImp;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.RemoteFunctionGenerator;
import io.ballerina.openapi.core.generators.client.ResourceFunctionGenerator;
import io.ballerina.openapi.core.generators.client.ServerURLGeneratorImp;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.exception.ClientException;
import io.ballerina.openapi.core.generators.client.model.OASClientConfig;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.core.generators.document.ClientDocCommentGenerator;
import io.ballerina.openapi.core.generators.document.DocCommentsGeneratorUtil;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BallerinaClientGenerator {
    protected OASClientConfig oasClientConfig;
    private final Filter filter;
    protected List<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
    private List<String> apiKeyNameList = new ArrayList<String>();
    protected final OpenAPI openAPI;
    protected final BallerinaUtilGenerator ballerinaUtilGenerator;
    private final List<String> remoteFunctionNameList;
    protected AuthConfigGeneratorImp authConfigGeneratorImp;
    private final boolean resourceMode;
    protected final List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    private String serverURL;

    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public AuthConfigGeneratorImp getBallerinaAuthConfigGenerator() {
        return this.authConfigGeneratorImp;
    }

    public List<String> getRemoteFunctionNameList() {
        return this.remoteFunctionNameList;
    }

    public String getServerUrl() {
        return this.serverURL;
    }

    public BallerinaClientGenerator(OASClientConfig oasClientConfig) {
        this.filter = oasClientConfig.getFilter();
        this.openAPI = oasClientConfig.getOpenAPI();
        this.ballerinaUtilGenerator = new BallerinaUtilGenerator();
        this.remoteFunctionNameList = new ArrayList<String>();
        this.authConfigGeneratorImp = new AuthConfigGeneratorImp(false, false);
        this.resourceMode = oasClientConfig.isResourceMode();
        this.oasClientConfig = oasClientConfig;
    }

    public SyntaxTree generateSyntaxTree() throws BallerinaOpenApiException, ClientException {
        this.generateHttpImport();
        return this.getSyntaxTree();
    }

    protected SyntaxTree getSyntaxTree() throws ClientException, BallerinaOpenApiException {
        this.authConfigGeneratorImp.addAuthRelatedRecords(this.openAPI);
        List<ModuleMemberDeclarationNode> nodes = this.getModuleMemberDeclarationNodes();
        NodeList importsList = AbstractNodeFactory.createNodeList(this.imports);
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)importsList, (NodeList)AbstractNodeFactory.createNodeList(nodes), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        syntaxTree = syntaxTree.modifyWith((Node)modulePartNode);
        ClientDocCommentGenerator clientDocCommentGenerator = new ClientDocCommentGenerator(syntaxTree, this.openAPI, this.resourceMode);
        return clientDocCommentGenerator.updateSyntaxTreeWithDocComments();
    }

    private void generateHttpImport() {
        List<ImportDeclarationNode> importForHttp = this.getImportDeclarationNodes();
        this.imports.addAll(importForHttp);
    }

    protected List<ModuleMemberDeclarationNode> getModuleMemberDeclarationNodes() throws BallerinaOpenApiException {
        ArrayList<ModuleMemberDeclarationNode> nodes = new ArrayList<ModuleMemberDeclarationNode>();
        nodes.add((ModuleMemberDeclarationNode)this.getClassDefinitionNode());
        return nodes;
    }

    protected List<ImportDeclarationNode> getImportDeclarationNodes() {
        ImportDeclarationNode importForHttp = GeneratorUtils.getImportDeclarationNode("ballerina", "http");
        return new ArrayList<ImportDeclarationNode>(List.of(importForHttp));
    }

    public BallerinaUtilGenerator getBallerinaUtilGenerator() {
        return this.ballerinaUtilGenerator;
    }

    protected ClassDefinitionNode getClassDefinitionNode() {
        ArrayList<Object> memberNodeList = new ArrayList<Object>();
        memberNodeList.addAll(this.createClassInstanceVariables());
        memberNodeList.add(this.createInitFunction());
        Map<String, Map<PathItem.HttpMethod, Operation>> filteredOperations = this.filterOperations();
        ArrayList<FunctionDefinitionNode> functionDefinitionNodeList = new ArrayList<FunctionDefinitionNode>();
        if (this.resourceMode) {
            functionDefinitionNodeList.addAll(this.createResourceFunctions(filteredOperations));
        } else {
            functionDefinitionNodeList.addAll(this.createRemoteFunctions(filteredOperations));
        }
        memberNodeList.addAll(functionDefinitionNodeList);
        MetadataNode metadataNode = this.getClassMetadataNode();
        IdentifierToken className = AbstractNodeFactory.createIdentifierToken((String)"Client");
        NodeList classTypeQualifiers = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLIENT_KEYWORD)});
        return NodeFactory.createClassDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (NodeList)classTypeQualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLASS_KEYWORD), (Token)className, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(memberNodeList), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    protected Map<String, Map<PathItem.HttpMethod, Operation>> filterOperations() {
        LinkedHashMap<String, Map<PathItem.HttpMethod, Operation>> filteredOperations = new LinkedHashMap<String, Map<PathItem.HttpMethod, Operation>>();
        List<String> filterTags = this.filter.getTags();
        List<String> filterOperations = this.filter.getOperations();
        for (Map.Entry pathEntry : this.openAPI.getPaths().entrySet()) {
            LinkedHashMap<PathItem.HttpMethod, Operation> operations = new LinkedHashMap<PathItem.HttpMethod, Operation>();
            Map operationMap = ((PathItem)pathEntry.getValue()).readOperationsMap();
            if (operationMap.isEmpty()) continue;
            for (Map.Entry operationEntry : operationMap.entrySet()) {
                String operationId;
                Operation operation = (Operation)operationEntry.getValue();
                List operationTags = operation.getTags();
                if (!this.shouldFilterOperation(filterTags, filterOperations, operationTags, operationId = operation.getOperationId())) continue;
                operations.put((PathItem.HttpMethod)operationEntry.getKey(), operation);
            }
            if (operations.isEmpty()) continue;
            filteredOperations.put((String)pathEntry.getKey(), operations);
        }
        return filteredOperations;
    }

    private boolean shouldFilterOperation(List<String> filterTags, List<String> filterOperations, List<String> operationTags, String operationId) {
        boolean hasOperationId;
        boolean hasFilterTags = !filterTags.isEmpty();
        boolean hasFilterOperations = !filterOperations.isEmpty();
        boolean hasOperationTags = operationTags != null;
        boolean bl = hasOperationId = operationId != null;
        if (!hasFilterTags && !hasFilterOperations) {
            return true;
        }
        return hasFilterTags && hasOperationTags && !Collections.disjoint(filterTags, operationTags) || hasFilterOperations && hasOperationId && filterOperations.contains(operationId);
    }

    protected MetadataNode getClassMetadataNode() {
        ArrayList<AnnotationNode> classLevelAnnotationNodes = new ArrayList<AnnotationNode>();
        if (this.openAPI.getInfo().getExtensions() != null) {
            Map extensions = this.openAPI.getInfo().getExtensions();
            DocCommentsGeneratorUtil.extractDisplayAnnotation(extensions, classLevelAnnotationNodes);
        }
        ArrayList<MarkdownDocumentationLineNode> documentationLines = new ArrayList<MarkdownDocumentationLineNode>();
        if (this.openAPI.getInfo().getDescription() != null && !this.openAPI.getInfo().getDescription().isBlank()) {
            documentationLines.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(this.openAPI.getInfo().getDescription(), false));
        }
        MarkdownDocumentationNode apiDoc = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(documentationLines));
        return NodeFactory.createMetadataNode((Node)apiDoc, (NodeList)AbstractNodeFactory.createNodeList(classLevelAnnotationNodes));
    }

    FunctionDefinitionNode createInitFunction() {
        FunctionSignatureNode functionSignatureNode = this.getInitFunctionSignatureNode();
        FunctionBodyNode functionBodyNode = this.getInitFunctionBodyNode();
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"init");
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, (MetadataNode)this.getInitDocComment(), (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    protected FunctionBodyNode getInitFunctionBodyNode() {
        ArrayList<Object> assignmentNodes = new ArrayList<Object>();
        assignmentNodes.add(this.authConfigGeneratorImp.getHttpClientConfigVariableNode());
        if (this.authConfigGeneratorImp.isApiKey() && this.authConfigGeneratorImp.isHttpOROAuth()) {
            assignmentNodes.add(this.authConfigGeneratorImp.handleInitForMixOfApiKeyAndHTTPOrOAuth());
        }
        assignmentNodes.add(this.authConfigGeneratorImp.getClientInitializationNode());
        if (this.authConfigGeneratorImp.isApiKey() && !this.authConfigGeneratorImp.isHttpOROAuth()) {
            assignmentNodes.add(this.authConfigGeneratorImp.getApiKeyAssignmentNode());
        }
        if (this.authConfigGeneratorImp.isApiKey()) {
            ArrayList<String> apiKeyNames = new ArrayList<String>();
            this.authConfigGeneratorImp.getHeaderApiKeyNameMap().values().forEach(apiKeyNamePair -> apiKeyNames.add(apiKeyNamePair.displayName()));
            this.authConfigGeneratorImp.getQueryApiKeyNameMap().values().forEach(apiKeyNamePair -> apiKeyNames.add(apiKeyNamePair.displayName()));
            this.setApiKeyNameList(apiKeyNames);
        }
        NodeList statementList = AbstractNodeFactory.createNodeList(assignmentNodes);
        return NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statementList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    protected FunctionSignatureNode getInitFunctionSignatureNode() {
        ArrayList<ParameterNode> parameterNodes = new ArrayList<ParameterNode>();
        ServerURLGeneratorImp serverURLGeneratorImp = new ServerURLGeneratorImp(this.openAPI.getServers());
        ParameterNode serverURLNode = serverURLGeneratorImp.generateServerURL();
        if (serverURLNode instanceof DefaultableParameterNode) {
            DefaultableParameterNode defNode = (DefaultableParameterNode)serverURLNode;
            if (((Token)defNode.paramName().get()).toString().equals("serviceUrl")) {
                this.serverURL = defNode.expression().toSourceCode().replace('\"', ' ').trim();
            }
        } else {
            this.serverURL = "/";
        }
        this.diagnostics.addAll(serverURLGeneratorImp.getDiagnostics());
        parameterNodes.add(serverURLNode);
        List<ParameterNode> configParams = this.authConfigGeneratorImp.getConfigParamForClassInit();
        this.diagnostics.addAll(this.authConfigGeneratorImp.getDiagnostics());
        parameterNodes.addAll(configParams);
        LinkedHashSet<Node> orderedParam = this.sortParameters(parameterNodes);
        SeparatedNodeList parameterList = AbstractNodeFactory.createSeparatedNodeList(orderedParam);
        OptionalTypeDescriptorNode returnType = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnType);
        return NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameterList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    private LinkedHashSet<Node> sortParameters(List<ParameterNode> parameters) {
        HashMap<String, RequiredParameterNode> requiredParams = new HashMap<String, RequiredParameterNode>();
        ArrayList<String> requiredParamNames = new ArrayList<String>();
        ArrayList<String> defaultParamNames = new ArrayList<String>();
        HashMap<String, DefaultableParameterNode> defaultParams = new HashMap<String, DefaultableParameterNode>();
        for (ParameterNode parameter : parameters) {
            String paramName;
            if (parameter instanceof RequiredParameterNode) {
                RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameter;
                paramName = ((Token)requiredParameterNode.paramName().get()).toString();
                requiredParamNames.add(paramName);
                requiredParams.put(paramName, requiredParameterNode);
                continue;
            }
            if (!(parameter instanceof DefaultableParameterNode)) continue;
            DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameter;
            paramName = ((Token)defaultableParameterNode.paramName().get()).toString();
            defaultParams.put(paramName, defaultableParameterNode);
            defaultParamNames.add(paramName);
        }
        List<String> sortedRequiredParamNames = BallerinaClientGenerator.ascendingOrder(requiredParamNames);
        List<String> sortedDefaultParamNames = BallerinaClientGenerator.ascendingOrder(defaultParamNames);
        LinkedHashSet<Node> paramNodes = new LinkedHashSet<Node>();
        for (String paramName : sortedRequiredParamNames) {
            paramNodes.add((Node)requiredParams.get(paramName));
            paramNodes.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        for (String paramName : sortedDefaultParamNames) {
            paramNodes.add((Node)defaultParams.get(paramName));
            paramNodes.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (!paramNodes.isEmpty() && paramNodes.toArray()[paramNodes.size() - 1] instanceof Token) {
            paramNodes.remove(paramNodes.toArray()[paramNodes.size() - 1]);
        }
        return paramNodes;
    }

    public static List<String> ascendingOrder(List<String> inputList) {
        ArrayList<String> sortedList = new ArrayList<String>(inputList);
        Collections.sort(sortedList);
        return sortedList;
    }

    protected MetadataNode getInitDocComment() {
        ArrayList<Object> docs = new ArrayList<Object>();
        String clientInitDocComment = "Gets invoked to initialize the `connector`.\n";
        if (this.openAPI.getInfo().getExtensions() != null && !this.openAPI.getInfo().getExtensions().isEmpty()) {
            Map extensions = this.openAPI.getInfo().getExtensions();
            for (Map.Entry extension : extensions.entrySet()) {
                if (!((String)extension.getKey()).trim().equals("x-ballerina-init-description")) continue;
                clientInitDocComment = clientInitDocComment.concat(extension.getValue().toString());
                break;
            }
        }
        docs.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(clientInitDocComment, true));
        if (this.authConfigGeneratorImp.isApiKey() && !this.authConfigGeneratorImp.isHttpOROAuth()) {
            MarkdownParameterDocumentationLineNode apiKeyConfig = DocCommentsGeneratorUtil.createAPIParamDoc("apiKeyConfig", "API keys for authorization");
            docs.add(apiKeyConfig);
        }
        MarkdownParameterDocumentationLineNode clientConfig = DocCommentsGeneratorUtil.createAPIParamDoc("config", "The configurations to be used when initializing the `connector`");
        docs.add(clientConfig);
        MarkdownParameterDocumentationLineNode serviceUrlAPI = DocCommentsGeneratorUtil.createAPIParamDoc("serviceUrl", "URL of the target service");
        docs.add(serviceUrlAPI);
        MarkdownParameterDocumentationLineNode returnDoc = DocCommentsGeneratorUtil.createAPIParamDoc("return", "An error if connector initialization failed");
        docs.add(returnDoc);
        MarkdownDocumentationNode clientInitDoc = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)clientInitDoc, (NodeList)AbstractNodeFactory.createEmptyNodeList());
    }

    protected List<ObjectFieldNode> createClassInstanceVariables() {
        ArrayList<ObjectFieldNode> fieldNodeList = new ArrayList<ObjectFieldNode>();
        Token finalKeywordToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD);
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{finalKeywordToken});
        QualifiedNameReferenceNode typeName = this.getHttpClientTypeName();
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"clientEp");
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        ObjectFieldNode httpClientField = NodeFactory.createObjectFieldNode((MetadataNode)metadataNode, null, (NodeList)qualifierList, (Node)typeName, (Token)fieldName, null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        fieldNodeList.add(httpClientField);
        ObjectFieldNode apiKeyFieldNode = this.authConfigGeneratorImp.getApiKeyMapClassVariable();
        if (apiKeyFieldNode != null) {
            fieldNodeList.add(apiKeyFieldNode);
        }
        return fieldNodeList;
    }

    protected QualifiedNameReferenceNode getHttpClientTypeName() {
        return NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Client"));
    }

    List<FunctionDefinitionNode> createRemoteFunctions(Map<String, Map<PathItem.HttpMethod, Operation>> filteredOperations) {
        ArrayList<FunctionDefinitionNode> remoteFunctionNodes = new ArrayList<FunctionDefinitionNode>();
        for (Map.Entry<String, Map<PathItem.HttpMethod, Operation>> operation : filteredOperations.entrySet()) {
            for (Map.Entry<PathItem.HttpMethod, Operation> operationEntry : operation.getValue().entrySet()) {
                this.addRemoteFunction(operationEntry, operation.getKey(), remoteFunctionNodes);
            }
        }
        return remoteFunctionNodes;
    }

    protected FunctionGeneratorResults addRemoteFunction(Map.Entry<PathItem.HttpMethod, Operation> operationEntry, String path, List<FunctionDefinitionNode> functionNodes) {
        this.remoteFunctionNameList.add(operationEntry.getValue().getOperationId());
        RemoteFunctionGenerator remoteFunctionGenerator = this.getRemoteFunctionGenerator(operationEntry, path);
        Optional<FunctionDefinitionNode> remoteFunction = remoteFunctionGenerator.generateFunction();
        this.diagnostics.addAll(remoteFunctionGenerator.getDiagnostics());
        if (remoteFunction.isPresent()) {
            functionNodes.add(remoteFunction.get());
            return new FunctionGeneratorResults(true, remoteFunctionGenerator.hasDefaultStatusCodeBinding(), remoteFunctionGenerator.getNonDefaultStatusCodes());
        }
        return new FunctionGeneratorResults(false);
    }

    protected RemoteFunctionGenerator getRemoteFunctionGenerator(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) {
        return new RemoteFunctionGenerator(path, operation, this.openAPI, this.authConfigGeneratorImp, this.ballerinaUtilGenerator, this.imports);
    }

    List<FunctionDefinitionNode> createResourceFunctions(Map<String, Map<PathItem.HttpMethod, Operation>> filteredOperations) {
        ArrayList<FunctionDefinitionNode> resourceFunctionNodes = new ArrayList<FunctionDefinitionNode>();
        for (Map.Entry<String, Map<PathItem.HttpMethod, Operation>> operation : filteredOperations.entrySet()) {
            for (Map.Entry<PathItem.HttpMethod, Operation> operationEntry : operation.getValue().entrySet()) {
                this.addResourceFunction(operationEntry, operation.getKey(), resourceFunctionNodes);
            }
        }
        return resourceFunctionNodes;
    }

    protected FunctionGeneratorResults addResourceFunction(Map.Entry<PathItem.HttpMethod, Operation> operationEntry, String path, List<FunctionDefinitionNode> functionNodes) {
        this.remoteFunctionNameList.add(operationEntry.getValue().getOperationId());
        ResourceFunctionGenerator resourceFunctionGenerator = this.getResourceFunctionGenerator(operationEntry, path);
        Optional<FunctionDefinitionNode> resourceFunction = resourceFunctionGenerator.generateFunction();
        this.diagnostics.addAll(resourceFunctionGenerator.getDiagnostics());
        if (resourceFunction.isPresent()) {
            functionNodes.add(resourceFunction.get());
            return new FunctionGeneratorResults(true, resourceFunctionGenerator.hasDefaultStatusCodeBinding(), resourceFunctionGenerator.getNonDefaultStatusCodes());
        }
        return new FunctionGeneratorResults(false);
    }

    protected ResourceFunctionGenerator getResourceFunctionGenerator(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) {
        return new ResourceFunctionGenerator(operation, path, this.openAPI, this.authConfigGeneratorImp, this.ballerinaUtilGenerator, this.imports);
    }

    public Set<String> getAuthType() {
        return this.authConfigGeneratorImp.getAuthType();
    }

    public List<String> getApiKeyNameList() {
        return this.apiKeyNameList;
    }

    public void setApiKeyNameList(List<String> apiKeyNameList) {
        this.apiKeyNameList = apiKeyNameList;
    }

    public record FunctionGeneratorResults(boolean isSuccess, boolean hasDefaultStatusCodeBinding, List<String> nonDefaultStatusCodes) {
        public FunctionGeneratorResults(boolean status) {
            this(status, false, new ArrayList<String>());
        }
    }
}

