/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.ExternalFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.core.generators.client.AuthConfigGeneratorImp;
import io.ballerina.openapi.core.generators.client.BallerinaClientGenerator;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.FunctionBodyGenerator;
import io.ballerina.openapi.core.generators.client.ImplFunctionBodyGenerator;
import io.ballerina.openapi.core.generators.client.ImplFunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.RemoteExternalFunctionGenerator;
import io.ballerina.openapi.core.generators.client.RemoteFunctionGenerator;
import io.ballerina.openapi.core.generators.client.ResourceExternalFunctionGenerator;
import io.ballerina.openapi.core.generators.client.ResourceFunctionGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.client.model.OASClientConfig;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class BallerinaClientGeneratorWithStatusCodeBinding
extends BallerinaClientGenerator {
    public BallerinaClientGeneratorWithStatusCodeBinding(OASClientConfig oasClientConfig) {
        super(oasClientConfig);
        this.authConfigGeneratorImp = new AuthConfigGeneratorImp(false, false);
    }

    @Override
    protected List<ImportDeclarationNode> getImportDeclarationNodes() {
        List<ImportDeclarationNode> importDeclarationNodes = super.getImportDeclarationNodes();
        ImportDeclarationNode importForJBallerina = GeneratorUtils.getImportDeclarationNode("ballerina", "jballerina.java");
        importDeclarationNodes.add(importForJBallerina);
        return importDeclarationNodes;
    }

    @Override
    protected List<ModuleMemberDeclarationNode> getModuleMemberDeclarationNodes() throws BallerinaOpenApiException {
        ArrayList<ModuleMemberDeclarationNode> nodes = new ArrayList<ModuleMemberDeclarationNode>();
        nodes.add((ModuleMemberDeclarationNode)this.getSetModuleFunction());
        nodes.add((ModuleMemberDeclarationNode)this.getModuleInitFunction());
        nodes.add((ModuleMemberDeclarationNode)this.getClientMethodImplType());
        nodes.add((ModuleMemberDeclarationNode)this.getMethodImplAnnotation());
        nodes.add((ModuleMemberDeclarationNode)this.getClientErrorType());
        nodes.addAll(super.getModuleMemberDeclarationNodes());
        return nodes;
    }

    @Override
    protected BallerinaClientGenerator.FunctionGeneratorResults addRemoteFunction(Map.Entry<PathItem.HttpMethod, Operation> operationEntry, String path, List<FunctionDefinitionNode> functionNodes) {
        BallerinaClientGenerator.FunctionGeneratorResults result = super.addRemoteFunction(operationEntry, path, functionNodes);
        if (result.isSuccess()) {
            this.addClientFunctionImpl(operationEntry, path, functionNodes, result.hasDefaultStatusCodeBinding(), result.nonDefaultStatusCodes());
        }
        return result;
    }

    @Override
    protected RemoteFunctionGenerator getRemoteFunctionGenerator(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) {
        return new RemoteExternalFunctionGenerator(path, operation, this.openAPI, this.authConfigGeneratorImp, this.ballerinaUtilGenerator, this.imports);
    }

    @Override
    protected QualifiedNameReferenceNode getHttpClientTypeName() {
        return NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"StatusCodeClient"));
    }

    private void addClientFunctionImpl(Map.Entry<PathItem.HttpMethod, Operation> operationEntry, String path, List<FunctionDefinitionNode> clientFunctionNodes, boolean hasDefaultResponse, List<String> nonDefaultStatusCodes) {
        FunctionDefinitionNode clientExternFunction = clientFunctionNodes.get(clientFunctionNodes.size() - 1);
        Optional<FunctionDefinitionNode> implFunction = this.createImplFunction(path, operationEntry, this.openAPI, this.authConfigGeneratorImp, this.ballerinaUtilGenerator, clientExternFunction, hasDefaultResponse, nonDefaultStatusCodes);
        if (implFunction.isPresent()) {
            clientFunctionNodes.add(implFunction.get());
        } else {
            this.diagnostics.add(new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_112, operationEntry.getValue().getOperationId()));
            clientFunctionNodes.remove(clientFunctionNodes.size() - 1);
        }
    }

    @Override
    protected BallerinaClientGenerator.FunctionGeneratorResults addResourceFunction(Map.Entry<PathItem.HttpMethod, Operation> operationEntry, String path, List<FunctionDefinitionNode> functionNodes) {
        BallerinaClientGenerator.FunctionGeneratorResults result = super.addResourceFunction(operationEntry, path, functionNodes);
        if (result.isSuccess()) {
            this.addClientFunctionImpl(operationEntry, path, functionNodes, result.hasDefaultStatusCodeBinding(), result.nonDefaultStatusCodes());
        }
        return result;
    }

    @Override
    protected ResourceFunctionGenerator getResourceFunctionGenerator(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) {
        return new ResourceExternalFunctionGenerator(operation, path, this.openAPI, this.authConfigGeneratorImp, this.ballerinaUtilGenerator, this.imports);
    }

    protected Optional<FunctionDefinitionNode> createImplFunction(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, AuthConfigGeneratorImp authConfigGeneratorImp, BallerinaUtilGenerator ballerinaUtilGenerator, FunctionDefinitionNode clientExternFunction, boolean hasDefaultResponse, List<String> nonDefaultStatusCodes) {
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PRIVATE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        Token functionKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD);
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)(operation.getValue().getOperationId() + "Impl"));
        ImplFunctionSignatureGenerator signatureGenerator = this.getImplFunctionSignatureGenerator(path, operation, openAPI, clientExternFunction);
        FunctionBodyGenerator functionBodyGenerator = this.getFunctionBodyGeneratorImp(path, operation, openAPI, authConfigGeneratorImp, ballerinaUtilGenerator, hasDefaultResponse, nonDefaultStatusCodes, signatureGenerator);
        Optional<FunctionBodyNode> functionBodyNodeResult = functionBodyGenerator.getFunctionBodyNode();
        this.diagnostics.addAll(functionBodyGenerator.getDiagnostics());
        if (functionBodyNodeResult.isEmpty()) {
            return Optional.empty();
        }
        FunctionBodyNode functionBodyNode = functionBodyNodeResult.get();
        Optional<FunctionSignatureNode> functionSignatureNode = signatureGenerator.generateFunctionSignature();
        return functionSignatureNode.map(signatureNode -> NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, null, (NodeList)qualifierList, (Token)functionKeyWord, (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)signatureNode, (FunctionBodyNode)functionBodyNode));
    }

    protected ImplFunctionSignatureGenerator getImplFunctionSignatureGenerator(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, FunctionDefinitionNode clientExternFunction) {
        return new ImplFunctionSignatureGenerator(operation.getValue(), openAPI, operation.getKey().toString().toLowerCase(Locale.ROOT), path, clientExternFunction);
    }

    protected FunctionBodyGenerator getFunctionBodyGeneratorImp(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, AuthConfigGeneratorImp authConfigGeneratorImp, BallerinaUtilGenerator ballerinaUtilGenerator, boolean hasDefaultResponse, List<String> nonDefaultStatusCodes, ImplFunctionSignatureGenerator signatureGenerator) {
        return new ImplFunctionBodyGenerator(path, operation, openAPI, authConfigGeneratorImp, ballerinaUtilGenerator, this.imports, signatureGenerator.hasHeaders(), signatureGenerator.hasDefaultHeaders(), signatureGenerator.hasQueries(), signatureGenerator.getHeadersParamName(), hasDefaultResponse, nonDefaultStatusCodes);
    }

    private FunctionDefinitionNode getSetModuleFunction() {
        NodeList emptyQualifiers = AbstractNodeFactory.createEmptyNodeList();
        NodeList emptyNodeList = AbstractNodeFactory.createEmptyNodeList();
        SeparatedNodeList emptyParamList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]);
        FunctionSignatureNode functionSignatureNode = NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)emptyParamList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), null);
        QualifiedNameReferenceNode javaMethodToken = NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"java"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Method"));
        BasicLiteralNode classValueExp = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)"\"io.ballerina.openapi.client.ModuleUtils\"", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        SpecificFieldNode classFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"'class"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)classValueExp);
        MappingConstructorExpressionNode methodMapExp = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{classFieldNode}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        AnnotationNode javaMethodAnnot = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)javaMethodToken, (MappingConstructorExpressionNode)methodMapExp);
        ExternalFunctionBodyNode externalFunctionBodyNode = NodeFactory.createExternalFunctionBodyNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{javaMethodAnnot}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EXTERNAL_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, null, (NodeList)emptyQualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"setModule"), (NodeList)emptyNodeList, (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)externalFunctionBodyNode);
    }

    private FunctionDefinitionNode getModuleInitFunction() {
        NodeList emptyQualifiers = AbstractNodeFactory.createEmptyNodeList();
        NodeList emptyNodeList = AbstractNodeFactory.createEmptyNodeList();
        SeparatedNodeList emptyParamList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]);
        FunctionSignatureNode functionSignatureNode = NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)emptyParamList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), null);
        FunctionCallExpressionNode setModuleFuncCall = NodeFactory.createFunctionCallExpressionNode((NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"setModule")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        ExpressionStatementNode setModuleStatement = NodeFactory.createExpressionStatementNode(null, (ExpressionNode)setModuleFuncCall, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        NodeList statementsNodeList = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{setModuleStatement});
        FunctionBodyBlockNode functionBodyNode = NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statementsNodeList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, null, (NodeList)emptyQualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"init"), (NodeList)emptyNodeList, (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private TypeDefinitionNode getClientMethodImplType() {
        RecordFieldNode nameFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)AbstractNodeFactory.createIdentifierToken((String)"string"), (Token)AbstractNodeFactory.createIdentifierToken((String)"name"), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        RecordTypeDescriptorNode recordDescriptor = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{nameFieldNode}), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"ClientMethodImpl"), (Node)recordDescriptor, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private AnnotationDeclarationNode getMethodImplAnnotation() {
        return NodeFactory.createAnnotationDeclarationNode(null, null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ANNOTATION_KEYWORD), (Node)AbstractNodeFactory.createIdentifierToken((String)"ClientMethodImpl"), (Token)AbstractNodeFactory.createIdentifierToken((String)"MethodImpl"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ON_KEYWORD), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    protected TypeDefinitionNode getClientErrorType() {
        return NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"ClientMethodInvocationError"), (Node)NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"ClientError")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }
}

