/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.ResourceFunctionSignatureGenerator;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ImplFunctionSignatureGenerator {
    List<Node> parameterNodes = new ArrayList<Node>();
    ReturnTypeDescriptorNode returnTypeDescriptorNode;
    ResourceFunctionSignatureGenerator resourceFunctionSignatureGenerator;

    public ImplFunctionSignatureGenerator(Operation operation, OpenAPI openAPI, String httpMethod, String path, FunctionDefinitionNode clientExternFunction) {
        FunctionSignatureNode functionSignatureNode = clientExternFunction.functionSignature();
        if (Objects.isNull(functionSignatureNode)) {
            return;
        }
        this.populateParameterNodes(clientExternFunction);
        SimpleNameReferenceNode statusCodeResponseType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:StatusCodeResponse"));
        this.returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)statusCodeResponseType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"error"))));
        this.resourceFunctionSignatureGenerator = new ResourceFunctionSignatureGenerator(operation, openAPI, httpMethod, path);
        this.resourceFunctionSignatureGenerator.generateFunctionSignature();
    }

    private void populateParameterNodes(FunctionDefinitionNode clientExternFunction) {
        this.addParametersFromPath(clientExternFunction);
        this.addParametersFromSignature(clientExternFunction);
    }

    private void addParametersFromSignature(FunctionDefinitionNode clientExternFunction) {
        FunctionSignatureNode functionSignatureNode = clientExternFunction.functionSignature();
        for (ParameterNode paramNode : functionSignatureNode.parameters()) {
            this.parameterNodes.add(this.removeDefaultValue(paramNode));
            this.parameterNodes.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
    }

    private void addParametersFromPath(FunctionDefinitionNode clientExternFunction) {
        NodeList pathParams = clientExternFunction.relativeResourcePath();
        if (Objects.isNull(pathParams) || pathParams.isEmpty()) {
            return;
        }
        for (Node node : pathParams) {
            if (!(node instanceof ResourcePathParameterNode)) continue;
            ResourcePathParameterNode pathParameterNode = (ResourcePathParameterNode)node;
            RequiredParameterNode pathParam = NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)pathParameterNode.typeDescriptor(), (Token)pathParameterNode.paramName().orElse(null));
            this.parameterNodes.add((Node)pathParam);
            this.parameterNodes.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
    }

    private Node removeDefaultValue(ParameterNode parameterNode) {
        if (parameterNode instanceof DefaultableParameterNode) {
            DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
            return NodeFactory.createRequiredParameterNode((NodeList)defaultableParameterNode.annotations(), (Node)defaultableParameterNode.typeName(), (Token)defaultableParameterNode.paramName().orElse(null));
        }
        return parameterNode;
    }

    public Optional<FunctionSignatureNode> generateFunctionSignature() {
        if (!this.parameterNodes.isEmpty()) {
            this.parameterNodes.remove(this.parameterNodes.size() - 1);
        }
        SeparatedNodeList parameterNodeList = AbstractNodeFactory.createSeparatedNodeList(this.parameterNodes);
        return Optional.of(NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameterNodeList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)this.returnTypeDescriptorNode));
    }

    public boolean hasDefaultHeaders() {
        return this.resourceFunctionSignatureGenerator.hasDefaultHeaders();
    }

    public boolean hasHeaders() {
        return this.resourceFunctionSignatureGenerator.hasHeaders();
    }

    public boolean hasQueries() {
        return this.resourceFunctionSignatureGenerator.hasQueries();
    }

    public String getHeadersParamName() {
        return this.resourceFunctionSignatureGenerator.getHeadersParamName();
    }
}

