/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.client.AuthConfigGeneratorImp;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.FunctionBodyGeneratorImp;
import io.ballerina.openapi.core.generators.client.FunctionGenerator;
import io.ballerina.openapi.core.generators.client.RemoteFunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class RemoteFunctionGenerator
implements FunctionGenerator {
    String path;
    Map.Entry<PathItem.HttpMethod, Operation> operation;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    OpenAPI openAPI;
    AuthConfigGeneratorImp authConfigGeneratorImp;
    BallerinaUtilGenerator ballerinaUtilGenerator;
    List<ImportDeclarationNode> imports;
    RemoteFunctionSignatureGenerator signatureGenerator;

    RemoteFunctionGenerator(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, AuthConfigGeneratorImp authConfigGeneratorImp, BallerinaUtilGenerator ballerinaUtilGenerator, List<ImportDeclarationNode> imports) {
        this.path = path;
        this.operation = operation;
        this.openAPI = openAPI;
        this.authConfigGeneratorImp = authConfigGeneratorImp;
        this.ballerinaUtilGenerator = ballerinaUtilGenerator;
        this.imports = imports;
        this.signatureGenerator = new RemoteFunctionSignatureGenerator(operation.getValue(), openAPI, operation.getKey().toString().toLowerCase(Locale.ROOT), path);
    }

    public List<ImportDeclarationNode> getImports() {
        return this.imports;
    }

    @Override
    public Optional<FunctionDefinitionNode> generateFunction() {
        GeneratorUtils.addCommonParamsToOperationParams(this.operation, this.openAPI, this.path);
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.REMOTE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        Token functionKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD);
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)this.operation.getValue().getOperationId());
        Optional<FunctionSignatureNode> signatureNodeOptional = this.signatureGenerator.generateFunctionSignature();
        this.diagnostics.addAll(this.signatureGenerator.getDiagnostics());
        if (signatureNodeOptional.isEmpty()) {
            return Optional.empty();
        }
        FunctionSignatureNode functionSignatureNode = signatureNodeOptional.get();
        Optional<FunctionBodyNode> functionBodyNodeResult = this.getFunctionBodyNode(this.diagnostics, this.signatureGenerator.hasHeaders(), this.signatureGenerator.hasDefaultHeaders(), this.signatureGenerator.hasQueries(), this.signatureGenerator.getHeadersParamName());
        if (functionBodyNodeResult.isEmpty()) {
            return Optional.empty();
        }
        FunctionBodyNode functionBodyNode = functionBodyNodeResult.get();
        return this.getFunctionDefinitionNode((NodeList<Token>)qualifierList, functionKeyWord, functionName, functionSignatureNode, functionBodyNode);
    }

    protected Optional<FunctionBodyNode> getFunctionBodyNode(List<ClientDiagnostic> diagnostics, boolean hasHeaders, boolean hasDefaultHeaders, boolean hasQueries, String headersParamName) {
        FunctionBodyGeneratorImp functionBodyGenerator = new FunctionBodyGeneratorImp(this.path, this.operation, this.openAPI, this.authConfigGeneratorImp, this.ballerinaUtilGenerator, this.imports, hasHeaders, hasDefaultHeaders, hasQueries, headersParamName);
        Optional<FunctionBodyNode> functionBodyNodeResult = functionBodyGenerator.getFunctionBodyNode();
        if (functionBodyNodeResult.isEmpty()) {
            diagnostics.addAll(functionBodyGenerator.getDiagnostics());
        }
        return functionBodyNodeResult;
    }

    protected Optional<FunctionDefinitionNode> getFunctionDefinitionNode(NodeList<Token> qualifierList, Token functionKeyWord, IdentifierToken functionName, FunctionSignatureNode functionSignatureNode, FunctionBodyNode functionBodyNode) {
        return Optional.of(NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, null, qualifierList, (Token)functionKeyWord, (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode));
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public boolean hasDefaultStatusCodeBinding() {
        return this.signatureGenerator.hasDefaultStatusCodeBinding();
    }

    @Override
    public List<String> getNonDefaultStatusCodes() {
        return this.signatureGenerator.getNonDefaultStatusCodes();
    }
}

