/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.client.ServerURLGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ServerURLGeneratorImp
implements ServerURLGenerator {
    private final List<Server> servers;
    private List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();

    public ServerURLGeneratorImp(List<Server> servers) {
        this.servers = servers;
    }

    @Override
    public ParameterNode generateServerURL() {
        String serverURL;
        Server selectedServer = this.servers.get(0);
        if (!selectedServer.getUrl().startsWith("https:") && this.servers.size() > 1) {
            for (Server server : this.servers) {
                if (!server.getUrl().startsWith("https:")) continue;
                selectedServer = server;
                break;
            }
        }
        if (selectedServer.getUrl() == null) {
            return this.getServiceURLNode("/");
        }
        if (selectedServer.getVariables() != null) {
            ServerVariables variables = selectedServer.getVariables();
            for (ServerVariable variable : variables.values()) {
                if (!variable.getDefault().isBlank() || variable.getEnum() != null) continue;
                DiagnosticMessages diagnosticMessages = DiagnosticMessages.OAS_CLIENT_105;
                ClientDiagnosticImp diagnostic = new ClientDiagnosticImp(diagnosticMessages, new String[0]);
                this.diagnostics.add(diagnostic);
                return this.getServiceURLNode("/");
            }
            String resolvedUrl = GeneratorUtils.buildUrl(selectedServer.getUrl(), variables);
            try {
                URL url = new URL(resolvedUrl);
                serverURL = url.toString();
            }
            catch (MalformedURLException e) {
                serverURL = "/";
                ClientDiagnosticImp diagnostic = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_106, selectedServer.getUrl());
                this.diagnostics.add(diagnostic);
            }
        } else {
            serverURL = selectedServer.getUrl();
        }
        return this.getServiceURLNode(serverURL);
    }

    private ParameterNode getServiceURLNode(String serviceUrl) {
        RequiredParameterNode serviceURLNode;
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode serviceURLType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"string"));
        IdentifierToken serviceURLVarName = AbstractNodeFactory.createIdentifierToken((String)"serviceUrl");
        if (serviceUrl.equals("/")) {
            serviceURLNode = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)serviceURLType, (Token)serviceURLVarName);
        } else {
            BasicLiteralNode expression = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + serviceUrl + "\"")));
            serviceURLNode = NodeFactory.createDefaultableParameterNode((NodeList)annotationNodes, (Node)serviceURLType, (Token)serviceURLVarName, (Token)AbstractNodeFactory.createIdentifierToken((String)"="), (Node)expression);
        }
        return serviceURLNode;
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

