/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.mock;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.client.FunctionGenerator;
import io.ballerina.openapi.core.generators.client.FunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.RemoteFunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.ResourceFunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.client.mock.MockFunctionBodyGenerator;
import io.ballerina.openapi.core.generators.client.model.OASClientConfig;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class MockClientFunctionGenerator
implements FunctionGenerator {
    String path;
    Map.Entry<PathItem.HttpMethod, Operation> operation;
    OpenAPI openAPI;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    boolean isResourceFunction;
    OASClientConfig oasClientConfig;
    FunctionSignatureGenerator signatureGenerator;

    public MockClientFunctionGenerator(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OASClientConfig oasClientConfig) {
        this.path = path;
        this.operation = operation;
        this.openAPI = oasClientConfig.getOpenAPI();
        this.isResourceFunction = oasClientConfig.isResourceMode();
        this.oasClientConfig = oasClientConfig;
        this.signatureGenerator = oasClientConfig.isResourceMode() ? new ResourceFunctionSignatureGenerator(operation.getValue(), this.openAPI, operation.getKey().toString().toLowerCase(Locale.ENGLISH), path) : new RemoteFunctionSignatureGenerator(operation.getValue(), this.openAPI, operation.getKey().toString().toLowerCase(Locale.ENGLISH), path);
    }

    @Override
    public Optional<FunctionDefinitionNode> generateFunction() {
        if (this.isResourceFunction) {
            NodeList<Node> relativeResourcePath;
            NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RESOURCE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
            Token functionKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD);
            String method = this.operation.getKey().toString().toLowerCase(Locale.ROOT);
            IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)method);
            ArrayList<Diagnostic> pathDiagnostics = new ArrayList<Diagnostic>();
            try {
                relativeResourcePath = GeneratorUtils.getRelativeResourcePath(this.path, this.operation.getValue(), this.openAPI.getComponents(), false, pathDiagnostics);
            }
            catch (BallerinaOpenApiException e) {
                DiagnosticMessages diagnosticMessages = DiagnosticMessages.OAS_CLIENT_107;
                ClientDiagnosticImp clientDiagnosticImp = new ClientDiagnosticImp(diagnosticMessages, new String[0]);
                this.diagnostics.add(clientDiagnosticImp);
                return Optional.empty();
            }
            if (!pathDiagnostics.isEmpty()) {
                pathDiagnostics.forEach(diagnostic -> {
                    if (diagnostic.diagnosticInfo().code().equals("OAS_COMMON_204")) {
                        DiagnosticMessages message = DiagnosticMessages.OAS_CLIENT_110;
                        ClientDiagnosticImp clientDiagnostic = new ClientDiagnosticImp(message, this.path, method);
                        this.diagnostics.add(clientDiagnostic);
                    }
                });
                return Optional.empty();
            }
            Optional<FunctionSignatureNode> signatureNodeOptional = this.signatureGenerator.generateFunctionSignature();
            this.diagnostics.addAll(this.signatureGenerator.getDiagnostics());
            if (signatureNodeOptional.isEmpty()) {
                return Optional.empty();
            }
            FunctionSignatureNode signatureNode = signatureNodeOptional.get();
            MockFunctionBodyGenerator bodyGenerator = new MockFunctionBodyGenerator(this.path, this.operation, this.openAPI, this.oasClientConfig.isStatusCodeBinding());
            Optional<FunctionBodyNode> functionBodyOptionalNode = bodyGenerator.getFunctionBodyNode();
            this.diagnostics.addAll(bodyGenerator.getDiagnostics());
            if (functionBodyOptionalNode.isEmpty()) {
                return Optional.empty();
            }
            FunctionBodyNode functionBodyNode = functionBodyOptionalNode.get();
            return Optional.of(NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, null, (NodeList)qualifierList, (Token)functionKeyWord, (IdentifierToken)functionName, relativeResourcePath, (FunctionSignatureNode)signatureNode, (FunctionBodyNode)functionBodyNode));
        }
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.REMOTE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        Token functionKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD);
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)this.operation.getValue().getOperationId());
        Optional<FunctionSignatureNode> signatureNodeOptional = this.signatureGenerator.generateFunctionSignature();
        this.diagnostics.addAll(this.signatureGenerator.getDiagnostics());
        if (signatureNodeOptional.isEmpty()) {
            return Optional.empty();
        }
        FunctionSignatureNode functionSignatureNode = signatureNodeOptional.get();
        MockFunctionBodyGenerator bodyGenerator = new MockFunctionBodyGenerator(this.path, this.operation, this.openAPI, this.oasClientConfig.isStatusCodeBinding());
        Optional<FunctionBodyNode> functionBodyOptionalNode = bodyGenerator.getFunctionBodyNode();
        this.diagnostics.addAll(bodyGenerator.getDiagnostics());
        if (functionBodyOptionalNode.isEmpty()) {
            return Optional.empty();
        }
        FunctionBodyNode functionBodyNode = functionBodyOptionalNode.get();
        return Optional.of(NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, null, (NodeList)qualifierList, (Token)functionKeyWord, (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode));
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public boolean hasDefaultStatusCodeBinding() {
        return this.signatureGenerator.hasDefaultStatusCodeBinding();
    }

    @Override
    public List<String> getNonDefaultStatusCodes() {
        return this.signatureGenerator.getNonDefaultStatusCodes();
    }
}

