/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.parameter;

import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface ParameterGenerator {
    public Optional<ParameterNode> generateParameterNode();

    public List<ClientDiagnostic> getDiagnostics();

    default public Schema getSchemaWithDetails(Parameter parameter) {
        Schema schema = parameter.getSchema();
        if (Objects.isNull(schema)) {
            return null;
        }
        Optional.ofNullable(parameter.getDescription()).ifPresent(arg_0 -> ((Schema)schema).setDescription(arg_0));
        Optional.ofNullable(parameter.getDeprecated()).ifPresent(arg_0 -> ((Schema)schema).setDeprecated(arg_0));
        HashMap<String, String> extensions = parameter.getExtensions();
        if (Objects.isNull(extensions)) {
            extensions = new HashMap<String, String>();
        }
        extensions.put("x-param-type", parameter.getIn());
        schema.setExtensions(extensions);
        return schema;
    }
}

