/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.parameter;

import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RequestBodyHeaderParameter {
    Map.Entry<String, Header> header;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();

    RequestBodyHeaderParameter(Map.Entry<String, Header> header) {
        this.header = header;
    }

    public Optional<Parameter> generateParameterSchema() {
        Schema schema = this.getSchemaWithDescription(this.header.getValue());
        Parameter parameter = new Parameter();
        parameter.setSchema(schema);
        parameter.setName(this.header.getKey());
        parameter.setIn("header");
        parameter.setRequired(this.header.getValue().getRequired());
        return Optional.of(parameter);
    }

    private Schema getSchemaWithDescription(Header header) {
        Schema schema = header.getSchema();
        schema.setDescription(header.getDescription());
        if (!Boolean.TRUE.equals(header.getRequired())) {
            schema.setNullable(Boolean.valueOf(true));
        }
        return schema;
    }

    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

