/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.common;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class InlineModelResolver {
    private OpenAPI openAPI;
    Map<String, Schema> addedModels = new HashMap<String, Schema>();
    Map<String, String> generatedSignature = new HashMap<String, String>();
    private final boolean flattenComposedSchemas;
    private boolean skipMatches;

    public InlineModelResolver() {
        this(false, false);
    }

    public InlineModelResolver(boolean flattenComposedSchemas) {
        this(flattenComposedSchemas, false);
    }

    public InlineModelResolver(boolean flattenComposedSchemas, boolean skipMatches) {
        this.flattenComposedSchemas = flattenComposedSchemas;
        this.skipMatches = skipMatches;
    }

    public void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().setSchemas(new HashMap());
        }
        Paths paths = openAPI.getPaths();
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
        this.flattenPaths((Map<String, PathItem>)paths);
        Map models = openAPI.getComponents().getSchemas();
        this.flattenDefinitions(models);
    }

    private void flattenPaths(Map<String, PathItem> paths) {
        if (paths == null) {
            return;
        }
        for (Map.Entry<String, PathItem> pathEntry : paths.entrySet()) {
            PathItem path = pathEntry.getValue();
            String pathname = pathEntry.getKey();
            for (Operation operation : path.readOperations()) {
                this.flattenBody(pathname, operation.getRequestBody());
                this.flattenParams(pathname, operation.getParameters());
                this.flattenResponses(pathname, (Map<String, ApiResponse>)operation.getResponses());
            }
        }
    }

    private void flattenBody(String pathname, RequestBody body) {
        if (body == null) {
            return;
        }
        Content content = body.getContent();
        if (content == null) {
            return;
        }
        for (Map.Entry keyEntry : content.entrySet()) {
            String modelName;
            ArraySchema am;
            Schema inner;
            String modelName2;
            MediaType mediaType;
            String key = (String)keyEntry.getKey();
            if (keyEntry.getValue() == null || (mediaType = (MediaType)content.get(key)).getSchema() == null) continue;
            Schema model = mediaType.getSchema();
            String genericName = InlineModelResolver.pathBody(pathname);
            if (model.getProperties() != null && !model.getProperties().isEmpty()) {
                this.flattenProperties(model.getProperties(), pathname);
                modelName2 = this.resolveModelName(model.getTitle(), genericName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    mediaType.setSchema(new Schema().$ref(existing));
                    continue;
                }
                mediaType.setSchema(new Schema().$ref(modelName2));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (model instanceof ComposedSchema) {
                ComposedSchema composedSchema = (ComposedSchema)model;
                this.flattenComposedSchema(composedSchema, pathname);
                if (model.get$ref() != null) continue;
                modelName2 = this.resolveModelName(model.getTitle(), genericName);
                mediaType.setSchema(this.makeRefProperty(modelName2, model));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (!(model instanceof ArraySchema) || !this.isObjectSchema(inner = (am = (ArraySchema)model).getItems())) continue;
            if (inner.getProperties() != null && !inner.getProperties().isEmpty()) {
                this.flattenProperties(inner.getProperties(), pathname);
                modelName = this.resolveModelName(inner.getTitle(), genericName);
                String existing = this.matchGenerated(inner);
                if (existing != null) {
                    am.setItems(new Schema().$ref(existing));
                    continue;
                }
                am.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, inner);
                this.openAPI.getComponents().addSchemas(modelName, inner);
                continue;
            }
            if (!(inner instanceof ComposedSchema)) continue;
            ComposedSchema composedSchema = (ComposedSchema)inner;
            if (!this.flattenComposedSchemas) continue;
            this.flattenComposedSchema(composedSchema, key);
            if (inner.get$ref() != null) continue;
            modelName = this.resolveModelName(inner.getTitle(), "inline_body_items_" + key + "_" + pathname);
            am.setItems(this.makeRefProperty(modelName, inner));
            this.addGenerated(modelName, inner);
            this.openAPI.getComponents().addSchemas(modelName, inner);
        }
    }

    private void flattenParams(String pathname, List<Parameter> parameters) {
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            String modelName;
            ArraySchema am;
            Schema inner;
            String modelName2;
            if (parameter.getSchema() == null) continue;
            Schema model = parameter.getSchema();
            if (model.getProperties() != null) {
                if (model.getType() != null && !"object".equals(model.getType()) || model.getProperties() == null || model.getProperties().isEmpty()) continue;
                this.flattenProperties(model.getProperties(), pathname);
                modelName2 = this.resolveModelName(model.getTitle(), parameter.getName());
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    parameter.setSchema(new Schema().$ref(existing));
                    continue;
                }
                parameter.setSchema(new Schema().$ref(modelName2));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (model instanceof ComposedSchema) {
                modelName2 = this.resolveModelName(model.getTitle(), parameter.getName());
                parameter.setSchema(new Schema().$ref(modelName2));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (!(model instanceof ArraySchema) || !this.isObjectSchema(inner = (am = (ArraySchema)model).getItems())) continue;
            if (inner.getProperties() != null && !inner.getProperties().isEmpty()) {
                this.flattenProperties(inner.getProperties(), pathname);
                modelName = this.resolveModelName(inner.getTitle(), parameter.getName());
                String existing = this.matchGenerated(inner);
                if (existing != null) {
                    am.setItems(new Schema().$ref(existing));
                    continue;
                }
                am.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, (Schema)am);
                this.openAPI.getComponents().addSchemas(modelName, (Schema)am);
                continue;
            }
            if (!(inner instanceof ComposedSchema)) continue;
            ComposedSchema composedSchema = (ComposedSchema)inner;
            if (!this.flattenComposedSchemas) continue;
            this.flattenComposedSchema(composedSchema, parameter.getName());
            if (inner.get$ref() != null) continue;
            modelName = this.resolveModelName(inner.getTitle(), "inline_parameter_items_" + parameter.getName());
            am.setItems(this.makeRefProperty(modelName, inner));
            this.addGenerated(modelName, inner);
            this.openAPI.getComponents().addSchemas(modelName, inner);
        }
    }

    private void flattenResponses(String pathname, Map<String, ApiResponse> responses) {
        if (responses == null) {
            return;
        }
        for (Map.Entry<String, ApiResponse> entry : responses.entrySet()) {
            Object key = entry.getKey();
            ApiResponse response = responses.get(key);
            if (response.getContent() == null) continue;
            Content content = response.getContent();
            for (Map.Entry contentEntry : content.entrySet()) {
                Schema innerProperty;
                MediaType media;
                String name = (String)contentEntry.getKey();
                if (content.get(name) == null || (media = (MediaType)content.get(name)).getSchema() == null) continue;
                Schema mediaSchema = media.getSchema();
                if (this.isObjectSchema(mediaSchema)) {
                    ArraySchema arraySchema;
                    Schema inner;
                    if (mediaSchema.getProperties() != null && !mediaSchema.getProperties().isEmpty() || mediaSchema instanceof ComposedSchema) {
                        String modelName = this.resolveModelName(mediaSchema.getTitle(), "inline_response_" + (String)key);
                        String existing = this.matchGenerated(mediaSchema);
                        if (existing != null) {
                            media.setSchema(this.makeRefProperty(existing, mediaSchema));
                            continue;
                        }
                        media.setSchema(this.makeRefProperty(modelName, mediaSchema));
                        this.addGenerated(modelName, mediaSchema);
                        this.openAPI.getComponents().addSchemas(modelName, mediaSchema);
                        continue;
                    }
                    if (mediaSchema.getAdditionalProperties() == null || mediaSchema.getAdditionalProperties() instanceof Boolean) continue;
                    innerProperty = (Schema)mediaSchema.getAdditionalProperties();
                    if (this.isObjectSchema(innerProperty)) {
                        key = "inline_response_map" + (String)key;
                        this.flattenMapSchema(innerProperty, (String)key, pathname, mediaSchema);
                        continue;
                    }
                    if (!(innerProperty instanceof ArraySchema) || !this.isObjectSchema(inner = (arraySchema = (ArraySchema)innerProperty).getItems())) continue;
                    key = "inline_response_map_items" + (String)key;
                    this.flattenMapSchema(inner, (String)key, pathname, mediaSchema);
                    continue;
                }
                if (mediaSchema instanceof ArraySchema) {
                    ArraySchema ap = (ArraySchema)mediaSchema;
                    Schema inner = ap.getItems();
                    if (!this.isObjectSchema(inner)) continue;
                    this.flattenArraySchema(inner, (String)key, pathname, ap);
                    continue;
                }
                if (mediaSchema.getAdditionalProperties() == null || mediaSchema.getAdditionalProperties() instanceof Boolean || !this.isObjectSchema(innerProperty = (Schema)mediaSchema.getAdditionalProperties())) continue;
                key = "inline_response_map" + (String)key;
                this.flattenMapSchema(innerProperty, (String)key, pathname, mediaSchema);
            }
        }
    }

    private void flattenDefinitions(Map<String, Schema> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> modelNames = new ArrayList<String>(models.keySet());
        for (String modelName : modelNames) {
            Schema model = models.get(modelName);
            if (model.getProperties() != null) {
                Map properties = model.getProperties();
                this.flattenProperties(properties, modelName);
                this.fixStringModel(model);
                continue;
            }
            if (model instanceof ArraySchema) {
                ArraySchema m = (ArraySchema)model;
                Schema inner = m.getItems();
                if (!this.isObjectSchema(inner)) continue;
                if (inner.getProperties() != null && !inner.getProperties().isEmpty()) {
                    String innerModelName = this.resolveModelName(inner.getTitle(), modelName + "_inner");
                    String existing = this.matchGenerated(inner);
                    if (existing == null) {
                        this.openAPI.getComponents().addSchemas(innerModelName, inner);
                        this.addGenerated(innerModelName, inner);
                        m.setItems(new Schema().$ref(innerModelName));
                        continue;
                    }
                    m.setItems(new Schema().$ref(existing));
                    continue;
                }
                if (!(inner instanceof ComposedSchema)) continue;
                ComposedSchema composedSchema = (ComposedSchema)inner;
                if (!this.flattenComposedSchemas) continue;
                this.flattenComposedSchema(composedSchema, modelName);
                if (inner.get$ref() != null) continue;
                modelName = this.resolveModelName(inner.getTitle(), "inline_array_items_" + modelName);
                m.setItems(this.makeRefProperty(modelName, inner));
                this.addGenerated(modelName, inner);
                this.openAPI.getComponents().addSchemas(modelName, inner);
                continue;
            }
            if (!(model instanceof ComposedSchema)) continue;
            ComposedSchema composedSchema = (ComposedSchema)model;
            String inlineModelName = "";
            List list = null;
            if (composedSchema.getAllOf() != null) {
                list = this.getEffectiveAllOfSchemas(modelName, composedSchema);
                inlineModelName = "AllOf";
            } else if (composedSchema.getAnyOf() != null) {
                list = composedSchema.getAnyOf();
                inlineModelName = "AnyOf";
            } else if (composedSchema.getOneOf() != null) {
                list = composedSchema.getOneOf();
                inlineModelName = "OneOf";
            }
            for (int i = 0; i < Objects.requireNonNull(list).size(); ++i) {
                if (((Schema)list.get(i)).get$ref() != null) continue;
                Schema inline = (Schema)list.get(i);
                if (inline.getProperties() != null) {
                    this.flattenProperties(inline.getProperties(), modelName);
                }
                if (!this.flattenComposedSchemas) continue;
                int position = i + 1;
                inlineModelName = this.resolveModelName(inline.getTitle(), modelName + inlineModelName + "_" + position);
                list.set(i, new Schema().$ref(inlineModelName));
                this.addGenerated(inlineModelName, inline);
                this.openAPI.getComponents().addSchemas(inlineModelName, inline);
            }
        }
    }

    private void flattenArraySchema(Schema inner, String key, String pathname, ArraySchema ap) {
        if (inner.getProperties() != null && !inner.getProperties().isEmpty()) {
            this.flattenProperties(inner.getProperties(), pathname);
            key = "inline_response_" + (String)key;
            String modelName = this.resolveModelName(inner.getTitle(), (String)key);
            String existing = this.matchGenerated(inner);
            if (existing != null) {
                ap.setItems(this.makeRefProperty(existing, inner));
            } else {
                ap.setItems(this.makeRefProperty(modelName, inner));
                this.addGenerated(modelName, inner);
                this.openAPI.getComponents().addSchemas(modelName, inner);
            }
        } else if (inner instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)inner;
            if (this.flattenComposedSchemas) {
                this.flattenComposedSchema(composedSchema, (String)key);
                if (inner.get$ref() == null) {
                    key = "inline_response_items" + (String)key;
                    String modelName = this.resolveModelName(inner.getTitle(), (String)key);
                    ap.setItems(this.makeRefProperty(modelName, inner));
                    this.addGenerated(modelName, inner);
                    this.openAPI.getComponents().addSchemas(modelName, inner);
                }
            }
        }
    }

    private void flattenMapSchema(Schema innerProperty, String key, String pathname, Schema mediaSchema) {
        if (innerProperty.getProperties() != null && !innerProperty.getProperties().isEmpty()) {
            this.flattenProperties(innerProperty.getProperties(), pathname);
            String modelName = this.resolveModelName(innerProperty.getTitle(), key);
            String existing = this.matchGenerated(innerProperty);
            if (existing != null) {
                mediaSchema.setAdditionalProperties((Object)new Schema().$ref(existing));
            } else {
                mediaSchema.setAdditionalProperties((Object)new Schema().$ref(modelName));
                this.addGenerated(modelName, innerProperty);
                this.openAPI.getComponents().addSchemas(modelName, innerProperty);
            }
        } else if (innerProperty instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)innerProperty;
            if (this.flattenComposedSchemas) {
                this.flattenComposedSchema(composedSchema, key);
                if (innerProperty.get$ref() == null) {
                    String modelName = this.resolveModelName(innerProperty.getTitle(), key);
                    mediaSchema.setAdditionalProperties((Object)new Schema().$ref(modelName));
                    this.addGenerated(modelName, innerProperty);
                    this.openAPI.getComponents().addSchemas(modelName, innerProperty);
                }
            }
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (m.getType() != null && m.getType().equals("string") && m.getExample() != null && (example = m.getExample().toString()).charAt(0) == '\"' && example.endsWith("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private static String pathBody(String pathname) {
        String[] parts = pathname.split("/");
        StringBuilder body = new StringBuilder();
        if (parts.length > 2) {
            body.append(InlineModelResolver.normalize(parts[parts.length - 2])).append('_');
        }
        if (parts.length > 1) {
            body.append(InlineModelResolver.normalize(parts[parts.length - 1])).append('_');
        }
        body.append("body");
        return body.toString();
    }

    private static String normalize(String pathPart) {
        return pathPart.replace(".", "_");
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Schema model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty((Object)model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Schema model) {
        this.generatedSignature.put(Json.pretty((Object)model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        String concatenated = "";
        for (int i = 0; i < key.split("[-|\\s|_]").length; ++i) {
            Object uniqueKey = key.split("[-|\\s|_]")[i];
            if (((String)uniqueKey).isEmpty()) continue;
            uniqueKey = ((String)uniqueKey).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)uniqueKey).substring(1);
            concatenated = concatenated.concat((String)uniqueKey);
        }
        key = concatenated.replaceAll("[^a-z_A-Z0-9 ]", "");
        do {
            Object name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.openAPI.getComponents().getSchemas() == null) {
                return name;
            }
            if (this.openAPI.getComponents().getSchemas().containsKey(name)) continue;
            return name;
        } while (++count <= 1000000);
        throw new RuntimeException("ERROR: Too many models with the same name. Please check your OpenAPI definition.");
    }

    public void flattenProperties(Map<String, Schema> properties, String path) {
        String key;
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            Schema inner;
            key = entry.getKey();
            Schema property = properties.get(key);
            if (this.isObjectSchema(property) && property.getProperties() != null && !property.getProperties().isEmpty()) {
                String modelName = this.resolveModelName(property.getTitle(), path + "_" + key);
                Schema model = this.createModelFromProperty(property, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    propsToUpdate.put(key, new Schema().$ref(existing));
                    continue;
                }
                propsToUpdate.put(key, new Schema().$ref(modelName));
                modelsToAdd.put(modelName, model);
                this.addGenerated(modelName, model);
                this.openAPI.getComponents().addSchemas(modelName, model);
                continue;
            }
            if (property instanceof ArraySchema) {
                String existing;
                Schema innerModel;
                String modelName;
                ArraySchema ap = (ArraySchema)property;
                inner = ap.getItems();
                if (!this.isObjectSchema(inner)) continue;
                if (inner.getProperties() != null && !inner.getProperties().isEmpty()) {
                    this.flattenProperties(inner.getProperties(), path);
                    modelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
                    innerModel = this.createModelFromProperty(inner, modelName);
                    existing = this.matchGenerated(innerModel);
                    if (existing != null) {
                        ap.setItems(new Schema().$ref(existing));
                        continue;
                    }
                    ap.setItems(new Schema().$ref(modelName));
                    this.addGenerated(modelName, innerModel);
                    this.openAPI.getComponents().addSchemas(modelName, innerModel);
                    continue;
                }
                if (!(inner instanceof ComposedSchema)) continue;
                ComposedSchema composedSchema = (ComposedSchema)inner;
                if (!this.flattenComposedSchemas) continue;
                this.flattenComposedSchema(composedSchema, key);
                modelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
                innerModel = this.createModelFromProperty(inner, modelName);
                existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    ap.setItems(new Schema().$ref(existing));
                    continue;
                }
                ap.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, innerModel);
                this.openAPI.getComponents().addSchemas(modelName, innerModel);
                continue;
            }
            if (property.getAdditionalProperties() == null || property.getAdditionalProperties() instanceof Boolean || !this.isObjectSchema(inner = (Schema)property.getAdditionalProperties()) || inner.getProperties() == null || inner.getProperties().isEmpty()) continue;
            this.flattenProperties(inner.getProperties(), path);
            String modelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
            Schema innerModel = this.createModelFromProperty(inner, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                property.setAdditionalProperties((Object)new Schema().$ref(existing));
                continue;
            }
            property.setAdditionalProperties((Object)new Schema().$ref(modelName));
            this.addGenerated(modelName, innerModel);
            this.openAPI.getComponents().addSchemas(modelName, innerModel);
        }
        if (!propsToUpdate.isEmpty()) {
            for (Map.Entry<String, Object> entry : propsToUpdate.entrySet()) {
                properties.put(entry.getKey(), (Schema)entry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : modelsToAdd.entrySet()) {
            key = entry.getKey();
            Schema value = (Schema)entry.getValue();
            this.openAPI.getComponents().addSchemas(key, value);
            this.addedModels.put(key, value);
        }
    }

    private List<Schema> getEffectiveAllOfSchemas(String key, ComposedSchema composedSchema) {
        List list = composedSchema.getAllOf();
        if (list == null) {
            return List.of();
        }
        long inlineCount = list.stream().filter(schema -> schema.get$ref() == null).count();
        if (inlineCount == 1L) {
            this.openAPI.getComponents().addSchemas(key, (Schema)composedSchema);
            return List.of();
        }
        return list;
    }

    private void flattenComposedSchema(ComposedSchema composedSchema, String key) {
        String inlineModelName = "";
        List list = null;
        if (composedSchema.getAllOf() != null) {
            list = this.getEffectiveAllOfSchemas(key, composedSchema);
            inlineModelName = "AllOf";
        } else if (composedSchema.getAnyOf() != null) {
            list = composedSchema.getAnyOf();
            inlineModelName = "AnyOf";
        } else if (composedSchema.getOneOf() != null) {
            list = composedSchema.getOneOf();
            inlineModelName = "OneOf";
        }
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (((Schema)list.get(i)).get$ref() != null) continue;
            Schema inline = (Schema)list.get(i);
            if (inline.getProperties() != null) {
                this.flattenProperties(inline.getProperties(), key);
            }
            if (!this.flattenComposedSchemas) continue;
            int position = i + 1;
            inlineModelName = this.resolveModelName(inline.getTitle(), key + inlineModelName + "_" + position);
            list.set(i, new Schema().$ref(inlineModelName));
            this.addGenerated(inlineModelName, inline);
            this.openAPI.getComponents().addSchemas(inlineModelName, inline);
        }
    }

    public Schema modelFromProperty(ArraySchema object, String path) {
        Schema inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()) instanceof ObjectSchema) {
            ArraySchema model = new ArraySchema();
            model.setDescription(description);
            if (example != null || object.getExampleSetFlag()) {
                model.setExample((Object)example);
            }
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Schema createModelFromProperty(Schema schema, String path) {
        String description = schema.getDescription();
        String example = null;
        List requiredList = schema.getRequired();
        Object obj = schema.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = schema.getName();
        XML xml = schema.getXml();
        Map properties = schema.getProperties();
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedModel = (ComposedSchema)schema;
            if (this.flattenComposedSchemas) {
                composedModel.setDescription(description);
                if (example != null || schema.getExampleSetFlag()) {
                    composedModel.setExample((Object)example);
                }
                composedModel.setName(name);
                composedModel.setXml(xml);
                composedModel.setType(schema.getType());
                composedModel.setRequired(requiredList);
                return composedModel;
            }
        }
        Schema model = new Schema();
        model.setAdditionalProperties(schema.getAdditionalProperties());
        model.setDescription(description);
        model.setDeprecated(schema.getDeprecated());
        model.setDiscriminator(schema.getDiscriminator());
        model.setEnum(schema.getEnum());
        if (example != null || schema.getExampleSetFlag()) {
            model.setExample((Object)example);
        }
        model.setExclusiveMaximum(schema.getExclusiveMaximum());
        model.setExclusiveMinimum(schema.getExclusiveMinimum());
        model.setFormat(schema.getFormat());
        model.setMinLength(schema.getMinLength());
        model.setMaximum(schema.getMaximum());
        model.setMaxItems(schema.getMaxItems());
        model.setMaxProperties(schema.getMaxProperties());
        model.setMaxLength(schema.getMaxLength());
        model.setMinimum(schema.getMinimum());
        model.setMinItems(schema.getMinItems());
        model.setMinLength(schema.getMinLength());
        model.setMinProperties(schema.getMinProperties());
        model.setMultipleOf(schema.getMultipleOf());
        model.setName(name);
        model.setNullable(schema.getNullable());
        model.setNot(schema.getNot());
        model.setPattern(schema.getPattern());
        model.setReadOnly(schema.getReadOnly());
        model.setRequired(requiredList);
        model.setUniqueItems(schema.getUniqueItems());
        model.setTitle(schema.getTitle());
        model.setType(schema.getType());
        model.setXml(xml);
        model.setWriteOnly(schema.getWriteOnly());
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        if (schema instanceof ComposedSchema) {
            model.setAllOf(((ComposedSchema)schema).getAllOf());
            model.setAnyOf(((ComposedSchema)schema).getAnyOf());
            model.setOneOf(((ComposedSchema)schema).getOneOf());
        }
        return model;
    }

    public Schema modelFromProperty(Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        ArraySchema model = new ArraySchema();
        model.setDescription(description);
        if (example != null || object.getExampleSetFlag()) {
            model.setExample((Object)example);
        }
        if (object.getAdditionalProperties() != null && !(object.getAdditionalProperties() instanceof Boolean)) {
            model.setItems((Schema)object.getAdditionalProperties());
        }
        return model;
    }

    public Schema makeRefProperty(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Schema source, Schema target) {
        if (source.getExtensions() != null) {
            Map vendorExtensions = source.getExtensions();
            for (Map.Entry entry : vendorExtensions.entrySet()) {
                target.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private boolean isObjectSchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        return schema instanceof ObjectSchema || "object".equalsIgnoreCase(schema.getType()) || schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty() || schema instanceof ComposedSchema;
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }
}

