/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.common;

import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.openapi.core.generators.common.diagnostic.CommonDiagnostic;
import io.ballerina.openapi.core.generators.common.diagnostic.CommonDiagnosticMessages;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeFixer {
    private final Map<String, TypeDefinitionNode> types;
    private final List<Diagnostic> diagnostics;

    public TypeFixer(Map<String, TypeDefinitionNode> types, List<Diagnostic> diagnostics) {
        this.types = types;
        this.diagnostics = diagnostics;
    }

    public void apply() {
        this.types.keySet().forEach(this::fixType);
    }

    private void fixType(String typeName) {
        TypeDefinitionNode typeDefinition = this.types.get(typeName);
        if (typeDefinition == null) {
            return;
        }
        Node typeDesc = typeDefinition.typeDescriptor();
        if (!(typeDesc instanceof RecordTypeDescriptorNode)) {
            return;
        }
        RecordTypeDescriptorNode recordTypeDesc = (RecordTypeDescriptorNode)typeDesc;
        HashMap<String, RecordFieldNode> definedFields = new HashMap<String, RecordFieldNode>();
        HashMap<String, List<RecordFieldNode>> includedFields = new HashMap<String, List<RecordFieldNode>>();
        this.processRecordFields((NodeList<Node>)recordTypeDesc.fields(), definedFields, includedFields);
        this.addResolvedFieldsToRecord(typeName, recordTypeDesc, definedFields, includedFields);
    }

    private void processRecordFields(NodeList<Node> fields, Map<String, RecordFieldNode> definedFields, Map<String, List<RecordFieldNode>> includedFields) {
        for (Node field : fields) {
            if (field instanceof TypeReferenceNode) {
                TypeReferenceNode typeRef = (TypeReferenceNode)field;
                this.processIncludedType(typeRef, includedFields);
                continue;
            }
            if (!(field instanceof RecordFieldNode)) continue;
            RecordFieldNode recordField = (RecordFieldNode)field;
            definedFields.put(recordField.fieldName().text(), recordField);
        }
    }

    private void processIncludedType(TypeReferenceNode typeRef, Map<String, List<RecordFieldNode>> includedFields) {
        String typeName = TypeFixer.extractTypeName(typeRef);
        if (typeName != null) {
            Map<String, List<RecordFieldNode>> fields = this.collectRecordFields(typeName, new ArrayList<String>(List.of(typeName)));
            TypeFixer.mergeFields(fields, includedFields);
        }
    }

    private static String extractTypeName(TypeReferenceNode typeRef) {
        String string;
        Node typeName = typeRef.typeName();
        if (typeName instanceof IdentifierToken) {
            IdentifierToken token = (IdentifierToken)typeName;
            string = token.text();
        } else {
            string = null;
        }
        return string;
    }

    private void addResolvedFieldsToRecord(String parentRecordName, RecordTypeDescriptorNode recordTypeDesc, Map<String, RecordFieldNode> definedFields, Map<String, List<RecordFieldNode>> includedFields) {
        Map<String, RecordFieldNode> resolvedFields = this.resolveFieldConflicts(includedFields, parentRecordName);
        for (Map.Entry<String, RecordFieldNode> entry : resolvedFields.entrySet()) {
            if (definedFields.containsKey(entry.getKey())) continue;
            recordTypeDesc = recordTypeDesc.modify().withFields(recordTypeDesc.fields().add((Node)entry.getValue())).apply();
            this.types.put(parentRecordName, this.types.get(parentRecordName).modify().withTypeDescriptor((Node)recordTypeDesc).apply());
        }
    }

    private Map<String, List<RecordFieldNode>> collectRecordFields(String recordTypeName, List<String> visitedRecords) {
        if (visitedRecords.contains(recordTypeName) || !this.types.containsKey(recordTypeName)) {
            return new HashMap<String, List<RecordFieldNode>>();
        }
        TypeDefinitionNode typeDefinition = this.types.get(recordTypeName);
        Node typeDesc = typeDefinition.typeDescriptor();
        if (!(typeDesc instanceof RecordTypeDescriptorNode)) {
            return new HashMap<String, List<RecordFieldNode>>();
        }
        RecordTypeDescriptorNode recordTypeDesc = (RecordTypeDescriptorNode)typeDesc;
        HashMap<String, List<RecordFieldNode>> recordFields = new HashMap<String, List<RecordFieldNode>>();
        visitedRecords.add(recordTypeName);
        for (Node field : recordTypeDesc.fields()) {
            if (field instanceof TypeReferenceNode) {
                TypeReferenceNode typeRef = (TypeReferenceNode)field;
                String includedTypeName = TypeFixer.extractTypeName(typeRef);
                if (includedTypeName == null) continue;
                Map<String, List<RecordFieldNode>> nestedFields = this.collectRecordFields(includedTypeName, new ArrayList<String>(visitedRecords));
                TypeFixer.mergeFields(nestedFields, recordFields);
                continue;
            }
            if (!(field instanceof RecordFieldNode)) continue;
            RecordFieldNode recordField = (RecordFieldNode)field;
            TypeFixer.addFieldToMap(recordField, recordFields);
        }
        return recordFields;
    }

    private static void addFieldToMap(RecordFieldNode field, Map<String, List<RecordFieldNode>> fieldsMap) {
        String fieldName = field.fieldName().text();
        fieldsMap.computeIfAbsent(fieldName, k -> new ArrayList()).add(field);
    }

    private static void mergeFields(Map<String, List<RecordFieldNode>> source, Map<String, List<RecordFieldNode>> target) {
        source.forEach((key, value) -> target.merge((String)key, (List<RecordFieldNode>)value, (existing, incoming) -> {
            existing.addAll(incoming);
            return existing;
        }));
    }

    private Map<String, RecordFieldNode> resolveFieldConflicts(Map<String, List<RecordFieldNode>> fields, String parentRecordName) {
        HashMap<String, RecordFieldNode> resolvedFields = new HashMap<String, RecordFieldNode>();
        for (Map.Entry<String, List<RecordFieldNode>> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            List<RecordFieldNode> fieldList = entry.getValue();
            RecordFieldNode resolvedField = this.resolveField(fieldList, parentRecordName);
            if (resolvedField == null) continue;
            resolvedFields.put(fieldName, resolvedField);
        }
        return resolvedFields;
    }

    private RecordFieldNode resolveField(List<RecordFieldNode> fields, String parentRecordName) {
        if (fields.isEmpty()) {
            return null;
        }
        if (fields.size() == 1) {
            RecordFieldNode field2 = fields.getFirst();
            return field2.metadata().isPresent() ? field2 : null;
        }
        String firstFieldType = fields.getFirst().typeName().toString();
        boolean allTypesMatch = fields.stream().allMatch(field -> field.typeName().toString().equals(firstFieldType));
        if (!allTypesMatch) {
            String fieldName = fields.getFirst().fieldName().text();
            CommonDiagnostic diagnostic = new CommonDiagnostic(CommonDiagnosticMessages.OAS_COMMON_102, fieldName, parentRecordName);
            this.diagnostics.add(diagnostic);
        }
        return fields.getFirst();
    }
}

