/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.response;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorConstants;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnostic;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.response.ReturnTypeGenerator;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DefaultReturnTypeGenerator
extends ReturnTypeGenerator {
    public DefaultReturnTypeGenerator(OASServiceMetadata oasServiceMetadata, String path) {
        super(oasServiceMetadata, path);
    }

    @Override
    public ReturnTypeDescriptorNode getReturnTypeDescriptorNode(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) {
        ReturnTypeDescriptorNode returnNode;
        String httpMethod = operation.getKey().name().toLowerCase(Locale.ENGLISH);
        if (operation.getValue().getResponses() != null) {
            ApiResponses responses = operation.getValue().getResponses();
            if (responses.size() > 1) {
                TypeDescriptorNode type = this.handleMultipleResponse(responses, httpMethod);
                returnNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)type);
            } else if (responses.size() == 1) {
                Iterator responseIterator = responses.entrySet().iterator();
                Map.Entry response = (Map.Entry)responseIterator.next();
                returnNode = this.handleSingleResponse(response, httpMethod);
            } else {
                SimpleNameReferenceNode defaultType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:Response"));
                returnNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)defaultType);
            }
        } else {
            returnNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"error?")));
        }
        if (GeneratorUtils.isComplexURL(path)) {
            assert (returnNode != null);
            String returnStatement = returnNode.toString().trim().replace("returns", "") + "|error";
            return NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)returnStatement)));
        }
        return returnNode;
    }

    private TypeDescriptorNode handleMultipleResponse(ApiResponses responses, String httpMethod) {
        LinkedHashMap<String, TypeDescriptorNode> qualifiedNodes = new LinkedHashMap<String, TypeDescriptorNode>();
        for (Map.Entry response : responses.entrySet()) {
            String responseCode = ((String)response.getKey()).trim();
            String code = GeneratorConstants.HTTP_CODES_DES.get(responseCode);
            ApiResponse responseValue = (ApiResponse)response.getValue();
            Content content = responseValue != null ? responseValue.getContent() : null;
            QualifiedNameReferenceNode type = null;
            Map responseComponents = this.oasServiceMetadata.getOpenAPI().getComponents().getResponses();
            if (responseValue != null && responseValue.get$ref() != null && responseComponents != null) {
                String[] splits = responseValue.get$ref().split("/");
                String extractReferenceType = splits[splits.length - 1];
                responseValue = (ApiResponse)responseComponents.get(extractReferenceType);
                content = responseValue.getContent();
            }
            if (code == null && !responseCode.equals("default")) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_201, responseCode));
                type = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:Response"));
            } else if (content == null && (responseValue == null || responseValue.get$ref() == null) || content != null && content.isEmpty()) {
                type = GeneratorUtils.getQualifiedNameReferenceNode("http", code);
            } else if (content != null) {
                boolean isWithOutStatusCode;
                boolean bl = isWithOutStatusCode = httpMethod.equals("post") && responseCode.equals("201") || !httpMethod.equals("post") && responseCode.equals("200");
                if (isWithOutStatusCode) {
                    type = this.handleMultipleContents(content.entrySet());
                } else {
                    try {
                        type = GeneratorUtils.generateStatusCodeTypeInclusionRecord(code, responseValue, httpMethod, this.oasServiceMetadata.getOpenAPI(), this.path, this.diagnostics);
                    }
                    catch (InvalidReferenceException e) {
                        this.diagnostics.add(e.getDiagnostic());
                    }
                }
            }
            if (type == null) continue;
            qualifiedNodes.put(type.toString(), (TypeDescriptorNode)type);
        }
        TypeDescriptorNode unionTypeDescriptorNode = GeneratorUtils.getUnionTypeDescriptorNodeFromTypeDescNodes(qualifiedNodes);
        if (unionTypeDescriptorNode.toSourceCode().contains("anydata")) {
            return NodeParser.parseTypeDescriptor((String)"anydata");
        }
        return unionTypeDescriptorNode;
    }

    private TypeDescriptorNode handleMultipleContents(Set<Map.Entry<String, MediaType>> contentEntries) {
        LinkedHashMap<String, TypeDescriptorNode> qualifiedNodes = new LinkedHashMap<String, TypeDescriptorNode>();
        for (Map.Entry<String, MediaType> contentType : contentEntries) {
            TypeDescriptorNode mediaTypeToken = GeneratorUtils.generateTypeDescForMediaType(this.oasServiceMetadata.getOpenAPI(), this.path, false, contentType);
            if (mediaTypeToken == null) {
                return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"anydata"));
            }
            qualifiedNodes.put(mediaTypeToken.toSourceCode(), mediaTypeToken);
        }
        TypeDescriptorNode unionTypeDescriptorNode = GeneratorUtils.getUnionTypeDescriptorNodeFromTypeDescNodes(qualifiedNodes);
        if (unionTypeDescriptorNode.toSourceCode().contains("anydata")) {
            return NodeParser.parseTypeDescriptor((String)"anydata");
        }
        return unionTypeDescriptorNode;
    }

    private ReturnTypeDescriptorNode handleSingleResponse(Map.Entry<String, ApiResponse> response, String httpMethod) {
        ReturnTypeDescriptorNode returnNode = null;
        Token returnKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD);
        ApiResponse responseValue = response.getValue();
        Content responseContent = responseValue.getContent();
        if (responseContent == null && responseValue.get$ref() == null || responseContent != null && responseContent.isEmpty()) {
            String code = GeneratorConstants.HTTP_CODES_DES.get(response.getKey().trim());
            QualifiedNameReferenceNode statues = GeneratorUtils.getQualifiedNameReferenceNode("http", code);
            returnNode = NodeFactory.createReturnTypeDescriptorNode((Token)returnKeyWord, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)statues);
        } else if (responseContent != null) {
            boolean isWithOutStatusCode;
            String responseCode = response.getKey().trim();
            boolean bl = isWithOutStatusCode = httpMethod.equals("post") && responseCode.equals("201") || !httpMethod.equals("post") && responseCode.equals("200");
            if (isWithOutStatusCode) {
                Set contentEntries = responseContent.entrySet();
                TypeDescriptorNode returnType = contentEntries.size() > 1 ? this.handleMultipleContents(contentEntries) : GeneratorUtils.generateTypeDescForMediaType(this.oasServiceMetadata.getOpenAPI(), this.path, false, (Map.Entry)contentEntries.iterator().next());
                returnNode = NodeFactory.createReturnTypeDescriptorNode((Token)returnKeyWord, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnType);
            } else {
                TypeDescriptorNode statusCodeTypeInclusionRecord;
                String code = GeneratorConstants.HTTP_CODES_DES.get(response.getKey().trim());
                try {
                    statusCodeTypeInclusionRecord = GeneratorUtils.generateStatusCodeTypeInclusionRecord(code, responseValue, httpMethod, this.oasServiceMetadata.getOpenAPI(), this.path, this.diagnostics);
                }
                catch (InvalidReferenceException e) {
                    this.diagnostics.add(e.getDiagnostic());
                    statusCodeTypeInclusionRecord = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:Response"));
                }
                returnNode = NodeFactory.createReturnTypeDescriptorNode((Token)returnKeyWord, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)statusCodeTypeInclusionRecord);
            }
        }
        return returnNode;
    }
}

