/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import com.fasterxml.jackson.databind.node.NullNode;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.UnsupportedOASDataTypeException;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.ArrayTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.PrimitiveTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.ReferencedTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.ballerina.openapi.core.generators.type.model.RecordMetadata;
import io.swagger.v3.oas.models.media.Schema;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class RecordTypeGenerator
extends TypeGenerator {
    public static final PrintStream OUT_STREAM = System.err;

    public RecordTypeGenerator(Schema schema, String typeName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        super(schema, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException {
        LinkedList<Node> recordFields = new LinkedList<Node>();
        RecordMetadata metadataBuilder = this.getRecordMetadata();
        if (this.schema.getProperties() != null) {
            Map properties = this.schema.getProperties();
            List required = this.schema.getRequired();
            recordFields.addAll(this.addRecordFields(required, properties.entrySet(), this.typeName));
            NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFields);
            return NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN)), (NodeList)fieldNodes, (RecordRestDescriptorNode)metadataBuilder.getRestDescriptorNode(), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN)));
        }
        return NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN)), (NodeList)AbstractNodeFactory.createNodeList(recordFields), (RecordRestDescriptorNode)metadataBuilder.getRestDescriptorNode(), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN)));
    }

    public RecordMetadata getRecordMetadata() throws OASTypeGenException {
        boolean isOpenRecord = true;
        RecordRestDescriptorNode recordRestDescNode = null;
        if (this.schema.getAdditionalProperties() != null) {
            Object additionalProperties = this.schema.getAdditionalProperties();
            if (additionalProperties instanceof Schema) {
                Schema additionalPropSchema = (Schema)additionalProperties;
                if (additionalPropSchema.get$ref() != null) {
                    isOpenRecord = false;
                    recordRestDescNode = this.getRestDescriptorNodeForReference(additionalPropSchema);
                } else if (GeneratorUtils.getOpenAPIType(additionalPropSchema) != null) {
                    isOpenRecord = false;
                    recordRestDescNode = this.getRecordRestDescriptorNode(additionalPropSchema);
                } else if (GeneratorUtils.isComposedSchema(additionalPropSchema)) {
                    OUT_STREAM.println("WARNING: generating Ballerina rest record field will be ignored for the OpenAPI contract additionalProperties type `ComposedSchema`, as it is not supported on Ballerina rest record field.");
                }
            } else if (additionalProperties.equals(false)) {
                isOpenRecord = false;
            }
        }
        return new RecordMetadata.Builder().withIsOpenRecord(isOpenRecord).withRestDescriptorNode(recordRestDescNode).build();
    }

    public RecordRestDescriptorNode getRestDescriptorNodeForReference(Schema<?> additionalPropSchema) throws OASTypeGenException {
        ReferencedTypeGenerator referencedTypeGenerator = new ReferencedTypeGenerator(additionalPropSchema, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
        TypeDescriptorNode refNode = referencedTypeGenerator.generateTypeDescriptorNode();
        return NodeFactory.createRecordRestDescriptorNode((Node)refNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public RecordRestDescriptorNode getRecordRestDescriptorNode(Schema<?> additionalPropSchema) throws OASTypeGenException {
        RecordRestDescriptorNode recordRestDescNode = null;
        if (GeneratorUtils.isNumberSchema(additionalPropSchema) && additionalPropSchema.getFormat() != null) {
            SimpleNameReferenceNode numberNode = null;
            try {
                numberNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.convertOpenAPITypeToBallerina(additionalPropSchema, this.ignoreNullableFlag)));
            }
            catch (UnsupportedOASDataTypeException e) {
                throw new OASTypeGenException(e.getDiagnostic().message());
            }
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)TypeGeneratorUtils.getNullableType(additionalPropSchema, (TypeDescriptorNode)numberNode, this.ignoreNullableFlag), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else if (GeneratorUtils.isObjectSchema(additionalPropSchema) || GeneratorUtils.isMapSchema(additionalPropSchema)) {
            RecordTypeGenerator record = new RecordTypeGenerator(additionalPropSchema, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode recordNode = TypeGeneratorUtils.getNullableType(additionalPropSchema, record.generateTypeDescriptorNode(), this.ignoreNullableFlag);
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)recordNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else if (GeneratorUtils.isArraySchema(additionalPropSchema)) {
            ArrayTypeGenerator arrayTypeGenerator = new ArrayTypeGenerator(additionalPropSchema, null, this.ignoreNullableFlag, null, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode arrayNode = arrayTypeGenerator.generateTypeDescriptorNode();
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)arrayNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else if (GeneratorUtils.isIntegerSchema(additionalPropSchema) || GeneratorUtils.isStringSchema(additionalPropSchema) || GeneratorUtils.isBooleanSchema(additionalPropSchema)) {
            PrimitiveTypeGenerator primitiveTypeGenerator = new PrimitiveTypeGenerator(additionalPropSchema, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode primitiveNode = primitiveTypeGenerator.generateTypeDescriptorNode();
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)primitiveNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else {
            OUT_STREAM.printf("WARNING: the Ballerina rest record field does not support with the data type `%s`", GeneratorUtils.getOpenAPIType(additionalPropSchema));
        }
        return recordRestDescNode;
    }

    List<Node> addRecordFields(List<String> required, Set<Map.Entry<String, Schema<?>>> fields, String recordName) throws OASTypeGenException {
        List<Object> recordFieldList = new ArrayList<Node>();
        for (Map.Entry<String, Schema<?>> field : fields) {
            String fieldNameStr = GeneratorUtils.escapeIdentifier(field.getKey().trim());
            Schema<?> fieldSchema = field.getValue();
            IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)fieldNameStr);
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator(fieldSchema, fieldNameStr, recordName, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            TypeDescriptorNode fieldTypeName = typeGenerator.generateTypeDescriptorNode();
            this.diagnostics.addAll(typeGenerator.getDiagnostics());
            if (typeGenerator instanceof RecordTypeGenerator) {
                fieldTypeName = TypeGeneratorUtils.getNullableType(fieldSchema, fieldTypeName, this.ignoreNullableFlag);
            }
            this.imports.addAll(typeGenerator.getImports());
            ImmutablePair<List<Node>, Set<String>> fieldListWithImports = this.updateRecordFieldListWithImports(required, recordFieldList, field, fieldSchema, fieldName, fieldTypeName);
            recordFieldList = (List)fieldListWithImports.getLeft();
            this.imports.addAll((Collection)fieldListWithImports.getRight());
        }
        return recordFieldList;
    }

    public ImmutablePair<List<Node>, Set<String>> updateRecordFieldListWithImports(List<String> required, List<Node> recordFieldList, Map.Entry<String, Schema<?>> field, Schema<?> fieldSchema, IdentifierToken fieldName, TypeDescriptorNode fieldTypeName) {
        HashSet imports = new HashSet();
        MetadataNode metadataNode = null;
        Optional<String> fieldNameFromExt = GeneratorUtils.getBallerinaNameExtension(fieldSchema);
        if (fieldNameFromExt.isPresent()) {
            fieldName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier(fieldNameFromExt.get()));
            metadataNode = GeneratorUtils.getNameAnnotationMetadataNode(field.getKey(), fieldSchema);
        }
        if (required != null && required.contains(field.getKey().trim())) {
            this.setRequiredFields(recordFieldList, fieldSchema, fieldName, fieldTypeName, metadataNode);
        } else if (fieldSchema.getDefault() != null) {
            RecordFieldWithDefaultValueNode recordFieldWithDefaultValueNode = this.getRecordFieldWithDefaultValueNode(fieldSchema, fieldName, fieldTypeName, metadataNode);
            recordFieldList.add((Node)recordFieldWithDefaultValueNode);
        } else {
            RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            recordFieldList.add((Node)recordFieldNode);
        }
        return new ImmutablePair(recordFieldList, imports);
    }

    private void setRequiredFields(List<Node> recordFieldList, Schema<?> fieldSchema, IdentifierToken fieldName, TypeDescriptorNode fieldTypeName, MetadataNode metadataNode) {
        if (Objects.nonNull(fieldSchema.getDefault())) {
            RecordFieldWithDefaultValueNode defaultNode = this.getRecordFieldWithDefaultValueNode(fieldSchema, fieldName, fieldTypeName, metadataNode);
            recordFieldList.add((Node)defaultNode);
        } else {
            RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            recordFieldList.add((Node)recordFieldNode);
        }
    }

    private RecordFieldWithDefaultValueNode getRecordFieldWithDefaultValueNode(Schema<?> fieldSchema, IdentifierToken fieldName, TypeDescriptorNode fieldTypeName, MetadataNode metadataNode) {
        NilLiteralNode expressionNode;
        Object defaultValueNode = fieldSchema.getDefault();
        Object defaultValue = defaultValueNode.toString().trim();
        if (defaultValueNode instanceof String || GeneratorUtils.isStringSchema(fieldSchema)) {
            defaultValue = "\"" + ((String)defaultValue).replaceAll("\"", "\\\\\"") + "\"";
        }
        if (defaultValueNode instanceof NullNode) {
            expressionNode = NodeFactory.createNilLiteralNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        } else {
            IdentifierToken defaultValueToken = AbstractNodeFactory.createIdentifierToken((String)defaultValue);
            expressionNode = NodeFactory.createRequiredExpressionNode((Token)defaultValueToken);
        }
        return NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)expressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }
}

